/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.handler;

import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.StructuredSelection;
import org.grits.toolbox.core.datamodel.Entry;

public class RefreshEntryHandler {
    private static final Logger logger = Logger.getLogger(RefreshEntryHandler.class);
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, EPartService partService) {
        MPart projectExplorerPart = partService.findPart("org.grits.toolbox.core.part.projectexplorer");
        if (projectExplorerPart != null && projectExplorerPart.getObject() != null) {
            if (object instanceof StructuredSelection) {
                logger.debug((Object)"Refreshing entries in the project explorer");
                Iterator iterator = ((StructuredSelection)object).iterator();
                Object nextSelection = null;
                while (iterator.hasNext()) {
                    nextSelection = iterator.next();
                    if (!(nextSelection instanceof Entry)) continue;
                    this.eventBroker.post("grits_data_model_changed", nextSelection);
                }
            } else if (object instanceof Entry) {
                logger.debug((Object)"Refreshing the selected entry");
                this.eventBroker.post("grits_data_model_changed", object);
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object) {
        return object instanceof Entry || object instanceof StructuredSelection;
    }
}

