/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.handler;

import java.io.IOException;
import java.util.Iterator;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.editor.EditorHandler;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.core.utils.WorkspaceXMLHandler;

public class DeleteEntryHandler {
    private static final Logger logger = Logger.getLogger(DeleteEntryHandler.class);
    private boolean lastDecision = false;
    private boolean rememberDecision = false;
    private boolean cancelPressed = false;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, IGritsDataModelService gritsDataModelService, IGritsUIService gritsUIService) {
        Entry entry;
        if (object instanceof StructuredSelection) {
            Iterator iterator = ((StructuredSelection)object).iterator();
            Object nextSelection = null;
            Entry entry2 = null;
            while (iterator.hasNext() && !this.cancelPressed) {
                nextSelection = iterator.next();
                if (!(nextSelection instanceof Entry) || !this.confirmDeleteEntry(entry2 = (Entry)nextSelection)) continue;
                this.delete(gritsDataModelService, gritsUIService, entry2);
            }
        } else if (object instanceof Entry && this.confirmDeleteEntry(entry = (Entry)object)) {
            this.delete(gritsDataModelService, gritsUIService, entry);
        }
        this.cancelPressed = false;
        this.rememberDecision = false;
        this.lastDecision = false;
    }

    private void delete(IGritsDataModelService gritsDataModelService, IGritsUIService gritsUIService, Entry entry) {
        this.closeAllParts(entry, gritsUIService);
        try {
            if ("org.grits.toolbox.property.project".equals(entry.getProperty().getType())) {
                try {
                    WorkspaceXMLHandler.removeEntry(entry.getDisplayName());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Unable to update workspace file", e);
                }
            } else {
                try {
                    ProjectFileHandler.deleteEntryFromProject(entry);
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Unable to update project xml", e);
                }
            }
            gritsDataModelService.deleteEntry(entry);
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Unable to delete entry " + entry.getDisplayName(), e1);
        }
    }

    private void closeAllParts(Entry entry, IGritsUIService gritsUIService) {
        for (Entry childEntry : entry.getChildren()) {
            this.closeAllParts(childEntry, gritsUIService);
        }
        this.closePartForEntry(entry, gritsUIService);
    }

    private void closePartForEntry(Entry entry, IGritsUIService gritsUIService) {
        if (!gritsUIService.closePartForEntry(entry) && gritsUIService.findPartDescriptorForEntry(entry) == null) {
            this.handleOldStuff(entry);
        }
    }

    private void handleOldStuff(Entry entry) {
        EditorHandler.closeEditorsForEntry(entry);
    }

    private boolean confirmDeleteEntry(Entry entry) {
        if (!this.rememberDecision) {
            int result = ErrorUtils.createMultiConfirmationMessageBoxReturn(Display.getCurrent().getActiveShell(), "Warning", "\"" + entry.getDisplayName() + "\" will be deleted. Do you still want to proceed?\n", this.rememberDecision);
            if (result == 32) {
                return true;
            }
            if (result == 96) {
                this.rememberDecision = true;
                this.lastDecision = true;
                return true;
            }
            if (result == 192) {
                this.rememberDecision = true;
                this.lastDecision = false;
                return false;
            }
            if (result == 256) {
                this.cancelPressed = true;
                return false;
            }
        }
        return this.lastDecision;
    }

    private static void showMessage(String title, String errorMessage) {
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 32);
        messageBox.setText(title);
        messageBox.setMessage(String.valueOf(title) + "\n\n" + errorMessage);
        messageBox.open();
    }

    static void removeProject(IGritsDataModelService gritsDataModelService, Entry projectEntry) {
        try {
            gritsDataModelService.removeAllChildren(projectEntry);
            WorkspaceXMLHandler.removeEntry(projectEntry.getDisplayName());
        }
        catch (Exception e) {
            logger.fatal((Object)("Error Removing the project\n" + e.getMessage()), (Throwable)e);
            DeleteEntryHandler.showMessage("Error Removing the project", e.getMessage());
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object) {
        return object instanceof Entry || object instanceof StructuredSelection;
    }
}

