/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.EditorHandler;
import org.grits.toolbox.core.preference.PreferenceHandler;
import org.grits.toolbox.core.preference.PreferenceManagerLoader;
import org.grits.toolbox.core.service.IGritsUIService;

public class GritsAddon {
    private static final Logger logger = Logger.getLogger(GritsAddon.class);
    @Inject
    IEclipseContext eclipseContext;

    @PostConstruct
    public void applicationStarted(MApplication application, IGritsUIService gritsUIService, @Named(value="grits_workspace_entry") @Named(value="grits_workspace_entry") Entry workspaceEntry) {
        logger.info((Object)"Initializing GritsAddon");
        application.getContext().set(PreferenceHandler.class, (Object)((PreferenceHandler)ContextInjectionFactory.make(PreferenceHandler.class, (IEclipseContext)application.getContext())));
        PreferenceManagerLoader managerLaoder = (PreferenceManagerLoader)ContextInjectionFactory.make(PreferenceManagerLoader.class, (IEclipseContext)application.getContext());
        application.getContext().set("Grits_Preference_Manager", (Object)managerLaoder.loadPreferenceManager());
        application.getContext().set(EditorHandler.class, (Object)((EditorHandler)ContextInjectionFactory.make(EditorHandler.class, (IEclipseContext)application.getContext())));
        if (!workspaceEntry.hasChildren()) {
            try {
                gritsUIService.selectPerspective("org.grits.toolbox.core.perspective.gritsintro");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                gritsUIService.selectPerspective("org.grits.toolbox.core.perspective.projectexplorer");
            }
        }
        logger.info((Object)"GritsAddon Initialized");
    }
}

