/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.samplemanager.dialogs.NamespaceLabelComparator;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.NamespaceComboLabelProvider;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.NamespaceContentProvider;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.Namespace;

public class AddNamespaceDialog
extends Dialog {
    private List<Namespace> availableNamespaces = null;
    private Descriptor descriptor;
    private ComboViewer namespaceCombo;
    private Namespace selectedNamespace;

    public AddNamespaceDialog(Shell parent) {
        super(parent);
    }

    public void setAvailableNamespaces(List<Namespace> availableNamespaces) {
        this.availableNamespaces = availableNamespaces;
    }

    public Namespace getSelectedNamespace() {
        return this.selectedNamespace;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Namespace Selection for : " + this.descriptor.getLabel());
        Composite container = new Composite(parent, 4);
        container.setLayout((Layout)new GridLayout(2, false));
        Label namespaceLabel = new Label(container, 4);
        namespaceLabel.setText("Choose a namespace");
        namespaceLabel.setLayoutData((Object)new GridData());
        this.namespaceCombo = new ComboViewer(container, 8);
        this.namespaceCombo.setContentProvider((IContentProvider)new NamespaceContentProvider());
        this.namespaceCombo.setLabelProvider((IBaseLabelProvider)new NamespaceComboLabelProvider());
        ArrayList<String> addedURIs = new ArrayList<String>();
        for (Namespace ns : this.descriptor.getNamespaces()) {
            addedURIs.add(ns.getUri());
        }
        ArrayList<Namespace> availableNamespaces = new ArrayList<Namespace>();
        for (Namespace namespace : this.availableNamespaces) {
            if (addedURIs.contains(namespace.getUri())) continue;
            availableNamespaces.add(namespace);
        }
        Collections.sort(availableNamespaces, new NamespaceLabelComparator());
        this.namespaceCombo.setInput(availableNamespaces);
        GridData gd = new GridData();
        gd.widthHint = 350;
        this.namespaceCombo.getCombo().setLayoutData((Object)gd);
        GridData containerData = new GridData();
        containerData.heightHint = 90;
        container.setLayoutData((Object)containerData);
        return container;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected void okPressed() {
        int index = this.namespaceCombo.getCombo().getSelectionIndex();
        if (index >= 0) {
            this.selectedNamespace = (Namespace)this.namespaceCombo.getElementAt(index);
            super.okPressed();
        } else {
            MessageDialog.openWarning((Shell)this.getParentShell(), (String)"No Namespace selected", (String)"You pressed OK without selecting a namespace. Please select a namespace or else press CANCEL.");
        }
    }
}

