/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.styleprovider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IMetaData;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.styleprovider.BasePointStyleProvider;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;

public class StringStyleProvider
extends BasePointStyleProvider {
    @Override
    public Color getPointColor(ISample sample, Trace trace) {
        if (sample == null || !(sample instanceof IMetaData)) {
            return trace.getTraceColor();
        }
        Object object = ((IMetaData)((Object)sample)).getData();
        if (object == null || !(object instanceof String)) {
            return trace.getTraceColor();
        }
        String format = (String)object;
        char[] cArray = format.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case 'r': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_RED);
                }
                case 'g': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GREEN);
                }
                case 'b': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLUE);
                }
                case 'c': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_CYAN);
                }
                case 'm': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_PURPLE);
                }
                case 'y': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_YELLOW);
                }
                case 'k': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK);
                }
                case 'w': {
                    return XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
                }
            }
            ++n2;
        }
        return trace.getTraceColor();
    }

    @Override
    public Trace.PointStyle getPointStyle(ISample sample, Trace trace) {
        if (sample == null || !(sample instanceof IMetaData)) {
            return trace.getPointStyle();
        }
        Object object = ((IMetaData)((Object)sample)).getData();
        if (object == null || !(object instanceof String)) {
            return trace.getPointStyle();
        }
        String format = (String)object;
        char[] cArray = format.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case 'o': {
                    return Trace.PointStyle.CIRCLE;
                }
                case 'x': {
                    return Trace.PointStyle.XCROSS;
                }
                case '+': {
                    return Trace.PointStyle.CROSS;
                }
                case 's': {
                    return Trace.PointStyle.SQUARE;
                }
                case 'f': {
                    return Trace.PointStyle.FILLED_SQUARE;
                }
                case 'd': {
                    return Trace.PointStyle.DIAMOND;
                }
                case 'v': {
                    return Trace.PointStyle.TRIANGLE;
                }
                case 'p': {
                    return Trace.PointStyle.POINT;
                }
            }
            ++n2;
        }
        return trace.getPointStyle();
    }

    @Override
    public int getPointSize(ISample sample, Trace trace) {
        if (sample == null || !(sample instanceof IMetaData)) {
            return trace.getPointSize();
        }
        Object object = ((IMetaData)((Object)sample)).getData();
        if (object == null || !(object instanceof String)) {
            return trace.getPointSize();
        }
        String format = (String)object;
        Pattern regex = Pattern.compile("(\\d+)");
        Matcher regexMatcher = regex.matcher(format);
        if (regexMatcher.find()) {
            return Integer.parseInt(regexMatcher.group(1));
        }
        return trace.getPointSize();
    }
}

