/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.resourcesdb.MolecularEntity;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.NonBasetypeLinkingPosition;

public abstract class NonBasetypeTemplate
extends MolecularEntity {
    private int minValence;
    private int maxValence;
    private int defaultLinkingPosition1;
    private int defaultLinkingPosition2;
    private List<NonBasetypeLinkingPosition> validLinkingPositionsList;
    private String comments;
    private boolean fuzzy;

    public NonBasetypeTemplate() {
        this.init();
    }

    public void setValence(int valence) {
        this.minValence = valence;
        this.maxValence = valence;
    }

    public int getMaxValence() {
        return this.maxValence;
    }

    public void setMaxValence(int valence) {
        this.maxValence = valence;
    }

    public int getMinValence() {
        return this.minValence;
    }

    public void setMinValence(int valence) {
        this.minValence = valence;
    }

    public int getDefaultLinkingPosition1() {
        return this.defaultLinkingPosition1;
    }

    public void setDefaultLinkingPosition1(int defaultLinkingPosition1) {
        this.defaultLinkingPosition1 = defaultLinkingPosition1;
    }

    public int getDefaultLinkingPosition2() {
        return this.defaultLinkingPosition2;
    }

    public void setDefaultLinkingPosition2(int defaultLinkingPosition2) {
        this.defaultLinkingPosition2 = defaultLinkingPosition2;
    }

    public double getDefaultBondOrder1() {
        NonBasetypeLinkingPosition defaultPos1 = this.getValidLinkingPosition(this.getDefaultLinkingPosition1());
        if (defaultPos1 == null) {
            return 0.0;
        }
        return defaultPos1.getBondOrder();
    }

    public double getDefaultBondOrder2() {
        NonBasetypeLinkingPosition defaultPos2 = this.getValidLinkingPosition(this.getDefaultLinkingPosition2());
        if (defaultPos2 == null) {
            return 0.0;
        }
        return defaultPos2.getBondOrder();
    }

    public List<NonBasetypeLinkingPosition> getValidLinkingPositions() throws ResourcesDbException {
        if (this.validLinkingPositionsList == null) {
            throw new ResourcesDbException("No valid linking positions set for " + this.getName() + ".");
        }
        return this.validLinkingPositionsList;
    }

    public void setValidLinkingPositions(List<NonBasetypeLinkingPosition> validLinkingPositions) {
        this.validLinkingPositionsList = validLinkingPositions;
    }

    public void addValidLinkingPosition(int position, Atom linkAtom, Atom replacedAtom, Double bo, LinkageType defaultLinktype) {
        if (this.validLinkingPositionsList == null) {
            this.validLinkingPositionsList = new ArrayList<NonBasetypeLinkingPosition>();
        }
        this.validLinkingPositionsList.add(new NonBasetypeLinkingPosition(position, linkAtom, replacedAtom, bo, defaultLinktype));
    }

    public boolean isValidLinkingPosition(int position) throws ResourcesDbException {
        return this.getValidLinkingPosition(position) != null;
    }

    public NonBasetypeLinkingPosition getValidLinkingPosition(int position) {
        try {
            for (NonBasetypeLinkingPosition posObj : this.getValidLinkingPositions()) {
                if (posObj.getPosition() != position) continue;
                return posObj;
            }
        }
        catch (ResourcesDbException e) {
            return null;
        }
        return null;
    }

    public Atom getLinkingAtom(int position) throws ResourcesDbException {
        try {
            NonBasetypeLinkingPosition linkpos = this.getValidLinkingPosition(position);
            if (linkpos == null) {
                throw new ResourcesDbException(position + " is not a valid linking position for " + this.getName());
            }
            Atom a = linkpos.getLinkedAtom();
            return a;
        }
        catch (NullPointerException ne) {
            ResourcesDbException me = new ResourcesDbException("cannot get linking atom " + position + " for " + this.getName());
            me.initCause(ne);
            throw me;
        }
    }

    public Atom getDefaultLinkingAtom1() throws ResourcesDbException {
        return this.getLinkingAtom(this.getDefaultLinkingPosition1());
    }

    public Atom getDefaultLinkingAtom2() throws ResourcesDbException {
        return this.getLinkingAtom(this.getDefaultLinkingPosition2());
    }

    public Atom getReplacedAtom(int position) throws ResourcesDbException {
        try {
            NonBasetypeLinkingPosition linkpos = this.getValidLinkingPosition(position);
            if (linkpos == null) {
                throw new ResourcesDbException(position + " is not a valid linking position for " + this.getName());
            }
            Atom a = linkpos.getReplacedAtom();
            return a;
        }
        catch (NullPointerException ne) {
            ResourcesDbException me = new ResourcesDbException("cannot get linkage replaced atom " + position + " for " + this.getName());
            me.initCause(ne);
            throw me;
        }
    }

    public double getBondOrder(int position) throws ResourcesDbException {
        try {
            NonBasetypeLinkingPosition linkpos = this.getValidLinkingPosition(position);
            if (linkpos == null) {
                throw new ResourcesDbException(position + " is not a valid linking position for " + this.getName());
            }
            return this.getValidLinkingPosition(position).getBondOrder();
        }
        catch (NullPointerException ne) {
            throw new ResourcesDbException("cannot get bond order of linkage position " + position + " for " + this.getName());
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public void setFuzzy(boolean fuzzyflag) {
        this.fuzzy = fuzzyflag;
    }

    @Override
    public void init() {
        super.init();
        this.setDefaultLinkingPosition1(0);
        this.setDefaultLinkingPosition2(0);
        this.setValence(0);
        this.setValidLinkingPositions(new ArrayList<NonBasetypeLinkingPosition>());
        this.setComments(null);
        this.setFuzzy(false);
    }

    public String toString() {
        String outStr = "";
        outStr = outStr + "Name: " + this.getName() + "\n";
        outStr = outStr + "Valence: min " + this.getMinValence() + " max " + this.getMaxValence() + "\n";
        try {
            outStr = outStr + "Linking Atom: " + this.getDefaultLinkingAtom1() + " [bond order " + this.getDefaultBondOrder1() + ", default linkage position: " + this.getDefaultLinkingPosition1() + "]\n";
        }
        catch (ResourcesDbException me) {
            outStr = outStr + "Linking Atom: not defined";
        }
        if (this.getMaxValence() == 2) {
            try {
                outStr = outStr + "Linking Atom2: " + this.getDefaultLinkingAtom2() + " [bond order " + this.getDefaultBondOrder2() + ", default linkage position: " + this.getDefaultLinkingPosition2() + "]\n";
            }
            catch (ResourcesDbException me) {
                outStr = outStr + "Linking Atom2: not defined";
            }
        }
        return outStr;
    }
}

