/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.glycoconjugate_derived;

import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;

public enum EcdbModificationType {
    DEOXY("d", false),
    ACID("a", false),
    KETO("keto", false),
    ALDI("aldi", false),
    DOUBLEBOND("en", false),
    UNKNOWN_BOUBLEBOND("enx", false),
    SP2_HYBRID("sp2", false),
    GEMINAL("geminal", false),
    ANHYDRO("anhydro", true),
    LACTONE("lactone", true);

    private String m_strSymbol = "";
    private boolean msdbOnly = false;

    private EcdbModificationType(String symbol, boolean isMsdbOnly) {
        this.m_strSymbol = symbol;
        this.msdbOnly = isMsdbOnly;
    }

    public static EcdbModificationType forName(String a_strModi) throws GlycoconjugateException {
        for (EcdbModificationType a : EcdbModificationType.values()) {
            if (!a_strModi.equalsIgnoreCase(a.m_strSymbol)) continue;
            return a;
        }
        throw new GlycoconjugateException("Invalid value for modification");
    }

    public String getName() {
        return this.m_strSymbol;
    }

    public boolean isMsdbOnly() {
        return this.msdbOnly;
    }
}

