/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages.general;

import java.util.HashMap;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.editor.samplemanager.input.ClassesWithFeatures;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.model.Category;

public class ListLabelProvider
implements ILabelProvider,
IFontProvider {
    private Font boldFont = null;
    private HashMap<String, String> categoryURILabelMap = null;
    private Image editableIcon = ImageRegistry.getImageDescriptor((ImageRegistry.SampleImage)ImageRegistry.SampleImage.EDIT_DESCRIPTOR_ICON).createImage();

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
        if (this.editableIcon != null && !this.editableIcon.isDisposed()) {
            this.editableIcon.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        if (element instanceof ClassesWithFeatures && ((ClassesWithFeatures)element).isEditable()) {
            return this.editableIcon;
        }
        return null;
    }

    public String getText(Object element) {
        String label = null;
        if (element instanceof ClassesWithFeatures) {
            label = ((ClassesWithFeatures)element).getLabel();
        } else if (element instanceof Category && this.categoryURILabelMap != null) {
            label = this.categoryURILabelMap.get(((Category)element).getUri());
        }
        return label;
    }

    public Font getFont(Object element) {
        Font font = null;
        if (element instanceof ClassesWithFeatures && ((ClassesWithFeatures)element).isEditable()) {
            if (this.boldFont == null) {
                Font currentFont = Display.getCurrent().getSystemFont();
                FontData fontData = currentFont.getFontData()[0];
                this.boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
            }
            font = this.boldFont;
        }
        return font;
    }

    public void setCategoryHashMap(HashMap<String, String> uriLabelMap) {
        this.categoryURILabelMap = uriLabelMap;
    }
}

