/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages.rightside.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractAddAction;
import org.grits.toolbox.editor.samplemanager.dialogs.DescriptorGroupSelectionDialog;
import org.grits.toolbox.editor.samplemanager.input.DescriptorGroupWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.DescriptorGroupManagementPage;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class AddDescriptorGroupToTemplateAction
extends AbstractAddAction {
    private ArrayList<DescriptorGroup> descriptorGroups = new ArrayList();
    private HashMap<String, String> descriptorLabelToObjectMap;
    private List<DescriptorGroupWithFeatures> descriptorGroupsWithFeatures;
    private DescriptorGroupSelectionDialog descriptorGroupSelectionDialog;

    public AddDescriptorGroupToTemplateAction(AbstractManagementPage page, TableViewer tableViewer) {
        super(page, tableViewer);
        this.descriptorGroupSelectionDialog = new DescriptorGroupSelectionDialog(page.getRightSectionOfPage().getShell());
        this.descriptorGroupSelectionDialog.setInitialPattern("?");
    }

    @Override
    public void run() {
        CategoryTemplate categoryTemplate = (CategoryTemplate)this.tableViewer.getInput();
        this.descriptorGroupSelectionDialog.setTitle("Add to the Template ");
        List descriptorGroupLabels = UtilityDescriptorDescriptorGroup.getDescriptorGroupLabels((CategoryTemplate)categoryTemplate);
        this.descriptorGroupSelectionDialog.setNotAllowedLabels(descriptorGroupLabels);
        this.fillDialogChoices();
        this.descriptorGroupSelectionDialog.open();
        if (this.descriptorGroupSelectionDialog.getReturnCode() == 0) {
            String selectedDescriptorGroupLabel = (String)this.descriptorGroupSelectionDialog.getFirstResult();
            String descriptorGroupUri = this.descriptorLabelToObjectMap.get(selectedDescriptorGroupLabel);
            DescriptorGroup descriptorGroup = null;
            for (DescriptorGroupWithFeatures d : this.descriptorGroupsWithFeatures) {
                if (!d.getUri().equals(descriptorGroupUri)) continue;
                descriptorGroup = d.getDescriptorGroup();
                break;
            }
            if (this.descriptorGroupSelectionDialog.maxOccurrence != null) {
                descriptorGroup.setMaxOccurrence(this.descriptorGroupSelectionDialog.maxOccurrence);
            }
            if (this.descriptorGroupSelectionDialog.mandatory) {
                categoryTemplate.addMandatoryDescriptorGroup(descriptorGroup);
            } else {
                categoryTemplate.addOptionalDescriptorGroup(descriptorGroup);
            }
            this.addDescriptorGroupToCategoryTemplate(categoryTemplate.getTemplateURI(), categoryTemplate.getUri(), descriptorGroup.getUri(), this.descriptorGroupSelectionDialog.maxOccurrence, this.descriptorGroupSelectionDialog.mandatory);
            this.refreshModifed();
        }
    }

    private void fillDialogChoices() {
        this.descriptorLabelToObjectMap = new HashMap();
        this.descriptorGroupsWithFeatures = ((DescriptorGroupManagementPage)this.editor.findPage("1")).getAllDescriptorGroupWithFeatures();
        for (DescriptorGroupWithFeatures descriptorWithFeatures : this.descriptorGroupsWithFeatures) {
            this.descriptorGroups.add(descriptorWithFeatures.getDescriptorGroup());
            this.descriptorLabelToObjectMap.put(descriptorWithFeatures.getLabel(), descriptorWithFeatures.getDescriptorGroup().getUri());
        }
        this.descriptorGroupSelectionDialog.setAllDescriptorGroups(this.descriptorGroups);
    }

    private void addDescriptorGroupToCategoryTemplate(String templateURI, String categoryURI, String descriptorURI, Integer maxOcurrence, boolean mandatory) {
        this.ontologyManagerApi.addDescriptorOrGroupToCategoryTemplate(templateURI, categoryURI, descriptorURI, maxOcurrence, mandatory);
    }
}

