/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.EntryEditorPart;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.DelayedResizeListener;
import org.grits.toolbox.display.control.table.tablecore.GRITSTable;
import org.grits.toolbox.entry.ms.annotation.command.ViewRowChooserInTabCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.IMSAnnotationPeaksViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationResultsComposite;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSelectionView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationTableBase;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.ms.om.data.Feature;

public class MSAnnotationPeaksView
extends MassSpecPeaksView
implements IMSAnnotationPeaksViewer {
    private static final Logger logger = Logger.getLogger(MSAnnotationPeaksView.class);
    public static final String VIEW_ID = "plugin.ms.annotation.views.MSAnnotationPeaks";
    public static final String EVENT_TOPIC_PEAKVIEW_MODIFIED = "peaksView_modified_in_a_tab";
    protected Composite compositeTop = null;
    protected Composite compositeBottom = null;
    protected Integer iRowNum = null;
    protected SashForm sashForm = null;
    @Inject
    IEventBroker eventBroker;
    protected MSAnnotationSelectionView selectionView = null;

    @Inject
    public MSAnnotationPeaksView(@Optional Entry entry, @Optional Property msEntityProperty, @Named(value="MinMSLevelContext") @Named(value="MinMSLevelContext") int iMinMSLevel) {
        super(entry, msEntityProperty, iMinMSLevel);
    }

    @Inject
    public MSAnnotationPeaksView(@Optional Entry entry, @Optional Property msEntityProperty, @Named(value="Row Number Context") @Named(value="Row Number Context") int iRowNum, @Named(value="MinMSLevelContext") @Named(value="MinMSLevelContext") int iMinMSLevel) {
        super(entry, msEntityProperty, iMinMSLevel);
        this.iRowNum = iRowNum;
    }

    public String toString() {
        return "MSAnnotationPeaksView (" + this.entry + ")";
    }

    public int getRowNum() {
        return this.iRowNum;
    }

    protected void initResultsView(Composite parent) throws Exception {
        this.parent = parent.getParent().getParent();
        this.compositeTop = new Composite(parent, 2048);
        this.compositeTop.setLayout((Layout)new GridLayout(1, false));
        try {
            this.resultsComposite = this.getNewResultsComposite(this.compositeTop, 0);
            ((MSAnnotationResultsComposite)this.resultsComposite).createPartControl(this.compositeTop, (EntryEditorPart)this, this.entityProperty, this.dataProcessor, FillTypes.PeaksWithFeatures);
            this.resultsComposite.setLayout((Layout)new FillLayout());
            this.viewBase = (MSAnnotationTableBase)this.resultsComposite.getBaseView();
        }
        catch (Exception e) {
            this.viewBase = null;
            this.resultsComposite = null;
            logger.error((Object)"Error in MSAnnotationPeaksView: initResultsView");
            throw new Exception(e.getMessage());
        }
    }

    protected void addListeners(Composite container) {
        DelayedResizeListener l = new DelayedResizeListener();
        if (this.resultsComposite != null) {
            l.addTable((GRITSTable)this.resultsComposite.getBaseView().getNatTable());
        }
        if (this.selectionView != null) {
            l.addTable((GRITSTable)this.selectionView.getSubTable());
        }
        container.addControlListener((ControlListener)l);
    }

    public void reInitializeView() throws Exception {
        try {
            this.sashForm.setVisible(false);
            this.compositeBottom.setVisible(false);
            this.createPeaksView(this.getParent());
            this.getParent().layout(true);
            this.sashForm.layout(true);
        }
        catch (Exception e) {
            this.viewBase = null;
            this.resultsComposite = null;
            logger.error((Object)"Error in MSAnnotationPeaksView: reInitializeView");
            throw new Exception(e.getMessage());
        }
    }

    protected void createPeaksView(Composite container) throws Exception {
        try {
            this.sashForm = new SashForm(container, 512);
            this.initResultsView((Composite)this.sashForm);
            this.compositeBottom = new Composite((Composite)this.sashForm, 2048);
            this.compositeBottom.setLayout((Layout)new GridLayout(1, false));
            this.sashForm.setWeights(new int[]{10, 5});
        }
        catch (Exception e) {
            this.viewBase = null;
            this.resultsComposite = null;
            logger.error((Object)"Error in MSAnnotationPeaksView: createPeaksView");
            throw new Exception(e.getMessage());
        }
    }

    public void createPartControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            this.entry = this.getEntry();
            this.createPeaksView(container);
            this.addListeners(container);
        }
        catch (Exception exception) {
            this.viewBase = null;
            this.resultsComposite = null;
        }
    }

    protected MSAnnotationResultsComposite getNewResultsComposite(Composite composite, int style) {
        return new MSAnnotationResultsComposite(composite, style);
    }

    public Composite getBottomPane() {
        return this.compositeBottom;
    }

    public Composite getTopPane() {
        return this.compositeTop;
    }

    public MSAnnotationSelectionView getSelectionView() {
        return this.selectionView;
    }

    public void setSelectionView(MSAnnotationSelectionView _viewer) {
        this.selectionView = _viewer;
    }

    @Override
    public Composite getSelectionArea() {
        return this.getBottomPane();
    }

    @Override
    public MSAnnotationSelectionView getCurrentSelectionView() {
        return this.getSelectionView();
    }

    @Override
    public void initNewSelectionView() {
        this.setSelectionView(new MSAnnotationSelectionView(this.getBottomPane()));
    }

    public static void showRowSelection(IEclipseContext context, Entry entry, MSAnnotationTable parentTable, int iRowIndex, int iParentScanNum, String sParentRowId) {
        MSAnnotationMultiPageViewer parent = MSAnnotationMultiPageViewer.getActiveViewerForEntry(context, entry);
        if (parent != null) {
            MSAnnotationPeaksView me = (MSAnnotationPeaksView)((Object)parent.getPeaksView());
            ViewRowChooserInTabCommandExecutor.showRowChooser(me, parentTable, iRowIndex, iParentScanNum, sParentRowId);
        }
    }

    protected TableDataProcessor getNewTableDataProcessor(Entry entry, Property entityProperty) {
        MSAnnotationTableDataProcessor proc = new MSAnnotationTableDataProcessor(entry, entityProperty, FillTypes.PeaksWithFeatures, this.getMinMSLevel());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    protected TableDataProcessor getNewTableDataProcessor(Property entityProperty) {
        MSAnnotationMultiPageViewer parentViewer = MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.context, this.getEntry().getParent());
        if (parentViewer == null || parentViewer.getPeaksView() == null) {
            return null;
        }
        MSAnnotationTableDataProcessor parentProc = (MSAnnotationTableDataProcessor)parentViewer.getScansView().getTableDataProcessor();
        if (parentProc.getGRITSdata().getAnnotation() == null || parentProc.getGRITSdata().getAnnotation().isEmpty()) {
            return null;
        }
        MSAnnotationTableDataProcessor proc = new MSAnnotationTableDataProcessor((TableDataProcessor)parentProc, entityProperty, FillTypes.PeaksWithFeatures, this.getMinMSLevel());
        proc.setEntry(this.getEntry());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    public MSAnnotationTableBase getViewBase() {
        return (MSAnnotationTableBase)super.getViewBase();
    }

    protected void updateProjectProperty() {
    }

    protected void savePreference() {
    }

    public void setFocus() {
    }

    public void setDirty(boolean d) {
        super.setDirty(d);
        this.eventBroker.send(EVENT_TOPIC_PEAKVIEW_MODIFIED, (Object)this);
    }

    @Persist
    public void doSave(IProgressMonitor monitor) {
        this.viewBase.doSave(monitor);
        this.setDirty(false);
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public Integer getiRowNum() {
        return this.iRowNum;
    }

    public void setiRowNum(Integer iRowNum) {
        this.iRowNum = iRowNum;
    }

    @Override
    public Feature getFeature(int iRowNum) {
        return null;
    }
}

