/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.handler;

import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationFilterWindow;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class ShowMSAnnotationFilterDialog {
    private static final Logger logger = Logger.getLogger(ShowMSAnnotationFilterDialog.class);

    @Execute
    public void execute(@Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part, @Named(value="activeShell") @Named(value="activeShell") Shell shell, EPartService partService) {
        MassSpecMultiPageViewer curView = null;
        if (part != null && part.getObject() instanceof MassSpecMultiPageViewer) {
            curView = (MassSpecMultiPageViewer)part.getObject();
        } else {
            for (MPart mPart : partService.getParts()) {
                if (mPart.getObject() instanceof MassSpecMultiPageViewer && mPart.equals(mPart.getParent().getSelectedElement()) && (curView = (MassSpecMultiPageViewer)mPart.getObject()).getEntry().getProperty() instanceof MSAnnotationEntityProperty) break;
            }
        }
        if (curView == null || !(curView.getEntry().getProperty() instanceof MSAnnotationEntityProperty)) {
            logger.warn((Object)"No MS Annotation Results are open.\nPlease open the view and then apply the filter.");
            ErrorUtils.createWarningMessageBox((Shell)shell, (String)"Unable to Perform Filter", (String)"No MS Annotation Results are open.\nPlease open the view and then apply the filter.");
            return;
        }
        MSAnnotationFilterWindow win = new MSAnnotationFilterWindow(shell, curView.getEntry(), part);
        win.open();
    }
}

