/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.dialog;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.dialog.MassSpecExternalQuantDialog;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MSAnnotationExternalQuantDialog
extends MassSpecExternalQuantDialog {
    private static final Logger logger = Logger.getLogger(MSAnnotationExternalQuantDialog.class);

    public MSAnnotationExternalQuantDialog(Shell parentShell, MassSpecMultiPageViewer curView) {
        super(parentShell, curView);
        this.setShellStyle(67696);
    }

    public Property getMSEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)entry.getProperty();
            MassSpecProperty msp = msep.getMassSpecParentProperty();
            return msp;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public Property getEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)entry.getProperty();
            MSAnnotationProperty msap = msep.getMSAnnotationParentProperty();
            return msap;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            EPartService partService = this.getContextViewer().getPartService();
            for (MPart mPart : partService.getParts()) {
                MSAnnotationMultiPageViewer viewer;
                if (!(mPart.getObject() instanceof MSAnnotationMultiPageViewer) || !mPart.equals(mPart.getParent().getSelectedElement()) || (viewer = (MSAnnotationMultiPageViewer)((Object)mPart.getObject())) == null || viewer.getEntry().getProperty() == null || !(viewer.getEntry().getProperty() instanceof MSAnnotationEntityProperty)) continue;
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected MassSpecUISettings getEntrySettings() {
        MSAnnotationProperty msp = (MSAnnotationProperty)this.getEntryParentProperty();
        MSAnnotationMetaData entrySettings = msp.getMSAnnotationMetaData();
        return entrySettings;
    }

    protected List<MSPropertyDataFile> getQuantificationFiles() {
        MassSpecProperty msp = (MassSpecProperty)this.getMSEntryParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings.getQuantificationFiles();
    }

    protected void updateViewer() {
        try {
            MSAnnotationMultiPageViewer viewer = (MSAnnotationMultiPageViewer)this.getCurrentViewer();
            List sKeyVals = this.getColumnKeyLabels();
            viewer.reLoadStructureAnnotationTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void updateSettings() {
        MSAnnotationProperty property = (MSAnnotationProperty)this.getEntryParentProperty();
        try {
            Entry projectEntry = this.getEntryForCurrentViewer();
            String sFileName = property.getFullyQualifiedMetaDataFileName(projectEntry);
            MSAnnotationMetaData msSettings = property.getMSAnnotationMetaData();
            MSAnnotationProperty.marshallSettingsFile(sFileName, msSettings);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

