/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.utils.io;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.ss.examples.AddDimensionedImage;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;
import org.grits.toolbox.utils.image.SimianImageConverter;

public class ExcelWriterHelper
extends AddDimensionedImage {
    private static BuilderWorkspaceSWT bws = new BuilderWorkspaceSWT((Device)Display.getDefault());

    static {
        bws.setNotation("snfg");
    }

    public BufferedImage createGlycanImage(String a_sequence, String a_displayStyle, boolean a_showMasses, boolean a_showRedEnd, Double a_imageScalingFactor) throws Exception {
        ArrayList<String> lSequences = new ArrayList<String>();
        lSequences.add(a_sequence);
        return this.createGlycanImage(lSequences, a_displayStyle, a_showMasses, a_showRedEnd, a_imageScalingFactor);
    }

    public BufferedImage createGlycanImage(List<String> a_sequences, String a_displayStyle, boolean a_showMasses, boolean a_showRedEnd, Double a_imageScalingFactor) throws Exception {
        if (a_displayStyle != null) {
            bws.setDisplay(a_displayStyle);
        }
        double dScaleTo = a_imageScalingFactor < 1.0 ? 2.0 : a_imageScalingFactor;
        double dScaleFrom = a_imageScalingFactor < 1.0 ? a_imageScalingFactor / 2.0 : a_imageScalingFactor;
        ArrayList<Glycan> lGlycans = new ArrayList<Glycan>();
        for (String sequence : a_sequences) {
            if (sequence == null) continue;
            lGlycans.add(Glycan.fromString((String)sequence));
        }
        BufferedImage img = bws.getGlycanRendererAWT().getImage(lGlycans, true, a_showMasses, a_showRedEnd, dScaleTo);
        if (a_imageScalingFactor < 1.0) {
            int width = (int)((double)img.getWidth() * dScaleFrom);
            int height = (int)((double)img.getHeight() * dScaleFrom);
            Image newImage = img.getScaledInstance(width, height, 16);
            BufferedImage newBufferedImage = SimianImageConverter.convert(newImage);
            newImage.flush();
            return newBufferedImage;
        }
        return img;
    }

    public void writeCellImage(Workbook a_workbook, Sheet a_sheet, int a_iRowNum, int a_iColNum, BufferedImage a_img, List<Picture> a_imgs) throws Exception {
        if (a_iColNum < 0 || a_img == null) {
            return;
        }
        Drawing drawing = a_sheet.createDrawingPatriarch();
        double imageWidthMM = AddDimensionedImage.ConvertImageUnits.widthUnits2Millimetres(AddDimensionedImage.ConvertImageUnits.pixel2WidthUnits(a_img.getWidth()));
        double imageHeightMM = AddDimensionedImage.ConvertImageUnits.widthUnits2Millimetres(AddDimensionedImage.ConvertImageUnits.pixel2WidthUnits(a_img.getHeight()));
        AddDimensionedImage.ClientAnchorDetail colClientAnchorDetail = this.fitImageToColumns(a_sheet, a_iColNum, imageWidthMM + 3.0, 3);
        AddDimensionedImage.ClientAnchorDetail rowClientAnchorDetail = this.fitImageToRows(a_sheet, a_iRowNum, imageHeightMM + 3.0, 3);
        ClientAnchor anchor = a_workbook.getCreationHelper().createClientAnchor();
        anchor.setDx1(10);
        anchor.setDy1(10);
        anchor.setDx2(colClientAnchorDetail.getInset());
        anchor.setDy2(rowClientAnchorDetail.getInset());
        anchor.setCol1(colClientAnchorDetail.getFromIndex());
        anchor.setRow1(rowClientAnchorDetail.getFromIndex());
        anchor.setCol2(colClientAnchorDetail.getToIndex());
        anchor.setRow2(rowClientAnchorDetail.getToIndex());
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)a_img, "png", bos);
        int index = a_sheet.getWorkbook().addPicture(bos.toByteArray(), 6);
        a_imgs.add(drawing.createPicture(anchor, index));
    }
}

