/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationSettingsPreference;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class PreferenceUtils {
    private static final Logger logger = Logger.getLogger(PreferenceUtils.class);

    public static MSGlycanAnnotationSettingsPreference getMSGlycanAnnotationSettingsPreferences(PreferenceEntity preferenceEntity, Class<? extends MSGlycanAnnotationSettingsPreference> thisClass) throws UnsupportedVersionException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        MSGlycanAnnotationSettingsPreference preferenceSettings = null;
        if (preferenceEntity != null) {
            preferenceSettings = PreferenceUtils.getMSGlycanAnnotationSettingsPreferencesFromXML(preferenceEntity.getValue(), thisClass);
            if (preferenceSettings == null) {
                preferenceSettings = thisClass.newInstance();
                preferenceSettings.loadDefaults();
            }
        } else {
            preferenceSettings = thisClass.newInstance();
            preferenceSettings.loadDefaults();
        }
        return preferenceSettings;
    }

    private static MSGlycanAnnotationSettingsPreference getMSGlycanAnnotationSettingsPreferencesFromXML(String xmlString, Class<? extends MSGlycanAnnotationSettingsPreference> thisClass) {
        MSGlycanAnnotationSettingsPreference msPreference = null;
        try {
            msPreference = (MSGlycanAnnotationSettingsPreference)PreferenceUtils.unmarshallFromXML(xmlString, thisClass);
        }
        catch (JAXBException e) {
            logger.error((Object)("The object could not be read from xml." + e.getMessage()), (Throwable)e);
        }
        return msPreference;
    }

    public static Object unmarshallFromXML(String xmlString, Class<?> destClass) throws JAXBException {
        Object obj = null;
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(destClass);
        JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (xmlString != null && !xmlString.isEmpty()) {
            obj = unmarshaller.unmarshal((Reader)new StringReader(xmlString));
        }
        return obj;
    }

    public static String marshalXML(Object object) throws JAXBException {
        String xmlString = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(AnnotationReader.filterClassContext));
        contextList.addAll(Arrays.asList(FilterUtils.filterClassContext));
        contextList.add(object.getClass());
        contextList.add(Method.class);
        JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal(object, (OutputStream)os);
        xmlString = os.toString();
        return xmlString;
    }
}

