/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.handler;

import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationFilterWindow;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;

public class ShowMSGlycanAnnotationFilterDialog {
    private static final Logger logger = Logger.getLogger(ShowMSGlycanAnnotationFilterDialog.class);

    @Execute
    public void execute(@Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part, @Named(value="activeShell") @Named(value="activeShell") Shell shell, EPartService partService) {
        MSAnnotationEntityProperty msAnnotEntityProp;
        MSGlycanAnnotationMultiPageViewer curView = null;
        if (part != null && part.getObject() instanceof MSGlycanAnnotationMultiPageViewer) {
            curView = (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
        } else {
            for (MPart mPart : partService.getParts()) {
                if (mPart.getObject() instanceof MSGlycanAnnotationMultiPageViewer && mPart.equals(mPart.getParent().getSelectedElement()) && (curView = (MSGlycanAnnotationMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() instanceof MSAnnotationEntityProperty && (msAnnotEntityProp = (MSAnnotationEntityProperty)curView.getEntry().getProperty()).getMsLevel() == 2) break;
            }
        }
        if (curView == null) {
            logger.warn((Object)"An MS Glycan table must be open and active in order to use the Filter option");
            ErrorUtils.createWarningMessageBox((Shell)shell, (String)"No open annotation table", (String)"An annotation table must be open and active in order to use the Filter option");
            return;
        }
        Entry msEntry = curView.getEntry();
        Property msProp = msEntry.getProperty();
        if (msProp instanceof MSAnnotationEntityProperty && (msAnnotEntityProp = (MSAnnotationEntityProperty)msProp).getMsLevel() == 2) {
            MSGlycanAnnotationFilterWindow win = new MSGlycanAnnotationFilterWindow(shell, msEntry, part);
            win.open();
            return;
        }
        logger.warn((Object)"An MS Glycan master table must be open and active in order to use the Filter option");
        ErrorUtils.createWarningMessageBox((Shell)shell, (String)"No open Annotation table", (String)"You cannot apply filters for this level");
    }

    @CanExecute
    public boolean isEnabled(@Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart part, EPartService partService) {
        MSAnnotationEntityProperty msAnnotEntityProp;
        MSGlycanAnnotationMultiPageViewer curView = null;
        if (part != null && part.getObject() instanceof MSGlycanAnnotationMultiPageViewer) {
            curView = (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
        } else {
            for (MPart mPart : partService.getParts()) {
                if (mPart.getObject() instanceof MSGlycanAnnotationMultiPageViewer && mPart.equals(mPart.getParent().getSelectedElement()) && (curView = (MSGlycanAnnotationMultiPageViewer)((Object)mPart.getObject())).getEntry().getProperty() instanceof MSAnnotationEntityProperty && (msAnnotEntityProp = (MSAnnotationEntityProperty)curView.getEntry().getProperty()).getMsLevel() == 2) break;
            }
        }
        if (curView == null) {
            return false;
        }
        Entry msEntry = curView.getEntry();
        Property msProp = msEntry.getProperty();
        return msProp instanceof MSAnnotationEntityProperty && (msAnnotEntityProp = (MSAnnotationEntityProperty)msProp).getMsLevel() == 2;
    }
}

