/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.dialog;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolCategory;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;

public class SaveAsDialog
extends FormDialog {
    public static int PROTOCOL_VARIANT = 0;
    public static int EXPERIMENT_TEMPLATE = 1;
    public static int PROTOCOL_TEMPLATE = 2;
    private static final Logger logger = Logger.getLogger(SaveAsDialog.class);
    int mode;
    Label errorLabel;
    Combo categoryCombo;
    Text nameText;
    Text descriptionText;
    Text uriText;
    String[] categoryNames = null;
    List<ProtocolCategory> protocolCategories;
    ControlDecoration dec;
    String name;
    String description;
    ProtocolCategory category;
    String creator;
    String protocolUri;
    private Combo paletteCategoryCombo;
    List<ProtocolCategory> topLevelCategories;
    private String[] topLevelCategoryNames;
    private ProtocolCategory paletteCategory;
    ExperimentDesignOntologyAPI api = null;

    public SaveAsDialog(Shell parentShell, int mode) {
        super(parentShell);
        this.mode = mode;
        if (mode == PROTOCOL_TEMPLATE) {
            try {
                this.api = new ExperimentDesignOntologyAPI();
                this.topLevelCategories = this.api.getTopLevelCategories();
                this.topLevelCategoryNames = new String[this.topLevelCategories.size()];
                int i = 0;
                for (ProtocolCategory protocolCategory : this.topLevelCategories) {
                    this.topLevelCategoryNames[i++] = protocolCategory.getName();
                }
                this.protocolCategories = this.api.getProtocolCategories();
                this.categoryNames = new String[this.protocolCategories.size()];
                i = 0;
                for (ProtocolCategory protocolCategory : this.protocolCategories) {
                    this.categoryNames[i++] = protocolCategory.getName();
                }
            }
            catch (Exception e1) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error getting protocols from the ontology. ", (Throwable)e1);
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error getting protocols from the ontology. Cannot continue");
                this.cancelPressed();
            }
        }
    }

    public SaveAsDialog(Shell parentShell, int mode, String protocolUri) {
        this(parentShell, mode);
        this.protocolUri = protocolUri;
    }

    public SaveAsDialog(Shell shell, int mode, ProtocolCategory category) {
        this(shell, mode);
        this.category = category;
    }

    public SaveAsDialog(Shell shell, int mode, ProtocolCategory category, ProtocolCategory topLevelCategory) {
        this(shell, mode);
        this.category = category;
        this.paletteCategory = topLevelCategory;
        if (this.paletteCategory != null) {
            this.protocolCategories = this.api.getProtocolCategoriesByTopLevelCategory(this.paletteCategory);
            this.categoryNames = new String[this.protocolCategories.size()];
            int i = 0;
            for (ProtocolCategory protocolCategory : this.protocolCategories) {
                this.categoryNames[i++] = protocolCategory.getName();
            }
        }
    }

    protected void createFormContent(IManagedForm mform) {
        if (this.mode == PROTOCOL_VARIANT) {
            mform.getForm().setText("Please provide protocol name");
        } else if (this.mode == PROTOCOL_TEMPLATE) {
            mform.getForm().setText("Please provide a protocol name, select a category and a top level category");
        } else {
            mform.getForm().setText("Please provide template details");
        }
        ScrolledForm scrolledForm = mform.getForm();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        FormToolkit toolkit = mform.getToolkit();
        Label nameLabel = toolkit.createLabel(scrolledForm.getBody(), "Name *", 0);
        TableWrapData twd_nameLabel = new TableWrapData(8, 16, 1, 1);
        twd_nameLabel.align = 2;
        nameLabel.setLayoutData((Object)twd_nameLabel);
        this.nameText = toolkit.createText(scrolledForm.getBody(), "", 0);
        this.nameText.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        if (this.name != null) {
            this.nameText.setText(this.name);
        }
        this.dec = new ControlDecoration((Control)this.nameText, 16512);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        this.dec.setImage(image);
        this.dec.setDescriptionText("Name cannot be left empty");
        this.dec.hide();
        if (this.mode == PROTOCOL_VARIANT) {
            Label uriLabel = toolkit.createLabel(scrolledForm.getBody(), "Protocol URI *", 0);
            TableWrapData twd_uriLabel = new TableWrapData(8, 16, 1, 1);
            twd_uriLabel.align = 2;
            uriLabel.setLayoutData((Object)twd_uriLabel);
            this.uriText = toolkit.createText(scrolledForm.getBody(), this.protocolUri, 8);
            this.uriText.setBackground(ColorConstants.button);
            this.uriText.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        }
        if (this.mode == PROTOCOL_TEMPLATE) {
            Label topLevelCategoryLabel = toolkit.createLabel(scrolledForm.getBody(), "Palette Category *", 0);
            TableWrapData twd_categoryLabel1 = new TableWrapData(8, 16, 1, 1);
            twd_categoryLabel1.align = 2;
            topLevelCategoryLabel.setLayoutData((Object)twd_categoryLabel1);
            this.paletteCategoryCombo = new Combo(scrolledForm.getBody(), 8);
            this.paletteCategoryCombo.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
            this.paletteCategoryCombo.setItems(this.topLevelCategoryNames);
            if (this.paletteCategory != null) {
                this.paletteCategoryCombo.setText(this.paletteCategory.getName());
            } else {
                this.paletteCategoryCombo.setText(this.topLevelCategoryNames[0]);
            }
            this.paletteCategoryCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int selected = SaveAsDialog.this.paletteCategoryCombo.getSelectionIndex();
                    if (selected != -1) {
                        ProtocolCategory topLevel = SaveAsDialog.this.topLevelCategories.get(selected);
                        SaveAsDialog.this.protocolCategories = SaveAsDialog.this.api.getProtocolCategoriesByTopLevelCategory(topLevel);
                        SaveAsDialog.this.categoryNames = new String[SaveAsDialog.this.protocolCategories.size()];
                        int i = 0;
                        for (ProtocolCategory protocolCategory : SaveAsDialog.this.protocolCategories) {
                            SaveAsDialog.this.categoryNames[i++] = protocolCategory.getName();
                        }
                        SaveAsDialog.this.categoryCombo.setItems(SaveAsDialog.this.categoryNames);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Label categoryLabel = toolkit.createLabel(scrolledForm.getBody(), "Category *", 0);
            TableWrapData twd_categoryLabel = new TableWrapData(8, 16, 1, 1);
            twd_categoryLabel.align = 2;
            categoryLabel.setLayoutData((Object)twd_categoryLabel);
            this.categoryCombo = new Combo(scrolledForm.getBody(), 8);
            this.categoryCombo.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
            this.categoryCombo.setItems(this.categoryNames);
            if (this.category != null) {
                this.categoryCombo.setText(this.category.getName());
            } else {
                this.categoryCombo.setText(this.categoryNames[0]);
            }
        }
        if (this.mode == PROTOCOL_TEMPLATE || this.mode == EXPERIMENT_TEMPLATE) {
            Label lblDescription = toolkit.createLabel(scrolledForm.getBody(), "Description", 0);
            lblDescription.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
            this.descriptionText = toolkit.createText(scrolledForm.getBody(), "", 578);
            this.descriptionText.setTextLimit(10000);
            TableWrapData twd_description = new TableWrapData(256, 16, 1, 1);
            twd_description.heightHint = 60;
            this.descriptionText.setLayoutData((Object)twd_description);
            if (this.description != null) {
                this.descriptionText.setText(this.description);
            }
            this.descriptionText.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.stateMask == 262144 && e.keyCode == 97) {
                        ((Text)e.widget).selectAll();
                    }
                }
            });
        }
        this.errorLabel = toolkit.createLabel(scrolledForm.getBody(), "", 0);
        this.errorLabel.setLayoutData((Object)new TableWrapData(256, 64, 3, 2));
        toolkit.paintBordersFor(scrolledForm.getBody());
    }

    protected void okPressed() {
        block16: {
            DataBindingContext dataBindingContext;
            Binding binding;
            this.name = this.nameText.getText();
            if (this.mode != PROTOCOL_VARIANT) {
                this.description = this.descriptionText.getText();
            }
            if (((Status)(binding = (dataBindingContext = new DataBindingContext()).bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameText), PojoProperties.value(SaveAsDialog.class, (String)"name").observe((Object)this), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new StringRequiredValidator("Name cannot be left empty", this.dec)), null)).getValidationStatus().getValue()).isOK()) {
                if (this.mode == PROTOCOL_TEMPLATE) {
                    int selected = this.paletteCategoryCombo.getSelectionIndex();
                    if (selected != -1) {
                        if (this.topLevelCategories != null) {
                            this.paletteCategory = this.topLevelCategories.get(selected);
                        }
                        if ((selected = this.categoryCombo.getSelectionIndex()) != -1) {
                            if (this.protocolCategories != null) {
                                this.category = this.protocolCategories.get(selected);
                                super.okPressed();
                            }
                        } else {
                            this.errorLabel.setForeground(ColorConstants.red);
                            this.errorLabel.setText("Please select a category");
                        }
                    } else {
                        this.errorLabel.setForeground(ColorConstants.red);
                        this.errorLabel.setText("Please select a palette category");
                    }
                } else if (this.mode == PROTOCOL_VARIANT) {
                    try {
                        List<ProtocolNode> existingTemplates = new ExperimentDesignOntologyAPI().getProtocolsByLabel(this.name);
                        if (existingTemplates != null && existingTemplates.size() > 0) {
                            this.errorLabel.setForeground(ColorConstants.red);
                            this.errorLabel.setText("Please select a unique name, a protocol template with this name exists in the system");
                            break block16;
                        }
                        super.okPressed();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not check for existing protocol templates", (Throwable)e);
                    }
                } else {
                    super.okPressed();
                }
            } else {
                this.errorLabel.setForeground(ColorConstants.red);
                this.errorLabel.setText("Please provide a name");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProtocolCategory getCategory() {
        return this.category;
    }

    public void setCategory(ProtocolCategory category) {
        this.category = category;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setProtocolUri(String protocolUri) {
        this.protocolUri = protocolUri;
    }

    public ProtocolCategory getPaletteCategory() {
        return this.paletteCategory;
    }

    public void setPaletteCategory(ProtocolCategory paletteCategory) {
        this.paletteCategory = paletteCategory;
    }

    class StringRequiredValidator
    implements IValidator {
        private final String errorText;
        private final ControlDecoration controlDecoration;

        public StringRequiredValidator(String errorText, ControlDecoration controlDecoration) {
            this.errorText = errorText;
            this.controlDecoration = controlDecoration;
        }

        public IStatus validate(Object value) {
            String text;
            if (value instanceof String && (text = (String)value).trim().length() == 0) {
                this.controlDecoration.show();
                return ValidationStatus.error((String)this.errorText);
            }
            this.controlDecoration.hide();
            SaveAsDialog.this.errorLabel.setText("");
            return Status.OK_STATUS;
        }
    }
}

