/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.EntityWithPosition;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.views.ParameterView;

public class DeleteParameterAction {
    private static Logger logger = Logger.getLogger(DeleteParameterAction.class);
    boolean onlyOne;
    @Inject
    IEventBroker eventBroker;
    GraphEditor editor;

    @Execute
    public void run(@Named(value="activeShell") @Named(value="activeShell") Shell shell, MApplication application, MPart protocolPart, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Parameter toBeDeleted, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") ParameterGroup groupToBeDeleted) {
        if (protocolPart != null && protocolPart.getObject() != null) {
            ProtocolNode protocol = ((ParameterView)protocolPart.getObject()).getProtocol();
            if (protocol == null) {
                return;
            }
            this.editor = (GraphEditor)((Object)application.getContext().get(GraphEditor.class));
            if (this.editor == null) {
                logger.error((Object)"Cannot get the reference to Graph Editor");
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
                return;
            }
            TreeViewer viewer = ((ParameterView)protocolPart.getObject()).getTreeViewer();
            try {
                ProtocolNode protocolTemplate;
                if (protocol.getTemplateUri() != null && (protocolTemplate = new ExperimentDesignOntologyAPI().getProtocolByUri(protocol.getTemplateUri())) != null) {
                    if (toBeDeleted != null) {
                        List<Parameter> parameters = protocolTemplate.getParameters();
                        if (parameters.contains(toBeDeleted)) {
                            boolean confirm = MessageDialog.openConfirm((Shell)shell, (String)"Information", (String)"This parameter belongs to the original template.");
                            if (confirm) {
                                protocol.setTemplate(null);
                                protocol.setTemplateUri(null);
                                protocol.setTemplateChanged(true);
                                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)"");
                                this.editor.refreshProtocolNode(protocol);
                            } else {
                                toBeDeleted = null;
                            }
                        }
                    } else if (groupToBeDeleted != null) {
                        List<ParameterGroup> groups = protocol.getParameterGroups();
                        this.onlyOne = true;
                        int count = 0;
                        for (ParameterGroup parameterGroup : groups) {
                            if (!parameterGroup.getLabel().equals(groupToBeDeleted.getLabel()) || ++count <= 1) continue;
                            this.onlyOne = false;
                            break;
                        }
                        if (this.onlyOne) {
                            List<ParameterGroup> templateGroups = protocolTemplate.getParameterGroups();
                            if (templateGroups.contains(groupToBeDeleted)) {
                                boolean confirm = MessageDialog.openConfirm((Shell)shell, (String)"Information", (String)"This parameter group belongs to the original template.");
                                if (confirm) {
                                    protocol.setTemplate(null);
                                    protocol.setTemplateUri(null);
                                    protocol.setTemplateChanged(true);
                                    this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                                    this.eventBroker.post("EventTopic_EventPart_Modified", (Object)"");
                                    this.editor.refreshProtocolNode(protocol);
                                } else {
                                    groupToBeDeleted = null;
                                }
                            }
                        } else if (groupToBeDeleted.getRequired().booleanValue()) {
                            boolean confirm = MessageDialog.openConfirm((Shell)shell, (String)"Information", (String)"This parameter group is required in the original template.");
                            if (confirm) {
                                protocol.setTemplate(null);
                                protocol.setTemplateUri(null);
                                protocol.setTemplateChanged(true);
                                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                                this.eventBroker.post("EventTopic_EventPart_Modified", (Object)"");
                                this.editor.refreshProtocolNode(protocol);
                            } else {
                                groupToBeDeleted = null;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error getting the template information from the ontology: ", (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)"Cannot retrieve template", (String)("Error getting the template information from the ontology: " + e.getMessage()));
                return;
            }
            try {
                if (toBeDeleted != null) {
                    boolean deleted = protocol.getParameters().remove(toBeDeleted);
                    if (deleted) {
                        ArrayList<EntityWithPosition> paramsAndParamGroups = new ArrayList<EntityWithPosition>();
                        paramsAndParamGroups.addAll(protocol.getParameters());
                        if (protocol.getParameterGroups() != null) {
                            paramsAndParamGroups.addAll(protocol.getParameterGroups());
                        }
                        viewer.setInput(paramsAndParamGroups);
                        viewer.refresh();
                        viewer.expandAll();
                        this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                        this.editor.refreshProtocolNode(protocol);
                        toBeDeleted = null;
                    }
                } else if (groupToBeDeleted != null) {
                    boolean deleted;
                    List<ParameterGroup> parameterGroups = protocol.getParameterGroups();
                    if (!this.onlyOne) {
                        for (ParameterGroup group : parameterGroups) {
                            if (group == groupToBeDeleted || !group.getLabel().equals(groupToBeDeleted.getLabel()) || group.getId() <= 1) continue;
                            group.setId(group.getId() - 1);
                            List<Parameter> params = group.getParameters();
                            for (Parameter parameter : params) {
                                parameter.setGroupId(group.getId());
                            }
                        }
                    }
                    if (deleted = parameterGroups.remove(groupToBeDeleted)) {
                        ArrayList<EntityWithPosition> paramsAndParamGroups = new ArrayList<EntityWithPosition>();
                        if (protocol.getParameters() != null) {
                            paramsAndParamGroups.addAll(protocol.getParameters());
                        }
                        paramsAndParamGroups.addAll(protocol.getParameterGroups());
                        viewer.setInput(paramsAndParamGroups);
                        viewer.refresh();
                        viewer.expandAll();
                        this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                        this.editor.refreshProtocolNode(protocol);
                        groupToBeDeleted = null;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error deleting the parameter ", (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Error deleting the parameter " + e.getMessage()));
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Parameter toBeDeleted, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") ParameterGroup groupToBeDeleted) {
        return toBeDeleted != null || groupToBeDeleted != null;
    }
}

