/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.views;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.impl.DirectToolItemImpl;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.grits.toolbox.editor.experimentdesigner.editing.TextValueEditingSupport;
import org.grits.toolbox.editor.experimentdesigner.editing.UnitEditingSupport;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.EntityWithPosition;
import org.grits.toolbox.editor.experimentdesigner.model.MeasurementUnit;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.parts.GraphNodeEditPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ParameterView {
    public static final String VIEW_ID = "org.grits.toolbox.editor.experimentdesigner.part.parameterview";
    private static Logger logger = Logger.getLogger(ParameterView.class);
    ProtocolNode protocol;
    TreeViewer treeViewer;
    @Inject
    EventBroker eventBroker;
    @Inject
    ESelectionService selectionService;
    GraphEditor editor;
    private DirectToolItemImpl deleteParamToolItem;
    private TextValueEditingSupport textEditingSupport;
    private UnitEditingSupport unitEditingSupport;
    private final EventHandler closePartEventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object part = event.getProperty("ChangedElement");
            if (part == null) {
                return;
            }
            boolean toBeRendered = (Boolean)event.getProperty("NewValue");
            if (!toBeRendered && part instanceof MPart && ((MPart)part).getObject() instanceof CompatibilityEditor && ((CompatibilityEditor)((MPart)part).getObject()).getEditor() instanceof GraphEditor && ParameterView.this.treeViewer != null && !ParameterView.this.treeViewer.getTree().isDisposed()) {
                ParameterView.this.treeViewer.getTree().setRedraw(true);
                ParameterView.this.treeViewer.getTree().removeAll();
                ParameterView.this.protocol = null;
            }
        }
    };

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    @PostConstruct
    public void createPartControl(Composite parent, MPart part, EModelService modelService) {
        this.treeViewer = new TreeViewer(parent, 67584);
        final Tree tree = this.treeViewer.getTree();
        this.textEditingSupport = new TextValueEditingSupport(this.treeViewer);
        this.unitEditingSupport = new UnitEditingSupport(this.treeViewer);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Tree source = (Tree)e.getSource();
                TreeItem[] selections = source.getSelection();
                if (selections.length == 0) {
                    ParameterView.this.deleteParamToolItem.setEnabled(false);
                }
                int i = 0;
                while (i < selections.length) {
                    TreeItem item = selections[i];
                    Object element = item.getData();
                    if (element instanceof Parameter) {
                        TreeItem parent = item.getParentItem();
                        if (parent != null && parent.getData() instanceof ParameterGroup) {
                            ParameterView.this.deleteParamToolItem.setEnabled(false);
                            break;
                        }
                        ParameterView.this.deleteParamToolItem.setEnabled(true);
                        ParameterView.this.selectionService.setSelection((Object)((Parameter)element));
                        break;
                    }
                    if (element instanceof ParameterGroup) {
                        ParameterView.this.selectionService.setSelection((Object)((ParameterGroup)element));
                        ParameterView.this.deleteParamToolItem.setEnabled(true);
                        break;
                    }
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TreeViewerColumn nameViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn nameColumn = nameViewerColumn.getColumn();
        nameColumn.setWidth(161);
        nameColumn.setText("name");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)nameViewerColumn.getViewer());
        nameViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ParameterGroup) {
                    return ((ParameterGroup)element).getLabel();
                }
                if (element instanceof Parameter) {
                    return ((Parameter)element).getName();
                }
                return null;
            }

            public Color getForeground(Object element) {
                if (element instanceof ParameterGroup ? ((ParameterGroup)element).getRequired() != null && ((ParameterGroup)element).getRequired() != false : element instanceof Parameter && ((Parameter)element).getRequired() != null && ((Parameter)element).getRequired() != false) {
                    return ColorConstants.red;
                }
                return super.getForeground(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof ParameterGroup) {
                    return ((ParameterGroup)element).getDescription();
                }
                if (element instanceof Parameter) {
                    return ((Parameter)element).getDescription();
                }
                return null;
            }

            public Image getToolTipImage(Object object) {
                return null;
            }
        });
        nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int dir = tree.getSortDirection();
                dir = dir == 128 ? 1024 : 128;
                tree.setSortDirection(dir);
                ParameterView.this.treeViewer.refresh();
            }
        });
        TreeViewerColumn valueViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn valueColumn = valueViewerColumn.getColumn();
        valueColumn.setWidth(200);
        valueColumn.setText("value");
        valueViewerColumn.setEditingSupport((EditingSupport)this.textEditingSupport);
        valueViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Parameter) {
                    return ((Parameter)element).getValue();
                }
                return null;
            }
        });
        TreeViewerColumn unitViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn unitColumn = unitViewerColumn.getColumn();
        unitColumn.setWidth(100);
        unitColumn.setText("unit");
        unitViewerColumn.setEditingSupport((EditingSupport)this.unitEditingSupport);
        unitViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Parameter) {
                    MeasurementUnit unit = ((Parameter)element).getUnit();
                    if (unit != null) {
                        return unit.getLabel();
                    }
                    List<MeasurementUnit> units = ((Parameter)element).getAvailableUnits();
                    if (units != null && units.size() > 0) {
                        ((Parameter)element).setUnit(units.get(0));
                        return units.get(0).getLabel();
                    }
                }
                return null;
            }
        });
        TreeViewerColumn guidelineViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn guidelineColumn = guidelineViewerColumn.getColumn();
        guidelineColumn.setWidth(200);
        guidelineColumn.setText("guidelines");
        guidelineViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                List<String> guidelines = null;
                if (element instanceof Parameter) {
                    guidelines = ((Parameter)element).getGuidelineURIs();
                } else if (element instanceof ParameterGroup) {
                    guidelines = ((ParameterGroup)element).getGuidelineURIs();
                }
                if (guidelines != null) {
                    String stringValue = "";
                    for (String guideline : guidelines) {
                        if (!stringValue.isEmpty()) {
                            stringValue = String.valueOf(stringValue) + ", ";
                        }
                        stringValue = String.valueOf(stringValue) + guideline;
                    }
                    return stringValue;
                }
                return null;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ParameterContentProvider());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int c = 0;
                int dir = ((TreeViewer)viewer).getTree().getSortDirection();
                if (e1 instanceof EntityWithPosition && e2 instanceof EntityWithPosition) {
                    if (((EntityWithPosition)e1).getPosition() != null && ((EntityWithPosition)e2).getPosition() != null) {
                        c = ((EntityWithPosition)e1).getPosition().compareTo(((EntityWithPosition)e2).getPosition());
                    } else if (e1 instanceof ParameterGroup && e2 instanceof ParameterGroup) {
                        c = ((ParameterGroup)e1).getLabel().compareTo(((ParameterGroup)e2).getLabel());
                    } else if (e1 instanceof Parameter && e2 instanceof Parameter) {
                        c = ((Parameter)e1).getName().compareTo(((Parameter)e2).getName());
                    }
                }
                return dir == 128 ? c : -c;
            }
        });
        this.treeViewer.expandAll();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setSortColumn(nameColumn);
        tree.setSortDirection(128);
        if (this.protocol == null) {
            this.treeViewer.setInput(new ArrayList());
        } else {
            ArrayList<EntityWithPosition> paramsAndParamGroups = new ArrayList<EntityWithPosition>(this.protocol.getParameterGroups().size() + this.protocol.getParameters().size());
            paramsAndParamGroups.addAll(this.protocol.getParameterGroups());
            paramsAndParamGroups.addAll(this.protocol.getParameters());
            this.treeViewer.setInput(paramsAndParamGroups);
        }
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.closePartEventHandler);
        this.deleteParamToolItem = (DirectToolItemImpl)modelService.find("org.grits.toolbox.editor.experimentdesigner.directtoolitem.deleteparameter", (MUIElement)part.getToolbar());
    }

    @Inject
    @Optional
    public void subscribeTopicPartActivation(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event, IEclipseContext eclipseContext) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MPart)) {
            return;
        }
        MPart part = (MPart)element;
        if (part.getObject() instanceof CompatibilityEditor && ((CompatibilityEditor)part.getObject()).getEditor() instanceof GraphEditor) {
            this.editor = (GraphEditor)((CompatibilityEditor)part.getObject()).getEditor();
            this.textEditingSupport.setEditor(this.editor);
            this.unitEditingSupport.setGraphEditor(this.editor);
            logger.debug((Object)("Parameter View - Active Graph Editor changed to: " + this.editor.getPartName()));
        }
    }

    @PreDestroy
    public void preDestroy(MPart part) {
        this.eventBroker.unsubscribe(this.closePartEventHandler);
    }

    @Focus
    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    @Inject
    void setSelection(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object selection) {
        if (selection != null && !(selection instanceof StructuredSelection)) {
            return;
        }
        if (selection == null || !(((StructuredSelection)selection).getFirstElement() instanceof GraphNodeEditPart)) {
            this.protocol = null;
            if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
                this.treeViewer.getTree().setRedraw(true);
                this.treeViewer.getTree().removeAll();
            }
        } else if (((StructuredSelection)selection).getFirstElement() instanceof GraphNodeEditPart) {
            Object modelObject = ((GraphNodeEditPart)((StructuredSelection)selection).getFirstElement()).getModel();
            if (modelObject instanceof ProtocolNode) {
                this.protocol = (ProtocolNode)modelObject;
                ArrayList<EntityWithPosition> paramsAndParamGroups = new ArrayList<EntityWithPosition>();
                if (this.protocol.getParameterGroups() != null) {
                    paramsAndParamGroups.addAll(this.protocol.getParameterGroups());
                }
                if (this.protocol.getParameters() != null) {
                    paramsAndParamGroups.addAll(this.protocol.getParameters());
                }
                if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
                    this.treeViewer.setInput(paramsAndParamGroups);
                    this.treeViewer.expandAll();
                }
            } else {
                this.protocol = null;
                if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
                    this.treeViewer.getTree().setRedraw(true);
                    this.treeViewer.getTree().removeAll();
                }
            }
        }
    }

    public ProtocolNode getProtocol() {
        return this.protocol;
    }

    class ParameterContentProvider
    implements ITreeContentProvider {
        ParameterContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            if (parentElement instanceof ParameterGroup) {
                return ((ParameterGroup)parentElement).getParameters().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return ((List)element).size() > 0;
            }
            if (element instanceof ParameterGroup) {
                return ((ParameterGroup)element).getParameters().size() > 0;
            }
            return false;
        }
    }
}

