/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.parts;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;

public class InputOutputFigure
extends Figure {
    static int maxLength = 200;
    static int maxHeight = 150;
    private TextFlow label;
    private Ellipse ellipse;
    private FlowPage flowPage;

    public InputOutputFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.ellipse = new Ellipse();
        this.add((IFigure)this.ellipse);
        this.flowPage = new FlowPage();
        this.label = new TextFlow();
        ParagraphTextLayout layout = new ParagraphTextLayout(this.label, 1);
        this.label.setLayoutManager((LayoutManager)layout);
        this.flowPage.add((IFigure)this.label);
        this.flowPage.setHorizontalAligment(2);
        this.add((IFigure)this.flowPage);
    }

    public TextFlow getLabel() {
        return this.label;
    }

    public Rectangle getBounds() {
        Rectangle original = super.getBounds();
        if (this.label.getFont() != null) {
            Label testLabel = new Label();
            testLabel.setText(this.label.getText());
            Rectangle labelBounds = testLabel.getTextBounds();
            if (labelBounds.width > original.width) {
                if (labelBounds.width < maxLength) {
                    original.setWidth(labelBounds.width + 10);
                } else {
                    original.setWidth(maxLength);
                }
            }
            if (labelBounds.height > original.height) {
                if (labelBounds.height < maxHeight) {
                    original.setHeight(labelBounds.height + 10);
                } else {
                    original.setHeight(maxHeight);
                }
            }
        }
        return original;
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle r = this.getBounds().getCopy();
        this.setConstraint((IFigure)this.ellipse, new Rectangle(0, 0, r.width, r.height));
        this.setConstraint((IFigure)this.flowPage, new Rectangle(0, r.height / 2 - 7, r.width, r.height));
        this.flowPage.setConstraint((IFigure)this.label, (Object)new Rectangle(0, 0, r.width, r.height));
        this.ellipse.invalidate();
        this.flowPage.invalidate();
        this.label.invalidate();
    }
}

