/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.handler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.editor.EditorHandler;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.editor.experimentdesigner.config.ExperimentConfig;
import org.grits.toolbox.editor.experimentdesigner.dialog.NewExperimentDialog;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolFileHandler;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentTemplateEntry;
import org.grits.toolbox.editor.experimentdesigner.property.ExperimentProperty;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.property.SampleProperty;

public class NewExperimentHandler {
    @Inject
    @Named(value="workspace_location")
    private static String workspaceLocation;
    @Inject
    private static IGritsDataModelService gritsDataModelService;
    @Inject
    static IGritsUIService gritsUIService;
    private static final Logger logger;
    public static final int COPY = 2;
    public static final int OVERRIDE = 3;
    public static final int COPY_OVERRIDE = 4;
    public static final int TEMPLATE = 5;
    public static final int TEMPLATE_OVERRIDE = 6;
    boolean overwrite = false;

    static {
        gritsDataModelService = null;
        gritsUIService = null;
        logger = Logger.getLogger(NewExperimentHandler.class);
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") @Named(value="activeShell") Shell shell) {
        Entry experimentEntry = null;
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.sample".equals(selectedEntry.getProperty().getType()))) {
            selectedEntry = null;
        }
        if ((experimentEntry = this.createNewExperimentDialog(shell, selectedEntry)) != null) {
            eventBroker.post("grits_entry_selected", (Object)experimentEntry);
        }
    }

    private Entry createNewExperimentDialog(Shell shell, Entry sample) {
        NewExperimentDialog dialog = new NewExperimentDialog(PropertyHandler.getModalDialog((Shell)shell));
        dialog.setBlockOnOpen(true);
        dialog.setSampleEntry(sample);
        int status = dialog.open();
        Entry toBeRemoved = dialog.getToBeRemoved();
        this.removeExistingDesign(shell, toBeRemoved);
        if (status == 0 || status == 3) {
            Entry selectedSampleEntry = dialog.getSampleEntry();
            try {
                String experimentFileName = NewExperimentHandler.createExperimentFileInSample(selectedSampleEntry, selectedSampleEntry.getDisplayName());
                boolean experimentExists = false;
                Entry experimentEntry = null;
                if (status == 0) {
                    for (Entry child : selectedSampleEntry.getChildren()) {
                        if (child.getProperty().getType() != "org.grits.toolbox.property.experiment" || !((ExperimentProperty)child.getProperty()).getExperimentFile().getName().equals(experimentFileName)) continue;
                        experimentEntry = child;
                        experimentExists = true;
                        break;
                    }
                }
                if (!experimentExists) {
                    experimentEntry = NewExperimentHandler.createEntry(selectedSampleEntry.getDisplayName(), experimentFileName);
                    experimentEntry.setParent(selectedSampleEntry);
                    gritsDataModelService.addEntry(selectedSampleEntry, experimentEntry);
                    try {
                        ProjectFileHandler.saveProject((Entry)selectedSampleEntry.getParent());
                    }
                    catch (IOException e) {
                        logger.error((Object)("Something went wrong while saving analyte entry \n" + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
                if (status == 3) {
                    EditorHandler.openEditorForEntry((Entry)experimentEntry, (boolean)true);
                } else {
                    EditorHandler.openEditorForEntry((Entry)experimentEntry);
                }
                PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective");
                PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective.<Experiment Design>");
                return experimentEntry;
            }
            catch (IOException e) {
                logger.error((Object)("org.grits.toolbox.editor.experimentdesigner " + e.getMessage()), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)e.getMessage(), (Exception)e);
            }
        } else if (status == 2 || status == 4) {
            Entry experimentEntry = dialog.getSelectedExperiment();
            if (experimentEntry == null) {
                throw new RuntimeException("An existing experiment design is not selected");
            }
            sample = dialog.getSampleEntry();
            File experimentFolder = NewExperimentHandler.getExperimentDirectory(sample);
            String experimentFileNameCopy = ((SampleProperty)sample.getProperty()).getSampleFile().getName().replace("sample", "experiment");
            File originalExperimentFolder = NewExperimentHandler.getExperimentDirectory(experimentEntry.getParent());
            File originalFile = new File(String.valueOf(originalExperimentFolder.getAbsolutePath()) + File.separator + ((ExperimentProperty)experimentEntry.getProperty()).getExperimentFile().getName());
            try {
                FileOutputStream newFile = new FileOutputStream(String.valueOf(experimentFolder.getAbsolutePath()) + File.separator + experimentFileNameCopy);
                Files.copy(originalFile.toPath(), newFile);
                newFile.close();
                NewExperimentHandler.replaceInputOutputNodes(String.valueOf(experimentFolder.getAbsolutePath()) + File.separator + experimentFileNameCopy, sample, experimentEntry.getParent());
                Entry newExperimentEntry = NewExperimentHandler.createEntry(sample.getDisplayName(), experimentFileNameCopy);
                newExperimentEntry.setParent(sample);
                gritsDataModelService.addEntry(sample, newExperimentEntry);
                try {
                    ProjectFileHandler.saveProject((Entry)sample.getParent());
                }
                catch (IOException e) {
                    logger.error((Object)("Something went wrong while saving analyte entry \n" + e.getMessage()), (Throwable)e);
                    throw e;
                }
                EditorHandler.openEditorForEntry((Entry)newExperimentEntry, (boolean)true);
                PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective");
                PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective.<Experiment Design>");
                return newExperimentEntry;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design", (Exception)e);
            }
            catch (IOException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design", (Exception)e);
            }
            catch (JAXBException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design", (Exception)((Object)e));
            }
        } else if (status == 5 || status == 6) {
            ExperimentTemplateEntry templateFile = dialog.getTemplateFile();
            sample = dialog.getSampleEntry();
            File experimentFolder = NewExperimentHandler.getExperimentDirectory(sample);
            String experimentFileNameCopy = ((SampleProperty)sample.getProperty()).getSampleFile().getName().replace("sample", "experiment");
            File originalFile = null;
            if (templateFile.isFromJar()) {
                URL url = ExperimentConfig.EXPERIMET_TEMPLATE_RESOURCE_URL;
                if (url == null) {
                    logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design template! no template directory found in jar");
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design template. Reason: No Template directory found in jar");
                }
                try {
                    URL resourceFileUrl = FileLocator.toFileURL((URL)url);
                    originalFile = new File(String.valueOf(resourceFileUrl.toURI().getRawPath()) + File.separator + templateFile.getFilename());
                }
                catch (IOException | URISyntaxException e) {
                    logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design template!", (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design template", (Exception)e);
                }
            } else {
                originalFile = new File(String.valueOf(ExperimentDesignOntologyAPI.getTemplateFolderLocation()) + File.separator + templateFile.getFilename());
            }
            try {
                FileOutputStream newFile = new FileOutputStream(String.valueOf(experimentFolder.getAbsolutePath()) + File.separator + experimentFileNameCopy);
                Files.copy(originalFile.toPath(), newFile);
                newFile.close();
                NewExperimentHandler.replaceInputOutputNodes(String.valueOf(experimentFolder.getAbsolutePath()) + File.separator + experimentFileNameCopy, sample, null);
                Entry newExperimentEntry = NewExperimentHandler.createEntry(sample.getDisplayName(), experimentFileNameCopy);
                newExperimentEntry.setParent(sample);
                gritsDataModelService.addEntry(sample, newExperimentEntry);
                try {
                    ProjectFileHandler.saveProject((Entry)sample.getParent());
                }
                catch (IOException e) {
                    logger.error((Object)("Something went wrong while saving analyte entry \n" + e.getMessage()), (Throwable)e);
                    throw e;
                }
                EditorHandler.openEditorForEntry((Entry)newExperimentEntry, (boolean)true);
                PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective");
                PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective.<Experiment Design>");
                return newExperimentEntry;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design template!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design template", (Exception)e);
            }
            catch (IOException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design template!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design template", (Exception)e);
            }
            catch (JAXBException e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot copy from existing experiment design template!", (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot copy from existing experiment design template", (Exception)((Object)e));
            }
        }
        return null;
    }

    private void removeExistingDesign(Shell shell, Entry toBeRemoved) {
        try {
            if (toBeRemoved != null) {
                gritsDataModelService.deleteEntry(toBeRemoved);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not replace the existing experiment design", (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Could not replace the existing experiment design", (Exception)e);
        }
    }

    private static void replaceInputOutputNodes(String experimentFile, Entry sample, Entry original) throws JAXBException, IOException {
        int locationY = 210;
        FileInputStream inputStream = new FileInputStream(experimentFile);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        ExperimentGraph graph = (ExperimentGraph)unmarshaller.unmarshal((Reader)reader);
        graph.setConnectionsToNodes();
        graph.setName(sample.getDisplayName());
        graph.setProjectEntry(sample.getParent());
        reader.close();
        inputStream.close();
        List children = graph.getChildren();
        ArrayList<GraphNode> nodesToRemove = new ArrayList<GraphNode>();
        for (GraphNode graphNode : children) {
            locationY = Math.max(graphNode.getLocation().y, locationY);
            if (graphNode instanceof InputNode || graphNode instanceof OutputNode) {
                nodesToRemove.add(graphNode);
            }
            if (!(graphNode instanceof ProtocolNode) || ((ProtocolNode)graphNode).getFile() == null) continue;
            if (original == null) {
                if (ProtocolFileHandler.copyFromConfigToWorkspace(((ProtocolNode)graphNode).getFile(), sample.getParent().getDisplayName()) != null) continue;
                logger.warn((Object)("Could not copy the associated file for the protocol: " + ((ProtocolNode)graphNode).getFile()));
                continue;
            }
            if (sample.getParent().getDisplayName().equals(original.getParent().getDisplayName()) || ProtocolFileHandler.copyFromProjectToAnother(((ProtocolNode)graphNode).getFile(), sample.getParent().getDisplayName(), original.getParent().getDisplayName()) != null) continue;
            logger.warn((Object)("Could not copy the associated file for the protocol: " + ((ProtocolNode)graphNode).getFile()));
        }
        for (GraphNode node : nodesToRemove) {
            List<Connection> connections = null;
            if (node instanceof InputNode) {
                connections = node.getSourceConnections();
            } else if (node instanceof OutputNode) {
                connections = node.getTargetConnections();
            }
            boolean wasRemoved = graph.removeChild(node);
            if (!wasRemoved || connections == null) continue;
            for (Connection conn : connections) {
                conn.disconnect();
            }
        }
        NewExperimentHandler.addInputOutputNodes(sample, graph, locationY);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)graph, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(experimentFile);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }

    public static String createExperimentFileInSample(Entry selectedSampleEntry, String experimentName) throws IOException {
        File experimentFolder = NewExperimentHandler.getExperimentDirectory(selectedSampleEntry);
        String experimentFileName = ((SampleProperty)selectedSampleEntry.getProperty()).getSampleFile().getName().replace("sample", "experiment");
        File file = new File(String.valueOf(experimentFolder.getAbsolutePath()) + File.separator + experimentFileName);
        if (!file.exists()) {
            NewExperimentHandler.createFileContent(selectedSampleEntry, experimentFolder, experimentFileName, experimentName);
        }
        return experimentFileName;
    }

    private static void addInputOutputNodes(Entry sampleEntry, ExperimentGraph experimentDesign, int outputLocation) throws IOException {
        Point originalLocation = new Point(50, 10);
        try {
            Sample sample = SampleProperty.loadAnalyte((Entry)sampleEntry);
            List components = sample.getComponents();
            for (Component component : components) {
                InputNode newNode = new InputNode();
                newNode.setLabel(component.getLabel());
                newNode.setColor(ColorConstants.red);
                newNode.setUri(component.getUri());
                newNode.setComponentId(component.getComponentId());
                newNode.setDescription(component.getDescription());
                originalLocation = originalLocation.translate(100, 0);
                newNode.setLocation(originalLocation);
                experimentDesign.addChild(newNode);
            }
            originalLocation = new Point(50, outputLocation + 100);
            List children = sampleEntry.getChildren();
            for (Entry entry : children) {
                Property prop = entry.getProperty();
                if (prop.getType() == "org.grits.toolbox.property.experiment") continue;
                OutputNode newNode = new OutputNode();
                newNode.setLabel(entry.getDisplayName());
                originalLocation = originalLocation.translate(100, 0);
                newNode.setLocation(originalLocation);
                newNode.setColor(ColorConstants.lightGreen);
                experimentDesign.addChild(newNode);
            }
        }
        catch (JAXBException e1) {
            throw new IOException("Error loading components/experiments from " + sampleEntry, e1);
        }
    }

    private static void createFileContent(Entry selectedSampleEntry, File experimentFolder, String experimentFileName, String experimentName) throws IOException {
        ExperimentGraph experimentDesign = new ExperimentGraph();
        experimentDesign.setName(experimentName);
        experimentDesign.setDateCreated(new Date());
        try {
            NewExperimentHandler.addInputOutputNodes(selectedSampleEntry, experimentDesign, 210);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)experimentDesign, (OutputStream)os);
            FileWriter fileWriter = new FileWriter(String.valueOf(experimentFolder.getAbsolutePath()) + File.separator + experimentFileName);
            fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
            fileWriter.close();
            os.close();
        }
        catch (JAXBException e) {
            throw new IOException("Error creating new file", e);
        }
        catch (IOException iOException) {
            throw new IOException("Error creating new file");
        }
    }

    public static Entry createEntry(String newEntryName, String experimentFileName) {
        Entry newEntry = new Entry();
        newEntry.setEntryType(Entry.ENTRY_TYPE_HIDDEN);
        newEntry.setDisplayName(newEntryName);
        ExperimentProperty property = new ExperimentProperty();
        ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
        PropertyDataFile samplePropertyFile = new PropertyDataFile(experimentFileName, ExperimentGraph.CURRENT_VERSION, "default");
        dataFiles.add(samplePropertyFile);
        property.setDataFiles(dataFiles);
        newEntry.setProperty((Property)property);
        return newEntry;
    }

    public static File getExperimentDirectory(Entry selectedSampleEntry) {
        Entry projectEntry = selectedSampleEntry.getParent();
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + projectEntry.getDisplayName();
        String experimentFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "experiments";
        File experimentFolder = new File(experimentFolderLocation);
        if (!experimentFolder.exists() || !experimentFolder.isDirectory()) {
            experimentFolder.mkdir();
        }
        return experimentFolder;
    }
}

