/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.editing;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.typeahead.NamespaceHandler;
import org.grits.toolbox.core.typeahead.PatriciaTrieContentProposalProvider;
import org.grits.toolbox.core.utilShare.validator.BooleanValidator;
import org.grits.toolbox.core.utilShare.validator.IntegerValidator;
import org.grits.toolbox.editor.experimentdesigner.editing.DoubleValidator;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.namespace.ShortNamespacesHandler;
import org.grits.toolbox.editor.experimentdesigner.ontology.OntologyManager;
import org.grits.toolbox.entry.sample.utilities.TextCellEditorWithContentProposal;

public class TextValueEditingSupport
extends EditingSupport {
    static Logger logger = Logger.getLogger(TextValueEditingSupport.class);
    TreeViewer viewer;
    TextCellEditor textCellEditor;
    TextCellEditor doubleCellEditor;
    TextCellEditor integerCellEditor;
    TextCellEditor booleanCellEditor;
    ComboBoxViewerCellEditor comboBoxViewerCellEditor;
    private GraphEditor editor;

    public void setEditor(GraphEditor editor) {
        this.editor = editor;
    }

    public TextValueEditingSupport(TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        this.viewer = treeViewer;
        this.textCellEditor = new TextCellEditor((Composite)this.viewer.getTree());
        ((Text)this.textCellEditor.getControl()).setTextLimit(5000);
        this.doubleCellEditor = new TextCellEditor((Composite)this.viewer.getTree());
        ((Text)this.doubleCellEditor.getControl()).setTextLimit(80);
        ControlDecoration controlDecoration = new ControlDecoration(this.doubleCellEditor.getControl(), 0x1000000);
        this.doubleCellEditor.setValidator((ICellEditorValidator)new DoubleValidator(controlDecoration));
        this.integerCellEditor = new TextCellEditor((Composite)this.viewer.getTree());
        ((Text)this.integerCellEditor.getControl()).setTextLimit(80);
        controlDecoration = new ControlDecoration(this.integerCellEditor.getControl(), 0x1000000);
        this.integerCellEditor.setValidator((ICellEditorValidator)new IntegerValidator(controlDecoration));
        this.booleanCellEditor = new TextCellEditor((Composite)this.viewer.getTree());
        ((Text)this.booleanCellEditor.getControl()).setTextLimit(80);
        controlDecoration = new ControlDecoration(this.booleanCellEditor.getControl(), 0x1000000);
        this.booleanCellEditor.setValidator((ICellEditorValidator)new BooleanValidator(controlDecoration));
        this.comboBoxViewerCellEditor = new ComboBoxViewerCellEditor((Composite)this.viewer.getTree(), 8);
        this.comboBoxViewerCellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        if (ShortNamespacesHandler.NAMESPACE_VALUES_MAP == null) {
            ShortNamespacesHandler.loadShortNamespaceFiles();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CellEditor getCellEditor(Object element) {
        if (!(element instanceof Parameter)) return null;
        String namespace = ((Parameter)element).getNamespace();
        String namespaceFile = ((Parameter)element).getNamespaceFile();
        Boolean shortNamespace = ((Parameter)element).getShortNamespace();
        String value = ((Parameter)element).getValue();
        if (namespace != null && namespace.equals(String.valueOf(OntologyManager.baseURI) + "double")) {
            return this.doubleCellEditor;
        }
        if (namespace == null || namespace.equals(String.valueOf(OntologyManager.baseURI) + "string")) {
            return this.textCellEditor;
        }
        if (namespace == null || namespace.equals(String.valueOf(OntologyManager.baseURI) + "integer")) {
            return this.integerCellEditor;
        }
        if (namespace == null || namespace.equals(String.valueOf(OntologyManager.baseURI) + "boolean")) {
            return this.booleanCellEditor;
        }
        if (namespaceFile != null && shortNamespace.booleanValue()) {
            try {
                if (!ShortNamespacesHandler.NAMESPACE_VALUES_MAP.containsKey(namespace) || ShortNamespacesHandler.NAMESPACE_VALUES_MAP.get(namespace) == null) {
                    throw new Exception("No namespace value found for : " + namespace);
                }
                Set<String> valueSet = ShortNamespacesHandler.NAMESPACE_VALUES_MAP.get(namespace);
                this.comboBoxViewerCellEditor.setInput((Object)valueSet.toArray());
                if (value == null || valueSet.contains(value)) return this.comboBoxViewerCellEditor;
                valueSet.add(value);
                this.comboBoxViewerCellEditor.setValue((Object)value);
                return this.comboBoxViewerCellEditor;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Namespace File Error", (String)("Could not find namespace for the parameter " + ((Parameter)element).getName() + "\n" + ex.getMessage()));
                return this.textCellEditor;
            }
        }
        if (namespaceFile == null) return this.textCellEditor;
        try {
            NamespaceHandler handler = new NamespaceHandler(namespace, null, ((Parameter)element).getNamespaceFile(), "org.grits.toolbox.editor.experimentdesigner");
            PatriciaTrie trie = handler.getTrieForNamespace();
            if (trie == null) return null;
            PatriciaTrieContentProposalProvider contentProposalProvider = new PatriciaTrieContentProposalProvider(trie);
            ColumnViewer viewer = this.getViewer();
            if (viewer == null) return null;
            return new TextCellEditorWithContentProposal((Composite)viewer.getControl(), (IContentProposalProvider)contentProposalProvider, null, null);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Type Ahead Error", (String)("Something went wrong for the namespace " + namespace + ".Typeahead is not available!"));
            return this.textCellEditor;
        }
    }

    protected boolean canEdit(Object element) {
        if (element instanceof Parameter) {
            return true;
        }
        if (element instanceof ParameterGroup) {
            return false;
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (element == null) {
            return "";
        }
        if (((Parameter)element).getValue() == null) {
            return "";
        }
        return ((Parameter)element).getValue();
    }

    protected void setValue(Object element, Object value) {
        if (element != null && element instanceof Parameter) {
            String oldValue = ((Parameter)element).getValue();
            String newValue = value == null ? null : String.valueOf(value).trim();
            ((Parameter)element).setValue(newValue);
            if (!Objects.equals(oldValue, newValue)) {
                if (this.editor == null) {
                    logger.error((Object)"Cannot get the reference to Graph Editor");
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
                    return;
                }
                this.editor.refreshParameter((Parameter)element);
            }
            this.viewer.update(element, null);
        }
    }
}

