/*
 * Decompiled with CFR 0.152.
 */
package org.glycomedb.residuetranslator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;
import org.glycomedb.residuetranslator.ResidueLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidueTranslator
implements MonosaccharideConversion {
    private HashMap<GlycanNamescheme, HashMap<String, MonosaccharideExchangeObject>> m_monosaccharideMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, SubstituentExchangeObject>> m_substitutentMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, List<MonosaccharideExchangeObject>>> m_msFromGlycoCTMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, List<SubstituentExchangeObject>>> m_substFromGlycoCTMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, String>> m_nonCarbohydrateMapping = new HashMap();

    public ResidueTranslator() throws IOException {
        ResidueLoader residueLoader = new ResidueLoader();
        residueLoader.loadResidues();
        this.m_monosaccharideMapping = residueLoader.getMonosaccharideMapping();
        this.m_substitutentMapping = residueLoader.getSubstitutentMapping();
        this.m_msFromGlycoCTMapping = residueLoader.getMsFromGlycoCTMapping();
        this.m_substFromGlycoCTMapping = residueLoader.getSubstFromGlycoCTMapping();
        this.m_nonCarbohydrateMapping = residueLoader.getAglycaMapping();
    }

    public String checkAglycon(String string, GlycanNamescheme glycanNamescheme) throws ResourcesDbException {
        throw new ResourcesDbException("Methode checkAglycon is not supported.");
    }

    public String checkSubstituent(String string, GlycanNamescheme glycanNamescheme) throws ResourcesDbException {
        throw new ResourcesDbException("Methode checkSubstituent is not supported.");
    }

    public MonosaccharideExchangeObject convertResidue(String string, GlycanNamescheme glycanNamescheme, GlycanNamescheme glycanNamescheme2) throws ResourcesDbException {
        throw new ResourcesDbException("Methode convertResidue is not supported.");
    }

    public String convertSubstituent(String string, GlycanNamescheme glycanNamescheme, GlycanNamescheme glycanNamescheme2) throws ResourcesDbException {
        throw new ResourcesDbException("Methode convertSubstituent is not supported.");
    }

    public MonosaccharideExchangeObject validateGlycoCT(MonosaccharideExchangeObject monosaccharideExchangeObject) throws ResourcesDbException {
        throw new ResourcesDbException("Methode validateGlycoCT is not supported.");
    }

    public SubstituentExchangeObject convertSubstituent(SubstituentExchangeObject substituentExchangeObject, GlycanNamescheme glycanNamescheme, GlycanNamescheme glycanNamescheme2) throws ResourcesDbException {
        if (glycanNamescheme.equals((Object)GlycanNamescheme.GLYCOCT)) {
            HashMap<String, List<SubstituentExchangeObject>> hashMap = this.m_substFromGlycoCTMapping.get(glycanNamescheme2);
            if (hashMap == null) {
                throw new ResourcesDbException("Methode convertSubstituent does not support namespace " + glycanNamescheme.getNameStr());
            }
            List<SubstituentExchangeObject> list = hashMap.get(substituentExchangeObject.getName().toLowerCase());
            if (list == null) {
                throw new ResourcesDbException("Not a known substituent in " + glycanNamescheme2.getNameStr() + " : " + substituentExchangeObject.getName());
            }
            for (SubstituentExchangeObject substituentExchangeObject2 : list) {
                if (!(substituentExchangeObject2.getLinkagetype1() == substituentExchangeObject.getLinkagetype1() ? (substituentExchangeObject2.getLinkagetype2() == substituentExchangeObject2.getLinkagetype2() ? substituentExchangeObject2.getLinkagetype3() == substituentExchangeObject2.getLinkagetype3() : substituentExchangeObject2.getLinkagetype2() == substituentExchangeObject2.getLinkagetype3() && substituentExchangeObject2.getLinkagetype3() == substituentExchangeObject2.getLinkagetype2()) : (substituentExchangeObject2.getLinkagetype1() == substituentExchangeObject.getLinkagetype2() ? (substituentExchangeObject2.getLinkagetype2() == substituentExchangeObject2.getLinkagetype1() ? substituentExchangeObject2.getLinkagetype3() == substituentExchangeObject2.getLinkagetype3() : substituentExchangeObject2.getLinkagetype2() == substituentExchangeObject2.getLinkagetype3() && substituentExchangeObject2.getLinkagetype3() == substituentExchangeObject2.getLinkagetype1()) : substituentExchangeObject2.getLinkagetype1() == substituentExchangeObject.getLinkagetype3() && (substituentExchangeObject2.getLinkagetype2() == substituentExchangeObject2.getLinkagetype1() ? substituentExchangeObject2.getLinkagetype3() == substituentExchangeObject2.getLinkagetype2() : substituentExchangeObject2.getLinkagetype2() == substituentExchangeObject2.getLinkagetype2() && substituentExchangeObject2.getLinkagetype3() == substituentExchangeObject2.getLinkagetype1())))) continue;
                return this.toCopy(substituentExchangeObject2);
            }
            throw new ResourcesDbException("Not a substituent in namespace " + glycanNamescheme.getNameStr() + " : " + substituentExchangeObject.getName() + "(" + substituentExchangeObject.getLinkagetype1() + "," + substituentExchangeObject.getLinkagetype2() + "," + substituentExchangeObject.getLinkagetype3() + ")");
        }
        if (glycanNamescheme2.equals((Object)GlycanNamescheme.GLYCOCT)) {
            HashMap<String, SubstituentExchangeObject> hashMap = this.m_substitutentMapping.get(glycanNamescheme);
            if (hashMap == null) {
                throw new ResourcesDbException("Methode convertSubstituent does not support namespace " + glycanNamescheme.getNameStr());
            }
            SubstituentExchangeObject substituentExchangeObject3 = hashMap.get(substituentExchangeObject.getName().toLowerCase());
            if (substituentExchangeObject3 == null) {
                throw new ResourcesDbException("Not a known substituent: " + substituentExchangeObject.getName());
            }
            return substituentExchangeObject3;
        }
        throw new ResourcesDbException("Methode convertSubstituent is not supported for input namespace " + glycanNamescheme.getNameStr() + " to namespace " + glycanNamescheme2.getNameStr());
    }

    private SubstituentExchangeObject toCopy(SubstituentExchangeObject substituentExchangeObject) {
        SubstituentExchangeObject substituentExchangeObject2 = new SubstituentExchangeObject(substituentExchangeObject.getNamescheme());
        substituentExchangeObject2.setName(substituentExchangeObject.getOriginalName());
        return substituentExchangeObject2;
    }

    public String convertAglycon(String string, GlycanNamescheme glycanNamescheme, GlycanNamescheme glycanNamescheme2) throws ResourcesDbException {
        if (!glycanNamescheme2.equals((Object)GlycanNamescheme.GLYCOCT)) {
            throw new ResourcesDbException("Methode convertAglycon() is not supported for input namespace " + glycanNamescheme.getNameStr() + " to namespace " + glycanNamescheme2.getNameStr());
        }
        HashMap<String, String> hashMap = this.m_nonCarbohydrateMapping.get(glycanNamescheme);
        if (hashMap == null) {
            throw new ResourcesDbException("Methode convertAglycon() is not supported for input namespace " + glycanNamescheme.getNameStr());
        }
        String string2 = hashMap.get(string.toLowerCase());
        if (string2 == null) {
            throw new ResourcesDbException("Unknown non carbohydrate residue : " + string);
        }
        return string2;
    }

    public MonosaccharideExchangeObject convertMonosaccharide(String string, GlycanNamescheme glycanNamescheme, GlycanNamescheme glycanNamescheme2) throws ResourcesDbException {
        if (glycanNamescheme.equals((Object)GlycanNamescheme.GLYCOCT)) {
            throw new ResourcesDbException("Methode convertMonosaccharide(1) is not supported for input namespace " + glycanNamescheme.getNameStr() + " to namespace " + glycanNamescheme2.getNameStr());
        }
        if (!glycanNamescheme2.equals((Object)GlycanNamescheme.GLYCOCT)) {
            throw new ResourcesDbException("Methode convertMonosaccharide(1) is not supported for input namespace " + glycanNamescheme.getNameStr() + " to namespace " + glycanNamescheme2.getNameStr());
        }
        HashMap<String, MonosaccharideExchangeObject> hashMap = this.m_monosaccharideMapping.get(glycanNamescheme);
        if (hashMap == null) {
            throw new ResourcesDbException("Methode convertMonosaccharide(1) does not support namespace " + glycanNamescheme.getNameStr());
        }
        MonosaccharideExchangeObject monosaccharideExchangeObject = hashMap.get(string.toLowerCase());
        if (monosaccharideExchangeObject == null) {
            throw new ResourcesDbException("Not a known monosaccharide: " + string);
        }
        return monosaccharideExchangeObject;
    }

    public MonosaccharideExchangeObject convertMonosaccharide(MonosaccharideExchangeObject monosaccharideExchangeObject, GlycanNamescheme glycanNamescheme, GlycanNamescheme glycanNamescheme2) throws ResourcesDbException {
        if (glycanNamescheme2.equals((Object)GlycanNamescheme.GLYCOCT)) {
            throw new ResourcesDbException("Methode convertMonosaccharide(2) is not supported for inpupt namespace " + glycanNamescheme2.getNameStr() + " to namespace " + glycanNamescheme2.getNameStr());
        }
        if (!glycanNamescheme.equals((Object)GlycanNamescheme.GLYCOCT)) {
            throw new ResourcesDbException("Methode convertMonosaccharide(2) is not supported for input namespace " + glycanNamescheme.getNameStr() + " to namespace " + glycanNamescheme2.getNameStr());
        }
        HashMap<String, List<MonosaccharideExchangeObject>> hashMap = this.m_msFromGlycoCTMapping.get(glycanNamescheme2);
        if (hashMap == null) {
            throw new ResourcesDbException("Methode convertMonosaccharide(2) does not support namespace " + glycanNamescheme.getNameStr());
        }
        List<MonosaccharideExchangeObject> list = hashMap.get(monosaccharideExchangeObject.getBasetype().getGlycoCTName().toLowerCase());
        if (list == null) {
            throw new ResourcesDbException("Not a known monosaccharide: " + monosaccharideExchangeObject.getBasetype().getGlycoCTName());
        }
        MonosaccharideExchangeObject monosaccharideExchangeObject2 = null;
        for (MonosaccharideExchangeObject monosaccharideExchangeObject3 : list) {
            MonosaccharideExchangeObject monosaccharideExchangeObject4 = new MonosaccharideExchangeObject();
            boolean bl = false;
            for (SubstituentExchangeObject substituentExchangeObject : monosaccharideExchangeObject.getSubstituents()) {
                SubstituentExchangeObject substituentExchangeObject2 = this.findMatch(substituentExchangeObject, monosaccharideExchangeObject3.getSubstituents());
                if (substituentExchangeObject2 == null) {
                    substituentExchangeObject.setOriginalName(substituentExchangeObject.getName());
                    monosaccharideExchangeObject4.addSubstituent(substituentExchangeObject);
                    continue;
                }
                if (!this.isTwoInvolved(substituentExchangeObject2)) continue;
                bl = true;
            }
            if (monosaccharideExchangeObject.getSubstituents().size() - monosaccharideExchangeObject4.getSubstituents().size() != monosaccharideExchangeObject3.getSubstituents().size()) continue;
            if (monosaccharideExchangeObject2 == null) {
                monosaccharideExchangeObject2 = monosaccharideExchangeObject4;
                monosaccharideExchangeObject2.setMonosaccharideName(monosaccharideExchangeObject3.getMonosaccharideName());
                continue;
            }
            if (monosaccharideExchangeObject2.getSubstituents().size() == monosaccharideExchangeObject4.getSubstituents().size()) {
                if (!bl) continue;
                monosaccharideExchangeObject2 = monosaccharideExchangeObject4;
                monosaccharideExchangeObject2.setMonosaccharideName(monosaccharideExchangeObject3.getMonosaccharideName());
                continue;
            }
            if (monosaccharideExchangeObject2.getSubstituents().size() <= monosaccharideExchangeObject4.getSubstituents().size()) continue;
            monosaccharideExchangeObject2 = monosaccharideExchangeObject4;
            monosaccharideExchangeObject2.setMonosaccharideName(monosaccharideExchangeObject3.getMonosaccharideName());
        }
        if (monosaccharideExchangeObject2 == null) {
            throw new ResourcesDbException("Not a known monosaccharide with substituents: " + monosaccharideExchangeObject.getBasetype().getGlycoCTName());
        }
        return monosaccharideExchangeObject2;
    }

    private SubstituentExchangeObject findMatch(SubstituentExchangeObject substituentExchangeObject, ArrayList<SubstituentExchangeObject> arrayList) {
        for (SubstituentExchangeObject substituentExchangeObject2 : arrayList) {
            if (!substituentExchangeObject2.getName().equals(substituentExchangeObject.getName()) || !(this.matchSubstPosition(substituentExchangeObject.getLinkagetype1(), substituentExchangeObject.getPosition1(), substituentExchangeObject2.getLinkagetype1(), substituentExchangeObject2.getPosition1()) ? (this.matchSubstPosition(substituentExchangeObject.getLinkagetype2(), substituentExchangeObject.getPosition2(), substituentExchangeObject2.getLinkagetype2(), substituentExchangeObject2.getPosition2()) ? this.matchSubstPosition(substituentExchangeObject.getLinkagetype3(), substituentExchangeObject.getPosition3(), substituentExchangeObject2.getLinkagetype3(), substituentExchangeObject2.getPosition3()) : this.matchSubstPosition(substituentExchangeObject.getLinkagetype2(), substituentExchangeObject.getPosition2(), substituentExchangeObject2.getLinkagetype3(), substituentExchangeObject2.getPosition3()) && this.matchSubstPosition(substituentExchangeObject.getLinkagetype3(), substituentExchangeObject.getPosition3(), substituentExchangeObject2.getLinkagetype2(), substituentExchangeObject2.getPosition2())) : (this.matchSubstPosition(substituentExchangeObject.getLinkagetype1(), substituentExchangeObject.getPosition1(), substituentExchangeObject2.getLinkagetype2(), substituentExchangeObject2.getPosition2()) ? (this.matchSubstPosition(substituentExchangeObject.getLinkagetype2(), substituentExchangeObject.getPosition2(), substituentExchangeObject2.getLinkagetype1(), substituentExchangeObject2.getPosition1()) ? this.matchSubstPosition(substituentExchangeObject.getLinkagetype3(), substituentExchangeObject.getPosition3(), substituentExchangeObject2.getLinkagetype3(), substituentExchangeObject2.getPosition3()) : this.matchSubstPosition(substituentExchangeObject.getLinkagetype2(), substituentExchangeObject.getPosition2(), substituentExchangeObject2.getLinkagetype3(), substituentExchangeObject2.getPosition3()) && this.matchSubstPosition(substituentExchangeObject.getLinkagetype3(), substituentExchangeObject.getPosition3(), substituentExchangeObject2.getLinkagetype1(), substituentExchangeObject2.getPosition1())) : this.matchSubstPosition(substituentExchangeObject.getLinkagetype1(), substituentExchangeObject.getPosition1(), substituentExchangeObject2.getLinkagetype3(), substituentExchangeObject2.getPosition3()) && (this.matchSubstPosition(substituentExchangeObject.getLinkagetype2(), substituentExchangeObject.getPosition2(), substituentExchangeObject2.getLinkagetype2(), substituentExchangeObject2.getPosition2()) ? this.matchSubstPosition(substituentExchangeObject.getLinkagetype3(), substituentExchangeObject.getPosition3(), substituentExchangeObject2.getLinkagetype1(), substituentExchangeObject2.getPosition1()) : this.matchSubstPosition(substituentExchangeObject.getLinkagetype2(), substituentExchangeObject.getPosition2(), substituentExchangeObject2.getLinkagetype1(), substituentExchangeObject2.getPosition1()) && this.matchSubstPosition(substituentExchangeObject.getLinkagetype3(), substituentExchangeObject.getPosition3(), substituentExchangeObject2.getLinkagetype2(), substituentExchangeObject2.getPosition2()))))) continue;
            return substituentExchangeObject;
        }
        return null;
    }

    private boolean matchSubstPosition(LinkageType linkageType, ArrayList<Integer> arrayList, LinkageType linkageType2, ArrayList<Integer> arrayList2) {
        if (linkageType != linkageType2) {
            return false;
        }
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (Integer n : arrayList) {
            if (this.contained(n, arrayList2)) continue;
            return false;
        }
        return true;
    }

    private boolean contained(Integer n, ArrayList<Integer> arrayList) {
        for (Integer n2 : arrayList) {
            if (!n2.equals(n)) continue;
            return true;
        }
        return false;
    }

    private boolean isTwoInvolved(SubstituentExchangeObject substituentExchangeObject) {
        ArrayList arrayList = substituentExchangeObject.getPosition1();
        if (arrayList.size() != 1) {
            return false;
        }
        for (Integer n : arrayList) {
            if (!n.equals(2)) continue;
            return true;
        }
        return false;
    }
}

