/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GAGPosition
implements Comparable<GAGPosition> {
    static Pattern pattern = Pattern.compile("^([0-9]+)\\#([1-9N])$");
    public int residue_id = 0;
    public char linkage_pos = (char)78;

    public boolean equals(Object obj) {
        if (!(obj instanceof GAGPosition)) {
            return false;
        }
        GAGPosition o = (GAGPosition)obj;
        return this.residue_id == o.residue_id && this.linkage_pos == o.linkage_pos;
    }

    @Override
    public int compareTo(GAGPosition o) {
        if (o == null) {
            return 1;
        }
        if (this.residue_id > o.residue_id) {
            return 1;
        }
        if (this.residue_id == o.residue_id && this.linkage_pos > o.linkage_pos) {
            return 1;
        }
        if (this.residue_id == o.residue_id && this.linkage_pos == o.linkage_pos) {
            return 0;
        }
        return -1;
    }

    public GAGPosition translate(int by) {
        GAGPosition ret = new GAGPosition();
        ret.residue_id = this.residue_id + by;
        ret.linkage_pos = this.linkage_pos;
        return ret;
    }

    static GAGPosition fromString(String str) throws Exception {
        GAGPosition ret = new GAGPosition();
        Matcher m = pattern.matcher(str);
        if (!m.matches()) {
            throw new Exception("Invalid format for position: " + str);
        }
        ret.residue_id = Integer.parseInt(m.group(1));
        ret.linkage_pos = m.group(2).charAt(0);
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.residue_id);
        sb.append('#');
        sb.append(this.linkage_pos);
        return sb.toString();
    }
}

