/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseTypeDictionary;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoExporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeSUDictionary;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeSubstituentDictionary;
import org.glycoinfo.GlycanFormatconverter.util.comparater.GlyCoSubstituentComparator;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;

public class LinearCodeNodeConverter {
    public LinearCodeSUDictionary start(Node _node) throws GlyCoExporterException, ConverterExchangeException, GlycanException {
        IUPACNotationConverter iupacConv = new IUPACNotationConverter();
        iupacConv.makeTrivialName(_node);
        LinearCodeSUDictionary lcDict = LinearCodeSUDictionary.forTrivialName(iupacConv.getThreeLetterCode());
        if (lcDict == null) {
            throw new GlyCoExporterException("This glycan contins unsupported monosaccharide.");
        }
        return lcDict;
    }

    public String makeLCNotation(Node _node) throws GlyCoExporterException, GlycanException, ConverterExchangeException {
        String lcUnit = "";
        LinearCodeSUDictionary lcDict = this.start(_node);
        Monosaccharide mono = (Monosaccharide)_node;
        lcUnit = lcUnit + lcDict.getLinearCode();
        BaseTypeDictionary baseDict = BaseTypeDictionary.forName(mono.getStereos().getLast());
        if (baseDict.getConfiguration().equals("d") && this.convertRingSize(mono.getRingStart(), mono.getRingEnd()) == 'f') {
            lcUnit = lcUnit + "^";
        }
        if (baseDict.getConfiguration().equals("l")) {
            if (this.convertRingSize(mono.getRingStart(), mono.getRingEnd()) == 'p') {
                lcUnit = lcUnit + "'";
            }
            if (this.convertRingSize(mono.getRingStart(), mono.getRingEnd()) == 'f') {
                lcUnit = lcUnit + "~";
            }
        }
        HashMap<String, String> mapSub = this.makeSubstituentNotation(_node, lcDict);
        lcUnit = lcUnit + (mapSub.get("outside").equals("[]") ? "" : mapSub.get("outside"));
        lcUnit = lcUnit + (mono.getAnomer().equals((Object)AnomericStateDescriptor.UNKNOWN_STATE) ? AnomericStateDescriptor.UNKNOWN.getAnomericState() : mono.getAnomer().getAnomericState());
        lcUnit = lcUnit + (mapSub.get(mono.getAnomer().toString()).equals("[]") ? "" : mapSub.get(mono.getAnomer().toString()));
        return lcUnit;
    }

    private char convertRingSize(int _start, int _end) {
        if (_start == -1) {
            return '?';
        }
        if (_start == 1) {
            if (_end == 4) {
                return 'f';
            }
            if (_end == 5) {
                return 'p';
            }
        }
        if (_start == 2) {
            if (_end == 5) {
                return 'f';
            }
            if (_end == 6) {
                return 'p';
            }
        }
        return '?';
    }

    public HashMap<String, String> makeSubstituentNotation(Node _node, LinearCodeSUDictionary _lcDict) throws GlyCoExporterException {
        Substituent sub;
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuilder anomSub = new StringBuilder("[");
        StringBuilder coreSub = new StringBuilder("[");
        Monosaccharide mono = (Monosaccharide)_node;
        ArrayList<Edge> subs = new ArrayList<Edge>();
        for (Edge childEdge : _node.getChildEdges()) {
            sub = (Substituent)childEdge.getSubstituent();
            if (sub == null || sub instanceof GlycanRepeatModification || sub.getSubstituent() instanceof CrossLinkedTemplate) continue;
            subs.add(childEdge);
        }
        Collections.sort(subs, new GlyCoSubstituentComparator());
        for (Edge subEdge : subs) {
            sub = (Substituent)subEdge.getSubstituent();
            LinearCodeSubstituentDictionary lcSubDict = LinearCodeSubstituentDictionary.forIUPACNotation(sub.getNameWithIUPAC());
            if (this.isNativeSubstituent(_lcDict, sub)) continue;
            if (lcSubDict == null) {
                throw new GlyCoExporterException(sub.getNameWithIUPAC() + " could not support !");
            }
            if (mono.getAnomericPosition() == Integer.parseInt(this.extractPosition(sub.getFirstPosition().getParentLinkages()))) {
                anomSub.append(lcSubDict.getLinearCodeNotation());
                continue;
            }
            coreSub.append(this.extractPosition(sub.getFirstPosition().getParentLinkages()));
            coreSub.append(lcSubDict.getLinearCodeNotation());
        }
        anomSub.append("]");
        coreSub.append("]");
        ret.put(mono.getAnomer().toString(), anomSub.toString());
        ret.put("outside", coreSub.toString());
        return ret;
    }

    private String extractPosition(ArrayList<Integer> _positions) {
        StringBuilder ret = new StringBuilder();
        Iterator<Integer> iterPos = _positions.iterator();
        while (iterPos.hasNext()) {
            Integer elm = iterPos.next();
            ret.append(elm == -1 ? "?" : elm);
            if (!iterPos.hasNext()) continue;
            ret.append("/");
        }
        return ret.toString();
    }

    private boolean isNativeSubstituent(LinearCodeSUDictionary _lcDict, Substituent _sub) {
        if (_lcDict.equals((Object)LinearCodeSUDictionary.GALNAC) || _lcDict.equals((Object)LinearCodeSUDictionary.GLCNAC)) {
            if (!this.extractPosition(_sub.getFirstPosition().getParentLinkages()).equals("2")) {
                return false;
            }
            if (_sub.getSubstituent().equals(SubstituentTemplate.N_ACETYL)) {
                return true;
            }
        }
        if (_lcDict.equals((Object)LinearCodeSUDictionary.NEUAC)) {
            if (!this.extractPosition(_sub.getFirstPosition().getParentLinkages()).equals("5")) {
                return false;
            }
            if (_sub.getSubstituent().equals(SubstituentTemplate.N_ACETYL)) {
                return true;
            }
        }
        return false;
    }
}

