/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.providers;

import java.util.List;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;

public class DescriptorUnitLabelProvider
extends ColumnLabelProvider {
    public String getText(Object element) {
        if (element instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)element;
            return descriptor.getUnitLabelFromUri(descriptor.getSelectedMeasurementUnit());
        }
        return null;
    }

    public String getToolTipText(Object obj) {
        Descriptor desc;
        List<MeasurementUnit> units;
        String toolTipText = null;
        if (obj instanceof Descriptor && (units = (desc = (Descriptor)obj).getValidUnits()) != null && !units.isEmpty()) {
            toolTipText = "Valid Units are: \n";
            int i = 0;
            for (MeasurementUnit measurementUnit : units) {
                toolTipText = String.valueOf(toolTipText) + measurementUnit.getLabel();
                if (i < units.size() - 1) {
                    toolTipText = String.valueOf(toolTipText) + ", ";
                }
                if (i > 8) {
                    toolTipText = String.valueOf(toolTipText) + "...";
                    break;
                }
                ++i;
            }
        }
        return toolTipText;
    }
}

