/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreferenceLoader;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationSpecialPeaksFile;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanCustomAnnotationPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.xml.MSGlycanAnnotationCustomAnnotation;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.xml.MSGlycanAnnotationCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.annotation.glycan.property.datamodel.MSGlycanAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.dialog.MassSpecCustomAnnotationDialog;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.MassSpecCustomAnnotationsPreferenceUI;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;

public class MSGlycanAnnotationCustomAnnotationsPreferenceUI
extends MassSpecCustomAnnotationsPreferenceUI {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationCustomAnnotationsPreferenceUI.class);

    public MSGlycanAnnotationCustomAnnotationsPreferenceUI(Composite parent, int style, IPropertyChangeListener listener, boolean bAddSaveAsDefault) {
        super(parent, style, listener, bAddSaveAsDefault);
    }

    public void initLocalAnnotations() {
        this.localAnnotations = new MSGlycanCustomAnnotationPreference();
        MSGlycanAnnotationCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.massSpecEntry, this.localAnnotations);
        this.entryAnnotations = new MSGlycanCustomAnnotationPreference();
        MSGlycanAnnotationCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.massSpecEntry, this.entryAnnotations);
    }

    public static void initAnnotationFromEntry(Entry entry, IMSPreferenceWithCustomAnnotation annotations) {
        MSAnnotationProperty ep;
        MSGlycanAnnotationMetaData metaData;
        List l;
        Property p;
        ((MSGlycanCustomAnnotationPreference)annotations).setCustomAnnotations(new ArrayList<MassSpecCustomAnnotation>());
        ArrayList<String> localAnnotsAdded = new ArrayList<String>();
        if (entry != null && (p = entry.getProperty()) != null && (l = (metaData = (MSGlycanAnnotationMetaData)(ep = ((MSAnnotationEntityProperty)p).getMSAnnotationParentProperty()).getMSAnnotationMetaData()).getCustomAnnotations()) != null && !l.isEmpty()) {
            for (MassSpecCustomAnnotation curAnnot : l) {
                MSGlycanAnnotationCustomAnnotation glycanAnnot = (MSGlycanAnnotationCustomAnnotation)curAnnot;
                annotations.getCustomAnnotations().add((MSGlycanAnnotationCustomAnnotation)((Object)glycanAnnot.clone()));
                localAnnotsAdded.add(curAnnot.getAnnotationName());
            }
        }
    }

    public static IMSPreferenceWithCustomAnnotation loadWorkspacePreferences() {
        try {
            return MSGlycanAnnotationPreferenceLoader.getMSGlycanCustomAnnotationPreference();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the mass spec preferences", (Throwable)ex);
            return null;
        }
    }

    public void initStoredAnnotationsList() {
        int iItemCount;
        MSGlycanAnnotationCustomAnnotation annot;
        int i;
        String sToSelect = "";
        if (this.cmbSelectAnnotation.getItems().length != 0) {
            this.cmbSelectAnnotation.removeAll();
        }
        this.cmbSelectAnnotation.add("");
        if (this.getStoredAnnotations() != null && this.getStoredAnnotations().getCustomAnnotations() != null) {
            i = 0;
            while (i < this.getStoredAnnotations().getCustomAnnotations().size()) {
                annot = (MSGlycanAnnotationCustomAnnotation)((Object)this.getStoredAnnotations().getCustomAnnotations().get(i));
                this.cmbSelectAnnotation.add(annot.getAnnotationName());
                if (this.currentCustomAnnotation != null && annot.getAnnotationName().equals(this.currentCustomAnnotation.getAnnotationName())) {
                    iItemCount = this.cmbSelectAnnotation.getItemCount();
                    sToSelect = this.cmbSelectAnnotation.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        if (this.getContextViewer() != null && this.getLocalAnnotations() != null && this.getPreferenceCustomAnnotations(this.getLocalAnnotations()) != null) {
            i = 0;
            while (i < this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).size()) {
                annot = (MSGlycanAnnotationCustomAnnotation)this.getPreferenceCustomAnnotations(this.getLocalAnnotations()).get(i);
                MassSpecCustomAnnotationDialog.setComboEntryForTempAnnotation((MassSpecCustomAnnotation)annot, (Combo)this.cmbSelectAnnotation, (List)this.entryAnnotations.getCustomAnnotations(), (List)this.storedAnnotations.getCustomAnnotations());
                if (this.currentCustomAnnotation != null && annot.getAnnotationName().equals(this.currentCustomAnnotation.getAnnotationName())) {
                    iItemCount = this.cmbSelectAnnotation.getItemCount();
                    sToSelect = this.cmbSelectAnnotation.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        int iPrevSelInx = this.cmbSelectAnnotation.indexOf(sToSelect);
        this.cmbSelectAnnotation.select(iPrevSelInx);
    }

    public void initStoredAnnotations() {
        this.storedAnnotations = MSGlycanAnnotationCustomAnnotationsPreferenceUI.loadWorkspacePreferences();
    }

    protected List<MassSpecCustomAnnotation> getPreferenceCustomAnnotations(Object preferences) {
        return ((MSGlycanCustomAnnotationPreference)preferences).getCustomAnnotations();
    }

    protected void setPreferenceCustomAnnotations(Object preferences, List<MassSpecCustomAnnotation> annotations) {
        ((MSGlycanCustomAnnotationPreference)preferences).setCustomAnnotations(annotations);
    }

    protected String[] getHeaderColumns() {
        return MSGlycanAnnotationSpecialPeaksFile.HEADER_COLUMN_LABELS;
    }

    protected MassSpecCustomAnnotationPeak getNewMassSpecCustomAnnotationPeak() {
        return new MSGlycanAnnotationCustomAnnotationPeak();
    }

    protected MassSpecCustomAnnotation getNewMassSpecCustomAnnotation() {
        return new MSGlycanAnnotationCustomAnnotation();
    }

    protected void fillRow(GridItem gi, MassSpecCustomAnnotationPeak peak) {
        super.fillRow(gi, peak);
        int j = 3;
        if (peak != null && peak instanceof MSGlycanAnnotationCustomAnnotationPeak) {
            gi.setText(j++, ((MSGlycanAnnotationCustomAnnotationPeak)peak).getPeakSequence() != null ? ((MSGlycanAnnotationCustomAnnotationPeak)peak).getPeakSequence() : "");
        }
    }

    protected void fillPeak(GridItem gi, MassSpecCustomAnnotationPeak peak) {
        if (this.isBlankRow(gi)) {
            return;
        }
        super.fillPeak(gi, peak);
        int j = 3;
        ((MSGlycanAnnotationCustomAnnotationPeak)peak).setPeakSequence(gi.getText(j));
    }

    protected int getDefaultColumnWidth(int _iColNum) {
        if (_iColNum < 3) {
            return super.getDefaultColumnWidth(_iColNum);
        }
        if (_iColNum == 3) {
            return 200;
        }
        return 50;
    }

    protected void readXMLFile(String sPath) {
        this.currentCustomAnnotation = MSGlycanAnnotationSpecialPeaksFile.readXMLFile(sPath);
    }

    protected void readTxtFile(String sPath) {
        MSGlycanAnnotationSpecialPeaksFile.readFile(this.currentCustomAnnotation, sPath);
    }

    protected void writeXMLFile(String sPath) {
        MSGlycanAnnotationSpecialPeaksFile.writeXMLFile(this.currentCustomAnnotation, sPath);
    }

    protected void showInvalidImportFileMessage() {
        ErrorUtils.createErrorMessageBox((Shell)this.getShell(), (String)"Not a valid MS Glycan Custom Annotation XML file.");
    }
}

