/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.process;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarExporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.grits.toolbox.tools.databasebot.dialog.process.ProgressDialogThread;
import org.grits.toolbox.tools.databasebot.excel.ReportGenerator;
import org.grits.toolbox.tools.databasebot.om.DatabaseBotSettings;
import org.grits.toolbox.tools.databasebot.om.GlycanInformation;
import org.grits.toolbox.tools.databasebot.process.CancelProcessException;
import org.grits.toolbox.tools.databasebot.utils.FileUtils;
import org.grits.toolbox.tools.databasebot.utils.GlycoVisitorComposition;
import org.grits.toolbox.tools.databasebot.utils.GlycoVisitorTopology;
import org.grits.toolbox.util.structure.glycan.database.GlycanDatabase;
import org.grits.toolbox.util.structure.glycan.database.GlycanStructure;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterException;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterOperator;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;

public class DatabaseGenerator
extends ProgressDialogThread {
    private static final Logger logger = Logger.getLogger(DatabaseGenerator.class);
    private DatabaseBotSettings m_settings = null;
    private GlycanDatabase m_database = null;
    private Integer m_idCounter = 0;
    private List<GlycanInformation> m_glycans = new ArrayList<GlycanInformation>();
    private MassOptions m_massOptions = null;
    private HashMap<String, String> m_hashGlycoCT = new HashMap();

    public DatabaseGenerator() {
        this.m_massOptions = new MassOptions();
        this.m_massOptions.setDerivatization("Und");
        this.m_massOptions.setIsotope("MONO");
        this.m_massOptions.setReducingEndType(ResidueDictionary.findResidueType((String)"freeEnd"));
        this.m_massOptions.ION_CLOUD = new IonCloud();
        this.m_massOptions.NEUTRAL_EXCHANGES = new IonCloud();
    }

    public DatabaseBotSettings getSettings() {
        return this.m_settings;
    }

    public void setSettings(DatabaseBotSettings a_settings) {
        this.m_settings = a_settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean threadStart() throws Exception {
        this.m_progressReporter.setProcessMessageLabel("Task 1 of 7: Initialize database ...");
        try {
            this.initializeDatabase();
        }
        catch (JAXBException e) {
            this.m_progressReporter.setDescriptionText("There was an error opening " + this.m_settings.getExtendDatabaseFile() + "\n" + e.getMessage());
            logger.error((Object)("Error opening database file: " + this.m_settings.getExtendDatabaseFile()), (Throwable)e);
            return false;
        }
        catch (CancelProcessException cancelProcessException) {
            return false;
        }
        catch (Exception e) {
            this.m_progressReporter.setDescriptionText("Error loading structures from " + this.m_settings.getExtendDatabaseFile() + "\n" + e.getMessage());
            logger.error((Object)("Error loading structures from database file: " + this.m_settings.getExtendDatabaseFile()), (Throwable)e);
            return false;
        }
        this.m_progressReporter.setProcessMessageLabel("Task 2 of 7: Add new structures");
        try {
            this.addNewStructures();
        }
        catch (CancelProcessException cancelProcessException) {
            return false;
        }
        this.m_progressReporter.setProcessMessageLabel("Task 3 of 7: Filter structures");
        try {
            if (this.m_settings.getFilterSetting() != null) {
                Filter t_filter = this.m_settings.getFilterSetting().getFilter();
                this.m_progressReporter.setMax(this.m_glycans.size());
                Integer t_counter = 0;
                String t_messagePart = " of " + Integer.toString(this.m_glycans.size()) + " glycans";
                for (GlycanInformation t_glycan : this.m_glycans) {
                    t_counter = t_counter + 1;
                    if (this.m_canceled.booleanValue()) {
                        return false;
                    }
                    this.m_progressReporter.updateProgresBar(String.valueOf(t_counter.toString()) + t_messagePart);
                    if (GlycanFilterOperator.evaluate((Sugar)t_glycan.getSugar(), (Filter)t_filter)) {
                        t_glycan.setPassFilter(Boolean.TRUE);
                        continue;
                    }
                    t_glycan.setPassFilter(Boolean.FALSE);
                }
            }
        }
        catch (GlycanFilterException e) {
            this.m_progressReporter.setDescriptionText("Error when filtering structures: " + e.getMessage());
            logger.error((Object)"Error when filtering structures", (Throwable)e);
            return false;
        }
        List<GlycanInformation> t_listToProcess = this.m_glycans;
        this.m_progressReporter.setProcessMessageLabel("Task 4 of 7: Topology database generation");
        try {
            if (this.m_settings.getTopologyDatabase().booleanValue()) {
                this.m_progressReporter.setMax(this.m_glycans.size());
                t_listToProcess = this.generateTopologyStructures();
            }
            if (this.m_canceled.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            this.m_progressReporter.setDescriptionText("Error when generating topology database: " + e.getMessage());
            logger.error((Object)"Error when generating topology database", (Throwable)e);
            return false;
        }
        this.m_progressReporter.setProcessMessageLabel("Task 5 of 7: Generating database IDs");
        this.m_progressReporter.setMax(100);
        this.generateIds(t_listToProcess);
        if (this.m_canceled.booleanValue()) {
            return false;
        }
        this.m_progressReporter.setProcessMessageLabel("Task 6 of 7: Save database file");
        this.m_progressReporter.setMax(100);
        this.addStructuresToDatabase(t_listToProcess);
        try {
            this.saveDatabase();
            if (this.m_canceled.booleanValue()) {
                try {
                    Files.delete(Paths.get(this.m_settings.getFilename(), new String[0]));
                    return false;
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to delete database file: " + this.m_settings.getFilename()), (Throwable)e);
                }
                return false;
            }
        }
        catch (JAXBException e) {
            this.m_progressReporter.setDescriptionText("Error when writting the new database: " + e.getMessage());
            logger.error((Object)"Error when writting the new database", (Throwable)e);
            return false;
        }
        this.m_progressReporter.setProcessMessageLabel("Task 7 of 7: Generating report file");
        this.m_progressReporter.setMax(100);
        try {
            if (this.m_settings.getReportFile() != null) {
                this.generateReport(t_listToProcess);
            }
            if (this.m_canceled == false) return true;
            try {
                Files.delete(Paths.get(this.m_settings.getFilename(), new String[0]));
            }
            catch (IOException e) {
                logger.error((Object)("Unable to delete database file: " + this.m_settings.getFilename()), (Throwable)e);
            }
            try {
                Files.delete(Paths.get(this.m_settings.getReportFile(), new String[0]));
                return false;
            }
            catch (IOException e) {
                logger.error((Object)("Unable to delete database file: " + this.m_settings.getReportFile()), (Throwable)e);
            }
            return false;
        }
        catch (Exception e) {
            this.m_progressReporter.setDescriptionText("Error when generating the Excel report: " + e.getMessage() + "\nBut the database file was created anyway!");
            logger.error((Object)"Error when generating the Excel report", (Throwable)e);
            return false;
        }
    }

    private void addStructuresToDatabase(List<GlycanInformation> a_listToProcess) {
        ArrayList<GlycanStructure> t_glycans = new ArrayList<GlycanStructure>();
        for (GlycanInformation t_glycanInformation : a_listToProcess) {
            if (!t_glycanInformation.getPassFilter().booleanValue()) continue;
            GlycanStructure t_structure = new GlycanStructure();
            t_structure.setId(t_glycanInformation.getId());
            t_structure.setGWBSequence(t_glycanInformation.getGwb());
            t_structure.setGlytoucanid(t_glycanInformation.getGlytoucanId());
            t_glycans.add(t_structure);
        }
        this.m_database.setStructures(t_glycans);
        this.m_database.setStructureCount(Integer.valueOf(t_glycans.size()));
    }

    private void generateIds(List<GlycanInformation> a_listToProcess) {
        if (this.m_settings.getOverwriteIds().booleanValue()) {
            HashMap<String, Boolean> t_usedIDs = new HashMap<String, Boolean>();
            for (GlycanInformation t_glycanStructure : a_listToProcess) {
                if (!t_glycanStructure.getPassFilter().booleanValue()) continue;
                String t_id = this.nextId(t_usedIDs);
                t_glycanStructure.setId(t_id);
                t_usedIDs.put(t_id, Boolean.FALSE);
            }
        } else {
            HashMap<String, Boolean> t_usedIDs = new HashMap<String, Boolean>();
            for (GlycanInformation t_glycanStructure : a_listToProcess) {
                if (!t_glycanStructure.getPassFilter().booleanValue()) continue;
                t_usedIDs.put(t_glycanStructure.getId(), Boolean.TRUE);
            }
            for (GlycanInformation t_glycanStructure : a_listToProcess) {
                if (!t_glycanStructure.getPassFilter().booleanValue() || t_glycanStructure.getId() != null) continue;
                String t_id = this.nextId(t_usedIDs);
                t_glycanStructure.setId(t_id);
                t_usedIDs.put(t_id, Boolean.FALSE);
            }
        }
    }

    private void saveDatabase() throws JAXBException {
        JAXBContext t_context = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
        Marshaller t_marshaller = t_context.createMarshaller();
        t_context = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
        t_marshaller = t_context.createMarshaller();
        t_marshaller.setProperty("jaxb.formatted.output", (Object)true);
        t_marshaller.marshal((Object)this.m_database, new File(this.m_settings.getFilename()));
    }

    private void addNewStructures() throws CancelProcessException {
        if (this.m_settings.getGwsFiles().size() != 0) {
            this.m_progressReporter.setMax(this.m_settings.getGwsFiles().size());
            for (String t_fileName : this.m_settings.getGwsFiles()) {
                File t_file = new File(t_fileName);
                this.m_progressReporter.updateProgresBar("Loading: " + t_file.getName());
                try {
                    String[] t_gwsList;
                    String t_gwsMulti = FileUtils.readFile(t_fileName);
                    String[] stringArray = t_gwsList = t_gwsMulti.split(";");
                    int n = t_gwsList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t_gws = stringArray[n2];
                        if (this.m_canceled.booleanValue()) {
                            throw new CancelProcessException();
                        }
                        Glycan t_glycan = Glycan.fromString((String)t_gws);
                        if (t_glycan == null) {
                            this.m_progressReporter.setDescriptionText("Warning: Unable to load sequence from GWB file, the sequence will be ignored: " + t_gws);
                            logger.info((Object)("Invalid GWS sequence in file (" + t_fileName + "): " + t_gws));
                        } else {
                            t_glycan.computeMass();
                            if (this.testGlycoCT(t_glycan)) {
                                GlycanStructure t_structure = new GlycanStructure();
                                t_structure.setGWBSequence(t_glycan.toString());
                                GlycanInformation t_info = this.createGlycanGWS(t_glycan.toString());
                                if (this.m_hashGlycoCT.get(t_info.getGlycoCT()) == null) {
                                    this.m_hashGlycoCT.put(t_info.getGlycoCT(), "New Structure");
                                    this.m_glycans.add(t_info);
                                } else {
                                    logger.warn((Object)("Trying to add duplicate GWS sequence to database: " + t_info.getGwb()));
                                    this.m_progressReporter.setDescriptionText("Warning: Trying to add duplicated GWS sequence to database " + t_info.getGwb());
                                }
                            } else {
                                this.m_progressReporter.setDescriptionText("Warning: Unable to process sequence from GWB file, the sequence will be ignored: " + t_gws);
                                logger.warn((Object)("Unable to process GWS sequence and generate GlycoCT information: " + t_gws));
                            }
                        }
                        ++n2;
                    }
                }
                catch (CancelProcessException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.m_progressReporter.setDescriptionText("Warning: Error when loading GWB file: " + t_fileName + " - this file will be ignored\n\t" + e.getMessage());
                    logger.debug((Object)"Problem loading GWS file", (Throwable)e);
                }
            }
        }
    }

    private String nextId(HashMap<String, Boolean> a_usedIDs) {
        String t_newID = null;
        boolean t_foundId = false;
        while (!t_foundId) {
            this.m_idCounter = this.m_idCounter + 1;
            t_newID = String.valueOf(this.m_settings.getIdPrefix()) + this.m_idCounter.toString() + this.m_settings.getIdPostfix();
            if (a_usedIDs.get(t_newID) != null) continue;
            t_foundId = true;
        }
        return t_newID;
    }

    private boolean testGlycoCT(Glycan a_glycan) {
        return true;
    }

    private void initializeDatabase() throws JAXBException, SugarImporterException, GlycoVisitorException, CancelProcessException {
        if (this.m_settings.getExtendDatabaseFile() != null) {
            JAXBContext t_jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GlycanDatabase.class});
            Unmarshaller t_jaxbUnmarshaller = t_jaxbContext.createUnmarshaller();
            File t_file = new File(this.m_settings.getExtendDatabaseFile());
            GlycanDatabase t_database = (GlycanDatabase)t_jaxbUnmarshaller.unmarshal(t_file);
            this.m_progressReporter.setMax(t_database.getStructures().size());
            Integer t_counter = 0;
            String t_messagePart = " of " + Integer.toString(t_database.getStructures().size()) + " glycans";
            for (GlycanStructure t_glycan : t_database.getStructures()) {
                t_counter = t_counter + 1;
                this.m_progressReporter.updateProgresBar(String.valueOf(t_counter.toString()) + t_messagePart);
                if (this.m_canceled.booleanValue()) {
                    throw new CancelProcessException();
                }
                GlycanInformation t_info = this.createGlycanGWS(t_glycan.getId(), t_glycan.getGWBSequence());
                t_info.setGlytoucanId(t_glycan.getGlytoucanid());
                if (this.m_hashGlycoCT.get(t_info.getGlycoCT()) == null) {
                    this.m_hashGlycoCT.put(t_info.getGlycoCT(), t_info.getId());
                    this.m_glycans.add(t_info);
                    continue;
                }
                logger.warn((Object)("There was a duplicated GlycoCT structure in database " + this.m_hashGlycoCT.get(t_info.getGlycoCT()) + " and " + t_info.getId()));
                this.m_progressReporter.setDescriptionText("Warning: There was a duplicated GlycoCT structure in database " + this.m_hashGlycoCT.get(t_info.getGlycoCT()) + " and " + t_info.getId() + ". The latter will be ignored.");
            }
        }
        this.m_database = new GlycanDatabase();
        this.m_database.setName(this.m_settings.getName());
        this.m_database.setDescription(this.m_settings.getDescription());
        this.m_database.setVersion(this.m_settings.getVersion());
    }

    private GlycanInformation createGlycanGWS(String a_gwbSequence) throws SugarImporterException, GlycoVisitorException {
        return this.createGlycanGWS(null, a_gwbSequence);
    }

    private List<GlycanInformation> generateTopologyStructures() throws SugarImporterException, GlycoVisitorException {
        HashMap<String, GlycanInformation> t_topologies = new HashMap<String, GlycanInformation>();
        ArrayList<GlycanInformation> t_topologyList = new ArrayList<GlycanInformation>();
        Integer t_counter = 0;
        String t_messagePart = " of " + Integer.toString(this.m_glycans.size()) + " sequences";
        for (GlycanInformation t_glycanInformation : this.m_glycans) {
            t_counter = t_counter + 1;
            this.m_progressReporter.updateProgresBar(String.valueOf(t_counter.toString()) + t_messagePart);
            Sugar t_sugar = this.cloneSugar(t_glycanInformation.getSugar());
            GlycoVisitorTopology t_visitor = new GlycoVisitorTopology();
            t_visitor.start(t_sugar);
            SugarExporterGlycoCTCondensed t_exporter = new SugarExporterGlycoCTCondensed();
            t_exporter.start(t_sugar);
            String t_newSequence = t_exporter.getHashCode();
            GlycanInformation t_glycanInfoFromHash = (GlycanInformation)t_topologies.get(t_newSequence);
            if (t_glycanInfoFromHash == null) {
                GlycanInformation t_newGlycanInfo = this.createGlycanInformation(t_newSequence);
                t_newGlycanInfo.setPassFilter(t_glycanInformation.getPassFilter());
                t_newGlycanInfo.addTopoglogyOrigin(t_glycanInformation);
                t_topologyList.add(t_newGlycanInfo);
                t_topologies.put(t_newSequence, t_newGlycanInfo);
                continue;
            }
            t_glycanInfoFromHash.addTopoglogyOrigin(t_glycanInformation);
            if (t_glycanInfoFromHash.getPassFilter().booleanValue()) continue;
            t_glycanInfoFromHash.setPassFilter(t_glycanInformation.getPassFilter());
        }
        return t_topologyList;
    }

    private Sugar cloneSugar(Sugar a_sugar) throws SugarImporterException, GlycoVisitorException {
        SugarExporterGlycoCTCondensed t_exporter = new SugarExporterGlycoCTCondensed();
        t_exporter.start(a_sugar);
        String t_sequence = t_exporter.getHashCode();
        SugarImporterGlycoCTCondensed t_importer = new SugarImporterGlycoCTCondensed();
        Sugar t_sugar = t_importer.parse(t_sequence);
        return t_sugar;
    }

    private GlycanInformation createGlycanInformation(String a_glycoCT) throws SugarImporterException, GlycoVisitorException {
        SugarImporterGlycoCTCondensed t_importer = new SugarImporterGlycoCTCondensed();
        Sugar t_sugar = t_importer.parse(a_glycoCT);
        Glycan t_glycan = Glycan.fromGlycoCTCondensed((String)a_glycoCT);
        return this.createGlycanInformation(t_sugar, t_glycan);
    }

    private GlycanInformation createGlycanInformation(Sugar a_sugar, Glycan a_glycan) throws GlycoVisitorException {
        SugarExporterGlycoCTCondensed t_exporter = new SugarExporterGlycoCTCondensed();
        t_exporter.start(a_sugar);
        String t_glycoCT = t_exporter.getHashCode();
        double t_mass = this.getMass(a_glycan, "Und");
        double t_massPme = this.getMass(a_glycan, "perMe");
        GlycoVisitorComposition t_visitor = new GlycoVisitorComposition();
        t_visitor.start(a_sugar);
        HashMap<String, Integer> t_composition = t_visitor.getComposition();
        String t_compositionName = this.getCompositionString(t_composition);
        GlycanInformation t_info = new GlycanInformation();
        t_info.setComposition(t_composition);
        t_info.setMass(t_mass);
        t_info.setMassPme(t_massPme);
        t_info.setCompositionName(t_compositionName);
        t_info.setGwb(a_glycan.toString());
        t_info.setGlycoCT(t_glycoCT);
        t_info.setSugar(a_sugar);
        t_info.setGlycan(a_glycan);
        return t_info;
    }

    private GlycanInformation createGlycanGWS(String a_id, String a_gwbSequence) throws SugarImporterException, GlycoVisitorException {
        Glycan t_glycan = Glycan.fromString((String)a_gwbSequence);
        String t_glycoCT = t_glycan.toGlycoCTCondensed();
        SugarImporterGlycoCTCondensed t_importer = new SugarImporterGlycoCTCondensed();
        Sugar t_sugar = t_importer.parse(t_glycoCT);
        GlycanInformation t_info = this.createGlycanInformation(t_sugar, t_glycan);
        t_info.setId(a_id);
        return t_info;
    }

    private double getMass(Glycan a_glycan, String a_derivatization) {
        this.m_massOptions.setDerivatization(a_derivatization);
        a_glycan.setMassOptions(this.m_massOptions);
        return a_glycan.computeMass();
    }

    private String getCompositionString(HashMap<String, Integer> a_composition) {
        String t_result = "";
        ArrayList<String> t_list = new ArrayList<String>();
        for (String t_string : a_composition.keySet()) {
            t_list.add(t_string);
        }
        Collections.sort(t_list);
        for (String t_string : t_list) {
            t_result = String.valueOf(t_result) + this.formatComposition(t_string) + a_composition.get(t_string).toString() + " ";
        }
        return t_result;
    }

    private String formatComposition(String a_string) {
        String t_string = a_string;
        if (a_string.equals("dnonA-ulop-n-acetyl")) {
            t_string = "NeuAc";
        } else if (a_string.equals("hex-n-acetyl")) {
            t_string = "HexNAc";
        } else if (a_string.equals("dnonA-ulop")) {
            t_string = "KDN";
        } else if (a_string.equals("dnonA-ulop-n-glycolyl")) {
            t_string = "NeuGc";
        } else if (a_string.equals("dhex")) {
            t_string = "dHex";
        } else if (a_string.equals("hex")) {
            t_string = "Hex";
        }
        return t_string;
    }

    private void generateReport(List<GlycanInformation> a_glycans) throws SugarImporterException, GlycoVisitorException, IOException {
        ReportGenerator t_excel = new ReportGenerator();
        t_excel.setImageScalingFactor(this.m_settings.getImageScalingFactor());
        if (this.m_settings.getTopologyDatabase().booleanValue()) {
            t_excel.writeTopology(this.m_settings.getReportFile(), a_glycans, this.m_glycans);
        } else {
            t_excel.write(this.m_settings.getReportFile(), a_glycans);
        }
    }
}

