/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.canvas;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.SpinnerCombo;

public class Pager {
    private Composite m_compositePager;
    private Label m_lblPageDescription;
    private Spinner m_spnNumElementsPerPage;
    private SpinnerCombo m_spnCmbCurrentPage;
    private Label m_lblTotalPages;
    private int m_nTotalElements = 1;
    private int m_nElementsPerPage = 20;
    private int m_iCurrentPage = 1;
    private List<SelectionListener> m_lListeners = new ArrayList<SelectionListener>();

    public void setNumberOfTotalElements(int value) {
        this.m_nTotalElements = value;
    }

    public int getNumberOfTotalElements() {
        return this.m_nTotalElements;
    }

    public void setNumberOfElementsPerPage(int value) {
        this.m_nElementsPerPage = value;
    }

    public int getNumberOfElementsPerPage() {
        return this.m_nElementsPerPage;
    }

    public void setCurrentPageNumber(int value) {
        this.m_iCurrentPage = value;
    }

    public int getCurrentPageNumber() {
        return this.m_iCurrentPage;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.m_lListeners.contains(listener)) {
            return;
        }
        this.m_lListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (!this.m_lListeners.contains(listener)) {
            return;
        }
        this.m_lListeners.remove(listener);
    }

    protected void createControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        RowLayout layout = new RowLayout();
        layout.marginWidth = 10;
        layout.center = true;
        layout.fill = true;
        layout.wrap = true;
        layout.spacing = 0;
        container.setLayout((Layout)layout);
        Label lbl = new Label(container, 0x1000000);
        lbl.setText("1-1 of 1");
        this.m_lblPageDescription = lbl;
        lbl = new Label(container, 0x1000000);
        lbl.setLayoutData((Object)new RowData(50, -1));
        lbl = new Label(container, 0x1000000);
        lbl.setText("Pages show at most");
        Spinner spn = new Spinner(container, 8);
        spn.setValues(this.m_nElementsPerPage, 10, 50, 0, 1, 10);
        spn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Pager.this.m_nElementsPerPage = ((Spinner)e.widget).getSelection();
            }
        });
        for (SelectionListener l : this.m_lListeners) {
            spn.addSelectionListener(l);
        }
        this.m_spnNumElementsPerPage = spn;
        lbl = new Label(container, 0);
        lbl.setLayoutData((Object)new RowData(10, -1));
        lbl = new Label(container, 0x1000000);
        lbl.setText("Page #");
        final SpinnerCombo spnCmb = new SpinnerCombo(container, 8);
        spnCmb.setValues(this.m_iCurrentPage, 1, 1);
        spnCmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Pager.this.m_iCurrentPage = spnCmb.getSelection();
            }
        });
        for (SelectionListener l : this.m_lListeners) {
            spnCmb.addSelectionListener(l);
        }
        this.m_spnCmbCurrentPage = spnCmb;
        lbl = new Label(container, 0x1000000);
        lbl.setText("/ 1");
        this.m_lblTotalPages = lbl;
        this.m_compositePager = container;
        parent.layout();
    }

    public void updatePager(Composite parent) {
        if (this.m_compositePager == null || this.m_compositePager.isDisposed()) {
            this.createControls(parent);
        } else {
            parent = this.m_compositePager.getParent();
            this.m_spnNumElementsPerPage.setSelection(this.m_nElementsPerPage);
            this.m_spnCmbCurrentPage.setSelection(this.m_iCurrentPage);
        }
        this.m_lblPageDescription.setText(this.toString());
        int nPages = 1;
        if (this.m_nTotalElements > this.m_nElementsPerPage) {
            nPages = this.m_nTotalElements / this.m_nElementsPerPage;
            if (this.m_nTotalElements % this.m_nElementsPerPage != 0) {
                ++nPages;
            }
        }
        this.m_spnCmbCurrentPage.setMaximum(nPages);
        this.m_lblTotalPages.setText("/ " + nPages);
        this.m_compositePager.pack();
        parent.layout();
    }

    public boolean isDisposed() {
        return this.m_compositePager == null || this.m_compositePager.isDisposed();
    }

    public void dispose() {
        this.m_compositePager.dispose();
        this.m_iCurrentPage = 1;
        this.m_nTotalElements = 1;
    }

    public String toString() {
        if (this.m_nTotalElements == 0) {
            return "";
        }
        int iBegin = (this.m_iCurrentPage - 1) * this.m_nElementsPerPage + 1;
        int iEnd = Math.min(this.m_iCurrentPage * this.m_nElementsPerPage, this.m_nTotalElements);
        return String.valueOf(iBegin) + "-" + iEnd + " of " + this.m_nTotalElements;
    }
}

