/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.grits.toolbox.core.Activator;

public class CheckboxTableViewer
extends TableViewer
implements ICheckable {
    public static final Image CHECKBOX_TICKED = Activator.imageDescriptorFromPlugin("org.grits.toolbox.core", "icons" + File.separator + "checked-yes.png").createImage();
    public static final Image CHECKBOX_EMPTY = Activator.imageDescriptorFromPlugin("org.grits.toolbox.core", "icons" + File.separator + "checked-no.png").createImage();
    public static final Image RADIO_SELECTED = Activator.imageDescriptorFromPlugin("org.grits.toolbox.core", "icons" + File.separator + "radio-selected.png").createImage();
    public static final Image RADIO_UNSELECTED = Activator.imageDescriptorFromPlugin("org.grits.toolbox.core", "icons" + File.separator + "radio-unselected.png").createImage();
    private Image checkedIcon = CHECKBOX_TICKED;
    private Image uncheckedIcon = CHECKBOX_EMPTY;
    private ICheckStateListener checkListener = null;
    private ICheckStateProvider checkStateProvider = null;
    private TableViewerColumn columnViewer0 = null;
    private CheckboxCellEditor checkboxCellEditor = null;
    private String title = "Select";
    private int columnWidth = 70;
    private boolean editable = true;
    private boolean singleSelection = false;
    private HashMap<Object, Boolean> checkedMap = new HashMap();

    public CheckboxTableViewer(Table table) {
        super(table);
        this.setFirstColumn();
    }

    public CheckboxTableViewer(Table table, boolean singleSelection) {
        super(table);
        this.singleSelection = singleSelection;
        this.setFirstColumn();
    }

    public CheckboxTableViewer(Table table, String title) {
        this(table);
        this.setCheckboxTitle(title);
    }

    public CheckboxTableViewer(Table table, String title, boolean singleSelection) {
        this(table, singleSelection);
        this.setCheckboxTitle(title);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setCheckboxTitle(String title) {
        String string = this.title = title == null ? this.title : title;
        if (this.columnViewer0 != null) {
            this.columnViewer0.getColumn().setText(this.title);
        }
    }

    public String getCheckboxTitle() {
        return this.title;
    }

    public void setFirstColumnWidth(int columnWidth) {
        int n = this.columnWidth = columnWidth > 0 ? columnWidth : this.columnWidth;
        if (this.columnViewer0 != null) {
            this.columnViewer0.getColumn().setWidth(this.columnWidth);
        }
    }

    public int getFirstColumnWidth() {
        return this.columnWidth;
    }

    private void setFirstColumn() {
        this.columnViewer0 = new TableViewerColumn((TableViewer)this, 4, 0);
        this.columnViewer0.getColumn().setText(this.title);
        this.columnViewer0.getColumn().setWidth(this.columnWidth);
        if (this.singleSelection) {
            this.checkedIcon = RADIO_SELECTED;
            this.uncheckedIcon = RADIO_UNSELECTED;
        } else {
            this.checkedIcon = CHECKBOX_TICKED;
            this.uncheckedIcon = CHECKBOX_EMPTY;
        }
        this.columnViewer0.setEditingSupport(new EditingSupport((ColumnViewer)this){

            protected void setValue(Object element, Object value) {
                boolean checked = (Boolean)value;
                CheckboxTableViewer.this.setChecked(element, checked);
                if (CheckboxTableViewer.this.checkListener != null) {
                    CheckboxTableViewer.this.checkListener.checkStateChanged(new CheckStateChangedEvent((ICheckable)CheckboxTableViewer.this, element, checked));
                }
            }

            protected Object getValue(Object element) {
                if (this.getCellEditor(element) != null) {
                    return CheckboxTableViewer.this.getChecked(element);
                }
                return false;
            }

            protected CellEditor getCellEditor(Object element) {
                if (CheckboxTableViewer.this.checkboxCellEditor == null) {
                    CheckboxTableViewer.this.checkboxCellEditor = new CheckboxCellEditor((Composite)CheckboxTableViewer.this.getTable());
                }
                return CheckboxTableViewer.this.checkboxCellEditor;
            }

            protected boolean canEdit(Object element) {
                if (this.getCellEditor(element) != null) {
                    return CheckboxTableViewer.this.singleSelection ? CheckboxTableViewer.this.editable && !CheckboxTableViewer.this.getChecked(element) : CheckboxTableViewer.this.editable;
                }
                return false;
            }
        });
    }

    public void refresh() {
        super.refresh();
        TableItem[] items = this.getTable().getItems();
        HashMap<TableItem, Boolean> newCheckedMap = new HashMap<TableItem, Boolean>();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object data = item.getData();
            if (data != null) {
                if (this.checkStateProvider == null) {
                    if (this.checkedMap.containsKey(item)) {
                        boolean checked = this.checkedMap.get(item);
                        newCheckedMap.put(item, checked);
                    } else {
                        newCheckedMap.put(item, false);
                    }
                } else {
                    newCheckedMap.put(item, this.checkStateProvider.isChecked(data));
                }
                this.getViewerRowFromItem((Widget)item).setImage(0, this.getImage((Boolean)newCheckedMap.get(item)));
            }
            ++i;
        }
        this.checkedMap = newCheckedMap;
    }

    public Object[] getCheckedElements() {
        TableItem[] items = this.getTable().getItems();
        if (items.length != this.checkedMap.size()) {
            this.refresh();
        }
        ArrayList<Object> checkedElements = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object data = item.getData();
            if (data != null) {
                if (this.checkStateProvider == null) {
                    if (this.checkedMap.containsKey(item) && this.checkedMap.get(item).booleanValue()) {
                        checkedElements.add(data);
                    }
                } else if (this.checkStateProvider.isChecked(data)) {
                    checkedElements.add(data);
                }
            }
            ++i;
        }
        return checkedElements.toArray();
    }

    public void setCheckedElements(Object[] elements) {
        this.assertElementsNotNull(elements);
        List<Object> checkedList = Arrays.asList(elements);
        TableItem[] items = this.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object element = item.getData();
            if (element != null) {
                boolean checked = checkedList.contains(element);
                this.checkedMap.put(item, checked);
                this.getViewerRowFromItem((Widget)item).setImage(0, this.getImage(checked));
            }
            ++i;
        }
    }

    public boolean getChecked(Object element) {
        if (this.checkStateProvider == null) {
            Widget widget = this.findItem(element);
            if (widget instanceof TableItem) {
                TableItem item = (TableItem)widget;
                if (this.checkedMap.containsKey(item)) {
                    return this.checkedMap.get(item);
                }
                this.checkedMap.put(item, false);
            }
            return false;
        }
        return this.checkStateProvider.isChecked(element);
    }

    public boolean setChecked(Object element, boolean state) {
        if (this.getTable().getItemCount() != this.checkedMap.size()) {
            this.refresh();
        }
        Assert.isNotNull((Object)element);
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            this.checkedMap.put(item, state);
            this.getViewerRowFromItem((Widget)item).setImage(0, this.getImage(state));
            if (this.singleSelection && state) {
                for (Object eachElement : this.checkedMap.keySet()) {
                    if (!this.checkedMap.get(eachElement).booleanValue() || eachElement.equals(item)) continue;
                    TableItem thisItem = (TableItem)eachElement;
                    this.checkedMap.put(thisItem, false);
                    this.getViewerRowFromItem((Widget)thisItem).setImage(0, this.getImage(false));
                }
            }
            return true;
        }
        return false;
    }

    private Image getImage(boolean state) {
        return state ? this.checkedIcon : this.uncheckedIcon;
    }

    public void setCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.checkListener = iCheckStateListener;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkListener = listener;
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        if (this.checkListener.equals(listener)) {
            this.checkListener = null;
        }
    }

    public void setCheckStateProvider(ICheckStateProvider iCheckStateProvider) {
        this.checkStateProvider = iCheckStateProvider;
    }
}

