/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.actions;

import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;

public class SaveGeneListDialog
extends FormDialog {
    private List<GeneList> existing;
    Text nameText;
    Text descriptionText;
    private ControlDecoration dec;
    private Label errorLabel;
    private String name;
    private String description;
    private String organism;
    private Text organismText;
    private ControlDecoration dec2;

    public SaveGeneListDialog(Shell shell) {
        super(shell);
    }

    public SaveGeneListDialog(Shell shell, List<GeneList> existingLists) {
        super(shell);
        this.existing = existingLists;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText("Please give a name, organism and description (optional)");
        ScrolledForm scrolledForm = mform.getForm();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        FormToolkit toolkit = mform.getToolkit();
        Label nameLabel = toolkit.createLabel(scrolledForm.getBody(), "Name *", 0);
        TableWrapData twd_nameLabel = new TableWrapData(8, 16, 1, 1);
        twd_nameLabel.align = 2;
        nameLabel.setLayoutData((Object)twd_nameLabel);
        this.nameText = toolkit.createText(scrolledForm.getBody(), "", 0);
        this.nameText.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        Label organismLabel = toolkit.createLabel(scrolledForm.getBody(), "Organism *", 0);
        TableWrapData twd = new TableWrapData(8, 16, 1, 1);
        twd.align = 2;
        organismLabel.setLayoutData((Object)twd);
        this.organismText = toolkit.createText(scrolledForm.getBody(), "", 0);
        this.organismText.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        if (this.organism != null) {
            this.organismText.setText(this.organism);
        }
        this.dec = new ControlDecoration((Control)this.nameText, 16512);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        this.dec.setImage(image);
        this.dec.setDescriptionText("Name cannot be left empty");
        this.dec.hide();
        this.dec2 = new ControlDecoration((Control)this.organismText, 16512);
        this.dec2.setImage(image);
        this.dec2.setDescriptionText("Organism cannot be left empty");
        this.dec2.hide();
        Label lblDescription = toolkit.createLabel(scrolledForm.getBody(), "Description", 0);
        lblDescription.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.descriptionText = toolkit.createText(scrolledForm.getBody(), "", 578);
        this.descriptionText.setTextLimit(10000);
        TableWrapData twd_description = new TableWrapData(256, 16, 1, 1);
        twd_description.heightHint = 60;
        this.descriptionText.setLayoutData((Object)twd_description);
        this.descriptionText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    ((Text)e.widget).selectAll();
                }
            }
        });
        this.errorLabel = toolkit.createLabel(scrolledForm.getBody(), "", 0);
        this.errorLabel.setLayoutData((Object)new TableWrapData(256, 64, 3, 2));
        toolkit.paintBordersFor(scrolledForm.getBody());
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.description = this.descriptionText.getText();
        this.organism = this.organismText.getText();
        DataBindingContext dataBindingContext = new DataBindingContext();
        Binding binding = dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameText), PojoProperties.value(SaveGeneListDialog.class, (String)"name").observe((Object)this), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new StringRequiredValidator("Name cannot be left empty", "Name", this.dec)), null);
        DataBindingContext dataBindingContext2 = new DataBindingContext();
        Binding binding2 = dataBindingContext2.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.organismText), PojoProperties.value(SaveGeneListDialog.class, (String)"organism").observe((Object)this), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new StringRequiredValidator("Organism cannot be left empty", "Organism", this.dec2)), null);
        if (((Status)binding.getValidationStatus().getValue()).isOK() && ((Status)binding2.getValidationStatus().getValue()).isOK()) {
            super.okPressed();
        } else {
            this.errorLabel.setForeground(new Display().getSystemColor(3));
            this.errorLabel.setText(((Status)binding.getValidationStatus().getValue()).getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setOrganism(String organism) {
        this.organism = organism;
    }

    public String getOrganism() {
        return this.organism;
    }

    class StringRequiredValidator
    implements IValidator {
        private final String errorText;
        private final String type;
        private final ControlDecoration controlDecoration;

        public StringRequiredValidator(String errorText, String type, ControlDecoration controlDecoration) {
            this.errorText = errorText;
            this.type = type;
            this.controlDecoration = controlDecoration;
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String text = (String)value;
                if (text.trim().length() == 0) {
                    this.controlDecoration.show();
                    return ValidationStatus.error((String)this.errorText);
                }
                if (this.type.equals("Name") && SaveGeneListDialog.this.existing != null) {
                    for (GeneList geneList : SaveGeneListDialog.this.existing) {
                        if (!geneList.getListName().equals(text)) continue;
                        this.controlDecoration.show();
                        return ValidationStatus.error((String)"The name already exists");
                    }
                }
            }
            this.controlDecoration.hide();
            SaveGeneListDialog.this.errorLabel.setText("");
            return Status.OK_STATUS;
        }
    }
}

