/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRProperty;
import org.grits.toolbox.entry.qrtpcr.util.ExcelFileHandler;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class ExportQrtPCRTable {
    private static final Logger logger = Logger.getLogger(ExportQrtPCRTable.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, @Named(value="activeShell") @Named(value="activeShell") Shell shell) throws ExecutionException {
        block17: {
            logger.debug((Object)"BEGIN ExportQrtPCRTable");
            Entry selectedEntry = null;
            if (object instanceof Entry) {
                selectedEntry = (Entry)object;
            } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
            }
            if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
            }
            if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.qrtpcr".equals(selectedEntry.getProperty().getType()))) {
                selectedEntry = null;
            }
            if (selectedEntry != null) {
                Object[] selections;
                boolean exportReruns;
                boolean exportPlateData;
                boolean exportMaster;
                QrtPCRRun pcrRun;
                block18: {
                    QrtPCRProperty prop = (QrtPCRProperty)selectedEntry.getProperty();
                    String filename = prop.getFilename();
                    pcrRun = FileUtils.loadQrtPCRRun(selectedEntry, filename);
                    String[] possibleSelections = pcrRun.getRunIdTableMap().size() > 1 ? new String[]{"Master Table", "Plate Data", "Re-run Data"} : new String[]{"Master Table", "Plate Data"};
                    LabelProvider labelProvider = new LabelProvider(){

                        public String getText(Object element) {
                            return (String)element;
                        }
                    };
                    exportMaster = false;
                    exportPlateData = false;
                    exportReruns = false;
                    ListSelectionDialog dialog = new ListSelectionDialog(shell, (Object)possibleSelections, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, "Please select the parts you would like to export");
                    dialog.setTitle("Export Options");
                    dialog.setInitialSelections((Object[])new String[]{"Plate Data"});
                    if (dialog.open() != 0) break block17;
                    selections = dialog.getResult();
                    if (selections != null && selections.length != 0) break block18;
                    ErrorUtils.createWarningMessageBox((Shell)shell, (String)"No Selection", (String)"You have not selected anything to export");
                    return null;
                }
                try {
                    Object[] objectArray = selections;
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object col = objectArray[n2];
                        String sel = (String)col;
                        if (sel.equals("Master Table")) {
                            exportMaster = true;
                        }
                        if (sel.equals("Plate Data")) {
                            exportPlateData = true;
                        }
                        if (sel.equals("Re-run Data")) {
                            exportReruns = true;
                        }
                        ++n2;
                    }
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    fileDialog.setText("Select File");
                    fileDialog.setFilterExtensions(new String[]{"*.xlsx"});
                    fileDialog.setFilterNames(new String[]{"Excel (*.xlsx)"});
                    fileDialog.setFileName(String.valueOf(selectedEntry.getDisplayName()) + ".xlsx");
                    fileDialog.setOverwrite(true);
                    String selected = fileDialog.open();
                    if (selected != null) {
                        ExcelFileHandler.exportQrtPCRTable(pcrRun, selected, exportMaster, exportPlateData, exportReruns);
                    }
                }
                catch (JAXBException e) {
                    logger.error((Object)"Error loading qrtPCR Data", (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error loading qrtPCR Data", (Exception)((Object)e));
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)"Error locating qrtPCR Data", (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error loading qrtPCR Data", (Exception)e);
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)"Error loading qrtPCR Data", (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error loading qrtPCR Data", (Exception)e);
                }
                catch (IOException e) {
                    logger.error((Object)"Error generating Excel file", (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error generating Excel file", (Exception)e);
                }
            }
        }
        logger.debug((Object)"END ExportQrtPCRTable");
        return null;
    }
}

