/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.sample.config.Config;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.part.IAnalytePartTab;
import org.grits.toolbox.entry.sample.part.action.DeleteComponentAction;
import org.grits.toolbox.entry.sample.part.action.SortComponentTableByLabel;
import org.grits.toolbox.entry.sample.part.action.sort.ComponentTableViewerComparator;
import org.grits.toolbox.entry.sample.part.providers.AnalyteContentProvider;
import org.grits.toolbox.entry.sample.part.providers.ComponentLabelProvider;
import org.grits.toolbox.entry.sample.utilities.MaintainTableColumnRatioListener;

public class OverviewTab
implements IAnalytePartTab {
    private static Logger logger = Logger.getLogger(OverviewTab.class);
    public static final String LABEL = "Overview";
    @Inject
    private MDirtyable dirtyable = null;
    @Inject
    private IEventBroker eventBroker = null;
    @Inject
    private ECommandService commandService = null;
    @Inject
    private EHandlerService handlerService = null;
    @Inject
    private Sample sample = null;
    @Inject
    private CTabFolder cTabFolder = null;
    private Text descriptionText = null;
    public TableViewer tableViewer = null;

    @Inject
    public OverviewTab() {
    }

    @PostConstruct
    public void createTab() {
        logger.info((Object)"Creating overview tab");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabFolder, 768);
        GridData layoutData = new GridData();
        scrolledComposite.setLayoutData((Object)layoutData);
        scrolledComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)scrolledComposite, 4);
        GridLayout firstLevelLayout = new GridLayout();
        firstLevelLayout.verticalSpacing = 60;
        composite.setLayout((Layout)firstLevelLayout);
        composite.setBackground(Display.getCurrent().getSystemColor(37));
        Composite comp1 = this.createDescriptionPart(composite);
        GridData comp1Data = new GridData();
        comp1Data.heightHint = 120;
        comp1Data.minimumWidth = 400;
        comp1Data.grabExcessHorizontalSpace = true;
        comp1Data.horizontalAlignment = 4;
        comp1.setLayoutData((Object)comp1Data);
        Composite comp2 = this.createTablesPart(composite);
        GridData comp2Data = new GridData(1808);
        comp2Data.grabExcessHorizontalSpace = true;
        comp2Data.grabExcessVerticalSpace = true;
        comp2.setLayoutData((Object)comp2Data);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.tableViewer.setInput((Object)this.sample);
        this.cTabFolder.getItem(0).setControl((Control)scrolledComposite);
    }

    private Composite createDescriptionPart(Composite fullComposite) {
        Composite descriptionComposite = new Composite(fullComposite, 4);
        GridLayout descriptionPartLayout = new GridLayout(2, false);
        descriptionComposite.setLayout((Layout)descriptionPartLayout);
        descriptionComposite.setBackground(Display.getCurrent().getSystemColor(37));
        descriptionComposite.setBackgroundMode(2);
        Label descriptionLabel = new Label(descriptionComposite, 16384);
        descriptionLabel.setBackground(Display.getCurrent().getSystemColor(1));
        descriptionLabel.setText("Description :");
        GridData gd = new GridData(128);
        gd.verticalAlignment = 1;
        descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = new Text(descriptionComposite, 2624);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.descriptionText.setLayoutData((Object)gd);
        String description = this.sample.getDescription();
        description = description == null ? "" : description;
        this.descriptionText.setText(description);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                String description = text.getText().trim();
                OverviewTab.this.sample.setDescription(description);
                OverviewTab.this.dirtyable.setDirty(true);
            }
        });
        this.descriptionText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    ((Text)e.getSource()).selectAll();
                }
            }
        });
        return descriptionComposite;
    }

    private Composite createTablesPart(Composite fullComposite) {
        Composite tableComposite = new Composite(fullComposite, 17);
        tableComposite.setBackground(Display.getCurrent().getSystemColor(37));
        TableWrapLayout tableCompositeLayout = new TableWrapLayout();
        tableCompositeLayout.numColumns = 1;
        tableComposite.setLayout((Layout)tableCompositeLayout);
        this.createSection(tableComposite);
        return tableComposite;
    }

    private void createSection(Composite tableComposite) {
        Section section = new Section(tableComposite, 324);
        section.setText("List of Components");
        section.setBackground(Display.getCurrent().getSystemColor(37));
        section.setTitleBarBackground(Config.TREE_TITLE_BAR_BACKGROUND_COLOR);
        section.setTitleBarForeground(Config.TEXT_COLOR);
        section.setLayout((Layout)new TableWrapLayout());
        Composite infoComposite = new Composite((Composite)section, 0);
        infoComposite.setLayout((Layout)new GridLayout());
        infoComposite.setBackground(Display.getCurrent().getSystemColor(1));
        Table table = new Table(infoComposite, 68356);
        this.tableViewer = new TableViewer(table);
        TableViewerColumn column0 = new TableViewerColumn(this.tableViewer, 16384);
        column0.getColumn().setText("Component Name");
        TableViewerColumn column1 = new TableViewerColumn(this.tableViewer, 16384);
        column1.getColumn().setText("Description");
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new AnalyteContentProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)OverviewTab.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    Component component = (Component)selection.getFirstElement();
                    OverviewTab.this.eventBroker.post("analyte_part_switch_to_component_tab", (Object)component);
                }
            }
        });
        MaintainTableColumnRatioListener ratioController = new MaintainTableColumnRatioListener(500, 1, 3);
        this.tableViewer.getTable().addControlListener((ControlListener)ratioController);
        GridData tableViewerData = new GridData(1808);
        tableViewerData.grabExcessHorizontalSpace = true;
        tableViewerData.grabExcessVerticalSpace = true;
        tableViewerData.minimumHeight = 500;
        tableViewerData.widthHint = 600;
        this.tableViewer.getTable().setLayoutData((Object)tableViewerData);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        final ComponentTableViewerComparator tableViewerComparator = new ComponentTableViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)tableViewerComparator);
        this.tableViewer.getTable().getColumn(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableViewerComparator.setColumn(0);
                tableViewerComparator.setAscending(!tableViewerComparator.getAscending());
                OverviewTab.this.tableViewer.refresh();
            }
        });
        this.tableViewer.getTable().getColumn(1).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableViewerComparator.setColumn(1);
                tableViewerComparator.setAscending(!tableViewerComparator.getAscending());
                OverviewTab.this.tableViewer.refresh();
            }
        });
        ToolBarManager toolBarManager = new ToolBarManager(4096);
        toolBarManager.add((IAction)new DeleteComponentAction(this.eventBroker, this.tableViewer));
        toolBarManager.add((IAction)new SortComponentTableByLabel(this.tableViewer));
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        ToolItem toolItem1 = new ToolItem(toolbar, 8);
        toolItem1.setImage(ImageShare.ADD_ICON.createImage());
        toolItem1.setToolTipText("Add a new Component");
        toolItem1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.executeCommand("org.grits.toolbox.entry.sample.command.addcomponent");
            }

            private void executeCommand(String commandId) {
                OverviewTab.this.handlerService.executeHandler(OverviewTab.this.commandService.createCommand(commandId, null));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.executeCommand("org.grits.toolbox.entry.sample.command.addcomponent");
            }
        });
        section.setTextClient((Control)toolbar);
        TableWrapData sectionLayoutData = new TableWrapData(128, 64);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        section.setLayoutData((Object)sectionLayoutData);
        section.setClient((Control)infoComposite);
    }

    @Optional
    @Inject
    public void refreshTab(@UIEventTopic(value="analyte_modified_in_the_part") Sample sample) {
        if (this.sample == sample) {
            this.tableViewer.refresh();
            this.dirtyable.setDirty(true);
        }
    }

    @Override
    public Sample getInput() {
        return this.sample;
    }

    @Override
    public void setFocus() {
        this.descriptionText.setFocus();
    }

    @PreDestroy
    public void dispose() {
        logger.info((Object)"Disposing overview tab");
    }
}

