/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine;

import java.util.ArrayList;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngine;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngineException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class StructureBasis {
    ArrayList<String> CondensedCodes = new ArrayList();
    String query = "RES\n1b:a-dglc-HEX-1:5\n2b:b-dglc-HEX-1:5\n3b:a-dglc-HEX-1:5\nLIN\n1:1o(4+1)2d2:2o(4+1)3d";

    public void structureInit() {
        this.CondensedCodes.add("RES\n1b:a-dglc-HEX-1:5\n2r:r1\n3b:a-dglc-HEX-1:5\nLIN\n1:1o(4+1)2n2:2n(4+1)3dREP\nREP1:4o(4+1)4d=-1--1\nRES\n4b:b-dglc-HEX-1:5\n");
    }

    public void calculate() {
        try {
            SugarImporterGlycoCTCondensed g_in = new SugarImporterGlycoCTCondensed();
            SearchEngine SE = new SearchEngine();
            Sugar o_query = g_in.parse(this.query);
            SE.setQueryStructure(o_query);
            for (String code : this.CondensedCodes) {
                Sugar t_sug = g_in.parse(code);
                SE.setQueriedStructure(t_sug);
                SE.match();
                if (!SE.isExactMatch().booleanValue()) continue;
                System.out.println("NO." + this.CondensedCodes.indexOf(code) + " is hit!");
                SE.plotMatrix();
                System.out.println("\n");
            }
        }
        catch (SugarImporterException e) {
            e.printStackTrace();
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        catch (GlycoconjugateException e) {
            e.printStackTrace();
        }
        catch (SearchEngineException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        StructureBasis SB = new StructureBasis();
        SB.structureInit();
        SB.calculate();
    }
}

