/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.GlycoCT;

import java.util.Comparator;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarExporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.util.analytical.misc.GlycoVisitorCountNodeType;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorCountBranchingPoints;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorCountLongestBranch;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorCountResidueTerminal;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoCTGlycoNodeComparator
implements Comparator<GlycoNode> {
    @Override
    public int compare(GlycoNode r1, GlycoNode r2) {
        if (this.ResidueCount(r1, r2) != 0) {
            return this.ResidueCount(r1, r2);
        }
        if (this.LongestBranch(r1, r2) != 0) {
            return this.LongestBranch(r1, r2);
        }
        if (this.TerminalResidue(r1, r2) != 0) {
            return this.TerminalResidue(r1, r2);
        }
        if (this.BranchingCount(r1, r2) != 0) {
            return this.BranchingCount(r1, r2);
        }
        if (this.AlphaNum(r1, r2) != 0) {
            return this.AlphaNum(r1, r2);
        }
        return 0;
    }

    private int BranchingCount(GlycoNode r1, GlycoNode r2) {
        int t_g2LongestBranch;
        int t_g1LongestBranch;
        block4: {
            t_g1LongestBranch = 0;
            t_g2LongestBranch = 0;
            GlycoVisitorCountBranchingPoints t_oLongest = new GlycoVisitorCountBranchingPoints();
            t_oLongest.start(r1);
            t_g1LongestBranch = t_oLongest.getBranchingPointsCountResidue();
            t_oLongest.clear();
            t_oLongest.start(r2);
            t_g2LongestBranch = t_oLongest.getBranchingPointsCountResidue();
            if (t_g1LongestBranch >= t_g2LongestBranch) break block4;
            return 1;
        }
        try {
            if (t_g1LongestBranch > t_g2LongestBranch) {
                return -1;
            }
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int TerminalResidue(GlycoNode r1, GlycoNode r2) {
        int t_g2LongestBranch;
        int t_g1LongestBranch;
        block4: {
            t_g1LongestBranch = 0;
            t_g2LongestBranch = 0;
            GlycoVisitorCountResidueTerminal t_oLongest = new GlycoVisitorCountResidueTerminal();
            t_oLongest.start(r1);
            t_g1LongestBranch = t_oLongest.getTerminalCountResidue();
            t_oLongest.start(r2);
            t_g2LongestBranch = t_oLongest.getTerminalCountResidue();
            if (t_g1LongestBranch >= t_g2LongestBranch) break block4;
            return 1;
        }
        try {
            if (t_g1LongestBranch > t_g2LongestBranch) {
                return -1;
            }
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int AlphaNum(GlycoNode r1, GlycoNode r2) {
        String t_g1StringGlycoCT = "";
        String t_g2StringGlycoCT = "";
        SugarExporterGlycoCTCondensed t_objGlycoCTExporter = new SugarExporterGlycoCTCondensed();
        try {
            t_objGlycoCTExporter.start(r1);
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        t_g1StringGlycoCT = t_objGlycoCTExporter.getHashCode();
        t_objGlycoCTExporter.clear();
        try {
            t_objGlycoCTExporter.start(r2);
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        t_g2StringGlycoCT = t_objGlycoCTExporter.getHashCode();
        return t_g2StringGlycoCT.compareTo(t_g1StringGlycoCT) * -1;
    }

    private int LongestBranch(GlycoNode r1, GlycoNode r2) {
        int t_g2LongestBranch;
        int t_g1LongestBranch;
        block4: {
            t_g1LongestBranch = 0;
            t_g2LongestBranch = 0;
            GlycoVisitorCountLongestBranch t_oLongest = new GlycoVisitorCountLongestBranch();
            t_oLongest.start(r1);
            t_g1LongestBranch = t_oLongest.getLongestBranchResidue();
            t_oLongest.start(r2);
            t_g2LongestBranch = t_oLongest.getLongestBranchResidue();
            if (t_g1LongestBranch >= t_g2LongestBranch) break block4;
            return 1;
        }
        try {
            if (t_g1LongestBranch > t_g2LongestBranch) {
                return -1;
            }
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int ResidueCount(GlycoNode r1, GlycoNode r2) {
        int t_g2LongestBranch;
        int t_g1LongestBranch;
        block4: {
            t_g1LongestBranch = 0;
            t_g2LongestBranch = 0;
            GlycoVisitorCountNodeType t_oLongest = new GlycoVisitorCountNodeType();
            t_oLongest.start(r1);
            t_g1LongestBranch = t_oLongest.getMonosaccharideCount() + t_oLongest.getNonMonosaccharideCount() + t_oLongest.getSubstituentCount() + t_oLongest.getAlternativeNodeCount();
            t_oLongest.clear();
            t_oLongest.start(r2);
            t_g2LongestBranch = t_oLongest.getMonosaccharideCount() + t_oLongest.getNonMonosaccharideCount() + t_oLongest.getSubstituentCount() + t_oLongest.getAlternativeNodeCount();
            if (t_g1LongestBranch >= t_g2LongestBranch) break block4;
            return 1;
        }
        try {
            if (t_g1LongestBranch > t_g2LongestBranch) {
                return -1;
            }
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

