/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.GritsDataModelService;
import org.grits.toolbox.core.service.IGritsDataModelService;

@Singleton
public class DataModelHandler {
    @Inject
    static IGritsDataModelService gritsDataModelService;
    @Inject
    static IEclipseContext eclipseContext;
    private boolean show = true;

    public static DataModelHandler instance() {
        return (DataModelHandler)eclipseContext.get(DataModelHandler.class);
    }

    public Entry getRoot() {
        return gritsDataModelService.getRootEntry();
    }

    public Entry findEntryById(Integer entryId) {
        return gritsDataModelService.findEntryById(entryId);
    }

    @Deprecated
    public void deleteEntry(Entry entry, boolean update) throws IOException {
        boolean lastUpdateMode = GritsDataModelService.updateMode;
        GritsDataModelService.updateMode = update;
        gritsDataModelService.deleteEntry(entry);
        GritsDataModelService.updateMode = lastUpdateMode;
    }

    @Deprecated
    public void renameEntry(Entry entry, String newName) {
        gritsDataModelService.renameEntry(entry, newName);
    }

    @Deprecated
    public void addEntry(Entry parent, Entry toAdd, boolean update) {
        boolean lastUpdateMode = GritsDataModelService.updateMode;
        GritsDataModelService.updateMode = update;
        gritsDataModelService.addEntry(parent, toAdd);
        GritsDataModelService.updateMode = lastUpdateMode;
    }

    @Deprecated
    public void removeChildren(Entry parent, boolean update) {
        boolean lastUpdateMode = GritsDataModelService.updateMode;
        GritsDataModelService.updateMode = update;
        gritsDataModelService.removeAllChildren(parent);
        GritsDataModelService.updateMode = lastUpdateMode;
    }

    @Deprecated
    public void addChildren(Entry projectEntry) throws Exception {
        gritsDataModelService.addProjectEntry(projectEntry);
    }

    @Deprecated
    public StructuredSelection getLastSelection() {
        return gritsDataModelService.getLastSelection();
    }

    public boolean getShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }
}

