/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.providers;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.grits.toolbox.entry.sample.config.Config;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.part.providers.CategoryTreeContentProvider;

public class DescriptorValueLabelProvider
extends ColumnLabelProvider {
    private TreeViewer treeViewer = null;

    public DescriptorValueLabelProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public String getText(Object element) {
        if (element instanceof Descriptor) {
            return ((Descriptor)element).getValue();
        }
        return null;
    }

    public Color getBackground(Object element) {
        Color backgroundColor;
        block2: {
            Category category;
            Descriptor descriptor;
            block3: {
                backgroundColor = null;
                if (!(element instanceof Descriptor) || (descriptor = (Descriptor)element).getValue() != null && !descriptor.getValue().isEmpty()) break block2;
                category = (Category)this.treeViewer.getInput();
                if (!category.getDescriptors().contains(descriptor)) break block3;
                CategoryTemplate categoryTemplate = ((CategoryTreeContentProvider)this.treeViewer.getContentProvider()).getCategoryTemplate();
                if (categoryTemplate == null) break block2;
                backgroundColor = Config.HIGHLIGHT_COLOR_WARN;
                for (Descriptor desc : categoryTemplate.getMandatoryDescriptors()) {
                    if (!desc.getUri().equals(descriptor.getUri())) continue;
                    backgroundColor = Config.HIGHLIGHT_COLOR_ERROR;
                    break block2;
                }
                break block2;
            }
            for (DescriptorGroup dg : category.getDescriptorGroups()) {
                backgroundColor = Config.HIGHLIGHT_COLOR_WARN;
                if (!dg.getMandatoryDescriptors().contains(descriptor)) continue;
                backgroundColor = Config.HIGHLIGHT_COLOR_ERROR;
                break;
            }
        }
        return backgroundColor;
    }

    public String getToolTipText(Object obj) {
        String toolTipText = "";
        if (obj instanceof Descriptor) {
            Descriptor desc = (Descriptor)obj;
            toolTipText = String.valueOf(toolTipText) + desc.getLabel() + " \n\n     ";
            if (!desc.getNamespaces().isEmpty()) {
                toolTipText = String.valueOf(toolTipText) + "The values can be added from the following namespaces.\n     Namespaces - ";
                for (Namespace namespace : desc.getNamespaces()) {
                    if (namespace.getUri().contains("XMLSchema")) {
                        if (namespace.getUri().endsWith("string")) {
                            toolTipText = String.valueOf(toolTipText) + "free text";
                            continue;
                        }
                        if (namespace.getUri().endsWith("double")) {
                            toolTipText = String.valueOf(toolTipText) + "floating point number";
                            continue;
                        }
                        if (namespace.getUri().endsWith("date")) {
                            toolTipText = String.valueOf(toolTipText) + "date";
                            continue;
                        }
                        if (!namespace.getUri().endsWith("int")) continue;
                        toolTipText = String.valueOf(toolTipText) + "whole number";
                        continue;
                    }
                    toolTipText = String.valueOf(toolTipText) + namespace.getLabel() + " (" + namespace.getUri() + ")\n     ";
                }
                toolTipText = String.valueOf(toolTipText) + "\n     ";
            }
        } else if (obj instanceof DescriptorGroup) {
            DescriptorGroup dg = (DescriptorGroup)obj;
            toolTipText = String.valueOf(toolTipText) + dg.getLabel() + " \n\n     ";
        }
        return toolTipText;
    }
}

