/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog.setTemplate;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.utilShare.validator.NumericValidator;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.utilities.CellEditorWithSpinner;

public class MaxOccurrenceEditingSupport
extends EditingSupport {
    private TableViewer tableViewer = null;
    private TreeViewer treeViewer = null;
    private CellEditorWithSpinner spinnerCellEditor = null;

    public MaxOccurrenceEditingSupport(TableViewer tableViewer) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.spinnerCellEditor = new CellEditorWithSpinner((Composite)tableViewer.getTable());
        this.spinnerCellEditor.setValidator((ICellEditorValidator)new NumericValidator());
    }

    public MaxOccurrenceEditingSupport(TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        this.treeViewer = treeViewer;
        this.spinnerCellEditor = new CellEditorWithSpinner((Composite)treeViewer.getTree());
    }

    protected CellEditor getCellEditor(Object element) {
        Integer value = null;
        if (element instanceof Descriptor) {
            value = ((Descriptor)element).getMaxOccurrence();
        }
        if (element instanceof DescriptorGroup) {
            value = ((DescriptorGroup)element).getMaxOccurrence();
        }
        this.spinnerCellEditor.setValue(value);
        return this.spinnerCellEditor;
    }

    protected boolean canEdit(Object element) {
        if (this.tableViewer != null) {
            return element instanceof DescriptorGroup || element instanceof Descriptor;
        }
        if (this.treeViewer != null) {
            return element instanceof DescriptorGroup || element instanceof Descriptor;
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (element instanceof Descriptor) {
            return ((Descriptor)element).getMaxOccurrence();
        }
        if (element instanceof DescriptorGroup) {
            return ((DescriptorGroup)element).getMaxOccurrence();
        }
        return null;
    }

    protected void setValue(Object element, Object setValue) {
        Integer intValue = (Integer)setValue;
        if (element instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)element;
            descriptor.setMaxOccurrence(intValue);
            if (this.tableViewer != null) {
                this.tableViewer.refresh(element);
            } else if (this.treeViewer != null) {
                this.treeViewer.refresh(element);
            }
        }
        if (element instanceof DescriptorGroup) {
            DescriptorGroup descriptorGroup = (DescriptorGroup)element;
            descriptorGroup.setMaxOccurrence(intValue);
            if (this.treeViewer != null) {
                this.treeViewer.refresh(element);
            }
        }
    }
}

