/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;

public class ChartPrintJob {
    private static final double BORDER = 0.8;
    private String jobName;

    public ChartPrintJob(String jobName) {
        this.jobName = jobName;
    }

    public void print(Composite elementToPrint) {
        PrintDialog dialog = new PrintDialog(elementToPrint.getShell());
        PrinterData printerData = dialog.open();
        if (printerData == null) {
            return;
        }
        this.startPrintJob(elementToPrint, printerData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPrintJob(Composite elementToPrint, PrinterData printerData) {
        Printer printer = new Printer(printerData);
        try {
            printer.startJob(this.jobName);
            GC gc = new GC((Drawable)printer);
            try {
                Rectangle printArea = this.getPrintableArea(printer, 0.8);
                printer.startPage();
                this.printComposite(elementToPrint, gc, printArea);
                printer.endPage();
            }
            finally {
                gc.dispose();
            }
            printer.endJob();
        }
        finally {
            printer.dispose();
        }
    }

    private Rectangle getPrintableArea(Printer printer, double safetyBorder) {
        int safetyBorderWidth = (int)(safetyBorder * (double)printer.getDPI().x);
        int safetyBorderHeight = (int)(safetyBorder * (double)printer.getDPI().y);
        Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        int trimLeft = -trim.x;
        int trimTop = -trim.y;
        int trimRight = trim.x + trim.width;
        int trimBottom = trim.y + trim.height;
        int marginLeft = Math.max(trimLeft, safetyBorderWidth);
        int marginRight = Math.max(trimRight, safetyBorderWidth);
        int marginTop = Math.max(trimTop, safetyBorderHeight);
        int marginBottom = Math.max(trimBottom, safetyBorderHeight);
        int availWidth = printer.getClientArea().width - marginLeft - marginRight;
        int availHeight = printer.getClientArea().height - marginTop - marginBottom;
        return new Rectangle(marginLeft, marginTop, availWidth, availHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printComposite(Composite elementToPrint, GC gc, Rectangle printArea) {
        Image image = new Image((Device)elementToPrint.getDisplay(), elementToPrint.getSize().x, elementToPrint.getSize().y);
        try {
            GC imageGC = new GC((Drawable)image);
            try {
                elementToPrint.print(imageGC);
                Point fittedSize = this.calcFittedSize(printArea, elementToPrint.getSize());
                gc.drawImage(image, 0, 0, elementToPrint.getSize().x, elementToPrint.getSize().y, printArea.x, printArea.y, fittedSize.x, fittedSize.y);
            }
            finally {
                imageGC.dispose();
            }
        }
        finally {
            image.dispose();
        }
    }

    Point calcFittedSize(Rectangle printArea, Point originalSize) {
        double scaleFactor = Math.min((double)printArea.height / (double)originalSize.y, (double)printArea.width / (double)originalSize.x);
        int trgHeight = (int)Math.ceil((double)originalSize.y * scaleFactor);
        int trgWidth = (int)Math.ceil((double)originalSize.x * scaleFactor);
        return new Point(trgWidth, trgHeight);
    }
}

