/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eurocarbdb.application.glycanbuilder.AbstractResidueRenderer;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;
import org.eurocarbdb.application.glycanbuilder.Paintable;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueStyle;
import org.eurocarbdb.application.glycanbuilder.ResidueType;

public class ResidueRendererAWT
extends AbstractResidueRenderer {
    public ResidueRendererAWT() {
    }

    public ResidueRendererAWT(GlycanRenderer src) {
        super(src);
    }

    public Icon getIcon(ResidueType type, int max_y_size) {
        int orientation = this.theGraphicOptions.ORIENTATION;
        this.theGraphicOptions.ORIENTATION = 0;
        Residue node = new Residue(type);
        Rectangle bbox = this.computeBoundingBox(node, false, 4, 4, new ResAngle(), max_y_size - 8, max_y_size - 8);
        BufferedImage img = GraphicUtils.createCompatibleImage(bbox.width + 8, bbox.height + 8, false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setBackground(new Color(255, 255, 255, 0));
        this.paint(new DefaultPaintable(g2d), node, false, false, null, bbox, null, new ResAngle());
        this.theGraphicOptions.ORIENTATION = orientation;
        return new ImageIcon(img);
    }

    public BufferedImage getBufferedImage(ResidueType type, int max_y_size) {
        int orientation = this.theGraphicOptions.ORIENTATION;
        this.theGraphicOptions.ORIENTATION = 0;
        Residue node = new Residue(type);
        Rectangle bbox = this.computeBoundingBox(node, false, 4, 4, new ResAngle(), max_y_size - 8, max_y_size - 8);
        BufferedImage img = GraphicUtils.createCompatibleImage(bbox.width + 8, bbox.height + 8, false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setBackground(new Color(255, 255, 255, 0));
        this.paint(new DefaultPaintable(g2d), node, false, false, null, bbox, null, new ResAngle());
        this.theGraphicOptions.ORIENTATION = orientation;
        return img;
    }

    public Image getImage(ResidueType type, int max_y_size) {
        return Toolkit.getDefaultToolkit().createImage(this.getBufferedImage(type, max_y_size).getSource());
    }

    public void paint(Paintable paintable, Residue node, boolean selected, boolean active, boolean on_border, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        if (node == null) {
            return;
        }
        Graphics2D g2d = paintable.getGraphics2D();
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        Shape shape = this.createShape(node, par_bbox, cur_bbox, sup_bbox, orientation);
        Shape text_shape = this.createTextShape(node, par_bbox, cur_bbox, sup_bbox, orientation);
        Shape fill_shape = this.createFillShape(node, cur_bbox);
        Color shape_color = style.getShapeColor();
        Color fill_color = style.getFillColor();
        Color text_color = style.getTextColor();
        if (selected) {
            fill_color = new Color(ResidueRendererAWT.sig(fill_color.getRed()), ResidueRendererAWT.sig(fill_color.getGreen()), ResidueRendererAWT.sig(fill_color.getBlue()));
        }
        if (!active) {
            shape_color = new Color(ResidueRendererAWT.sig(shape_color.getRed()), ResidueRendererAWT.sig(shape_color.getGreen()), ResidueRendererAWT.sig(shape_color.getBlue()));
            fill_color = new Color(ResidueRendererAWT.sig(fill_color.getRed()), ResidueRendererAWT.sig(fill_color.getGreen()), ResidueRendererAWT.sig(fill_color.getBlue()));
            text_color = new Color(ResidueRendererAWT.sig(text_color.getRed()), ResidueRendererAWT.sig(text_color.getGreen()), ResidueRendererAWT.sig(text_color.getBlue()));
        }
        if (shape != null && !on_border) {
            if (fill_shape != null) {
                Shape old_clip = g2d.getClip();
                g2d.clip(shape);
                g2d.setColor(style.isFillNegative() ? fill_color : Color.white);
                g2d.fill(shape);
                g2d.setColor(style.isFillNegative() ? Color.white : fill_color);
                g2d.fill(fill_shape);
                g2d.setColor(shape_color);
                g2d.draw(fill_shape);
                g2d.setClip(old_clip);
            }
            g2d.setStroke(selected ? new BasicStroke(2.0f) : new BasicStroke(1.0f));
            g2d.setColor(shape_color);
            g2d.draw(shape);
            g2d.setStroke(new BasicStroke(1.0f));
        } else if (selected) {
            float[] dashes = new float[]{5.0f, 5.0f};
            g2d.setStroke(new BasicStroke(2.0f, 0, 1, 1.0f, dashes, 0.0f));
            g2d.setColor(shape_color);
            g2d.draw(cur_bbox);
            g2d.setStroke(new BasicStroke(1.0f));
        }
        if (text_shape != null) {
            g2d.setColor(shape_color);
            g2d.fill(text_shape);
        }
        if (shape == null || on_border || style.getText() != null) {
            if (shape == null || on_border) {
                orientation = this.theGraphicOptions.getOrientationAngle();
            } else if (style.getText() != null) {
                orientation = new ResAngle(0);
            }
            String text = this.getText(node, on_border);
            int font_size = this.theGraphicOptions.NODE_FONT_SIZE;
            int x_size = Geometry.textBounds((String)text, (String)this.theGraphicOptions.NODE_FONT_FACE, (int)font_size).width;
            if (shape != null) {
                font_size = ResidueRendererAWT.sat(8 * font_size * cur_bbox.width / x_size / 10, font_size);
            }
            Font new_font = new Font(this.theGraphicOptions.NODE_FONT_FACE, 0, font_size);
            Font old_font = g2d.getFont();
            g2d.setFont(new_font);
            Rectangle2D.Double text_bound = new Rectangle2D.Double();
            text_bound.setRect(new TextLayout(text, new_font, g2d.getFontRenderContext()).getBounds());
            g2d.setColor(text_color);
            if (orientation.equals(0) || orientation.equals(180)) {
                Rectangle2D.Double text_rect = new Rectangle2D.Double((double)Geometry.midx(cur_bbox) - text_bound.width / 2.0, (double)Geometry.midy(cur_bbox) - text_bound.height / 2.0, text_bound.width, text_bound.height);
                if (shape == null || fill_shape == null) {
                    g2d.clearRect((int)text_rect.x, (int)text_rect.y, (int)text_rect.width, (int)text_rect.height);
                }
                g2d.drawString(text, (int)text_rect.x, (int)(text_rect.y + text_rect.height));
            } else {
                Rectangle2D.Double text_rect = new Rectangle2D.Double((double)Geometry.midx(cur_bbox) - text_bound.height / 2.0, (double)Geometry.midy(cur_bbox) - text_bound.width / 2.0, text_bound.height, text_bound.width);
                if (shape == null || fill_shape == null) {
                    g2d.clearRect((int)text_rect.x, (int)text_rect.y, (int)text_rect.width, (int)text_rect.height);
                }
                g2d.rotate(-1.5707963267948966);
                g2d.drawString(text, -((int)(text_rect.y + text_rect.height)), (int)(text_rect.x + text_rect.width));
                g2d.rotate(1.5707963267948966);
            }
            g2d.setFont(old_font);
        }
    }
}

