/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTree;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorCountLongestBranch
implements GlycoVisitor {
    private GlycoTraverser m_objTraverser;
    private HashMap<GlycoNode, Integer> m_hashSubResidueCount = new HashMap();
    private HashMap<GlycoNode, Integer> m_hashSubMonosaccharideCount = new HashMap();
    private HashMap<GlycoNode, Integer> m_hashRepeatCount = new HashMap();
    private int m_iLongestBranchMS = 0;
    private int m_iLongestBranchResidue = 0;
    private SugarUnitRepeat m_objRepeat = null;

    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 1) {
            int t_iNumber = 0;
            int t_iLongestResidue = 0;
            int t_iLongestMS = 0;
            for (GlycoNode t_objResidue : a_objMonosaccharid.getChildNodes()) {
                if (this.m_hashSubResidueCount.containsKey(t_objResidue) && t_iLongestResidue < (t_iNumber = this.m_hashSubResidueCount.get(t_objResidue).intValue())) {
                    t_iLongestResidue = t_iNumber;
                }
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue) && t_iLongestMS < (t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue).intValue())) {
                    t_iLongestMS = t_iNumber;
                }
                if (!this.m_hashRepeatCount.containsKey(t_objResidue)) continue;
                t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue);
                this.m_hashRepeatCount.put(a_objMonosaccharid, t_iNumber + 1);
            }
            this.m_hashSubResidueCount.put(a_objMonosaccharid, ++t_iLongestResidue);
            this.m_hashSubMonosaccharideCount.put(a_objMonosaccharid, ++t_iLongestMS);
        }
    }

    public void visit(NonMonosaccharide a_objResidue) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 1) {
            int t_iNumber = 0;
            int t_iLongestResidue = 0;
            int t_iLongestMS = 0;
            for (GlycoNode t_objResidue : a_objResidue.getChildNodes()) {
                if (this.m_hashSubResidueCount.containsKey(t_objResidue) && t_iLongestResidue < (t_iNumber = this.m_hashSubResidueCount.get(t_objResidue).intValue())) {
                    t_iLongestResidue = t_iNumber;
                }
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue) && t_iLongestMS < (t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue).intValue())) {
                    t_iLongestMS = t_iNumber;
                }
                if (!this.m_hashRepeatCount.containsKey(t_objResidue)) continue;
                t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue);
                this.m_hashRepeatCount.put(a_objResidue, t_iNumber + 1);
            }
            this.m_hashSubResidueCount.put(a_objResidue, ++t_iLongestResidue);
            this.m_hashSubMonosaccharideCount.put(a_objResidue, ++t_iLongestMS);
        }
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserTree(a_objVisitor);
    }

    public void clear() {
        this.m_hashSubResidueCount.clear();
        this.m_hashSubMonosaccharideCount.clear();
        this.m_iLongestBranchMS = 0;
        this.m_iLongestBranchResidue = 0;
        this.m_objRepeat = null;
        this.m_hashRepeatCount.clear();
    }

    public int getLongestBranchMonosaccharide() {
        return this.m_iLongestBranchMS;
    }

    public int getLongestBranchResidue() {
        return this.m_iLongestBranchResidue;
    }

    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverseGraph(a_objSugar);
        try {
            int t_iResidue = 0;
            int t_iMS = 0;
            ArrayList<GlycoNode> t_aRoot = a_objSugar.getRootNodes();
            for (GlycoNode t_objResidue : t_aRoot) {
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue)) {
                    t_iMS = this.m_hashSubMonosaccharideCount.get(t_objResidue);
                    if (t_iMS > this.m_iLongestBranchMS) {
                        this.m_iLongestBranchMS = t_iMS;
                    }
                } else {
                    throw new GlycoVisitorException("Critical fail : residue was not calculated.");
                }
                if (this.m_hashSubResidueCount.containsKey(t_objResidue)) {
                    t_iResidue = this.m_hashSubResidueCount.get(t_objResidue);
                    if (t_iResidue <= this.m_iLongestBranchResidue) continue;
                    this.m_iLongestBranchResidue = t_iResidue;
                    continue;
                }
                throw new GlycoVisitorException("Critical fail : residue was not calculated.");
            }
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 1) {
            this.m_hashSubResidueCount.put(a_objCyclic, 0);
        }
    }

    public void visit(UnvalidatedGlycoNode a_objUnvalidated) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 1) {
            int t_iNumber = 0;
            int t_iLongestResidue = 0;
            int t_iLongestMS = 0;
            for (GlycoNode t_objResidue : a_objUnvalidated.getChildNodes()) {
                if (this.m_hashSubResidueCount.containsKey(t_objResidue) && t_iLongestResidue < (t_iNumber = this.m_hashSubResidueCount.get(t_objResidue).intValue())) {
                    t_iLongestResidue = t_iNumber;
                }
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue) && t_iLongestMS < (t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue).intValue())) {
                    t_iLongestMS = t_iNumber;
                }
                if (!this.m_hashRepeatCount.containsKey(t_objResidue)) continue;
                t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue);
                this.m_hashRepeatCount.put(a_objUnvalidated, t_iNumber + 1);
            }
            this.m_hashSubResidueCount.put(a_objUnvalidated, ++t_iLongestResidue);
            this.m_hashSubMonosaccharideCount.put(a_objUnvalidated, ++t_iLongestMS);
        }
    }

    public void visit(GlycoEdge a_objLinkage) throws GlycoVisitorException {
    }

    public void visit(Substituent a_objSubstituent) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 1) {
            int t_iNumber = 0;
            int t_iLongestResidue = 0;
            int t_iLongestMS = 0;
            ArrayList<GlycoNode> t_aResidues = a_objSubstituent.getChildNodes();
            for (GlycoNode t_objResidue : t_aResidues) {
                if (this.m_hashSubResidueCount.containsKey(t_objResidue) && t_iLongestResidue < (t_iNumber = this.m_hashSubResidueCount.get(t_objResidue).intValue())) {
                    t_iLongestResidue = t_iNumber;
                }
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue) && t_iLongestMS < (t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue).intValue())) {
                    t_iLongestMS = t_iNumber;
                }
                if (!this.m_hashRepeatCount.containsKey(t_objResidue)) continue;
                t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue);
                this.m_hashRepeatCount.put(a_objSubstituent, t_iNumber + 1);
            }
            if (t_aResidues.size() > 0) {
                this.m_hashSubMonosaccharideCount.put(a_objSubstituent, t_iLongestMS + 1);
            }
            this.m_hashSubResidueCount.put(a_objSubstituent, t_iLongestResidue + 1);
            this.m_hashSubMonosaccharideCount.put(a_objSubstituent, t_iLongestMS);
        }
    }

    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 1) {
            int t_iNumber = 0;
            int t_iLongestResidue = 0;
            int t_iLongestMS = 0;
            ArrayList<GlycoNode> t_aResidues = a_objAlternative.getChildNodes();
            for (GlycoNode t_objResidue : t_aResidues) {
                if (this.m_hashSubResidueCount.containsKey(t_objResidue) && t_iLongestResidue < (t_iNumber = this.m_hashSubResidueCount.get(t_objResidue).intValue())) {
                    t_iLongestResidue = t_iNumber;
                }
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue) && t_iLongestMS < (t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue).intValue())) {
                    t_iLongestMS = t_iNumber;
                }
                if (!this.m_hashRepeatCount.containsKey(t_objResidue)) continue;
                t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue);
                this.m_hashRepeatCount.put(a_objAlternative, t_iNumber + 1);
            }
            this.m_hashSubResidueCount.put(a_objAlternative, ++t_iLongestResidue);
            this.m_hashSubMonosaccharideCount.put(a_objAlternative, ++t_iLongestMS);
        }
    }

    public void start(GlycoNode a_objNode) throws GlycoVisitorException {
        this.clear();
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverse(a_objNode);
        if (!this.m_hashSubMonosaccharideCount.containsKey(a_objNode)) {
            throw new GlycoVisitorException("Critical fail : residue was not calculated.");
        }
        this.m_iLongestBranchMS = this.m_hashSubMonosaccharideCount.get(a_objNode);
        if (!this.m_hashSubResidueCount.containsKey(a_objNode)) {
            throw new GlycoVisitorException("Critical fail : residue was not calculated.");
        }
        this.m_iLongestBranchResidue = this.m_hashSubResidueCount.get(a_objNode);
    }

    public void visit(SugarUnitRepeat a_objRepeate) throws GlycoVisitorException {
        if (this.m_objTraverser.getState() == 1) {
            int t_iNumber = 0;
            int t_iLongestResidue = 0;
            int t_iLongestMS = 0;
            int t_iLongestRepeat = 0;
            ArrayList<GlycoNode> t_aResidues = a_objRepeate.getChildNodes();
            for (GlycoNode t_objResidue : t_aResidues) {
                if (this.m_hashSubResidueCount.containsKey(t_objResidue) && t_iLongestResidue < (t_iNumber = this.m_hashSubResidueCount.get(t_objResidue).intValue())) {
                    t_iLongestResidue = t_iNumber;
                }
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue) && t_iLongestMS < (t_iNumber = this.m_hashSubMonosaccharideCount.get(t_objResidue).intValue())) {
                    t_iLongestMS = t_iNumber;
                }
                if (!this.m_hashRepeatCount.containsKey(t_objResidue)) continue;
                t_iLongestRepeat = this.m_hashSubMonosaccharideCount.get(t_objResidue);
            }
            GlycoVisitorCountLongestBranch t_objVisitor = new GlycoVisitorCountLongestBranch();
            t_objVisitor.startRepeat(a_objRepeate);
            int t_iLongestBranchRepeat = t_objVisitor.getLongestBranchRepeat();
            t_iLongestMS = t_objVisitor.getLongestBranchMonosaccharide() > t_iLongestBranchRepeat + t_iLongestMS ? t_objVisitor.getLongestBranchMonosaccharide() : t_iLongestBranchRepeat + t_iLongestMS;
            t_iLongestResidue = t_objVisitor.getLongestBranchResidue() > t_iLongestBranchRepeat + t_iLongestResidue ? t_objVisitor.getLongestBranchResidue() : t_iLongestBranchRepeat + t_iLongestResidue;
            if (t_iLongestRepeat != 0) {
                this.m_hashRepeatCount.put(a_objRepeate, t_iLongestBranchRepeat + t_iLongestRepeat);
            }
            this.m_hashSubResidueCount.put(a_objRepeate, t_iLongestResidue);
            this.m_hashSubMonosaccharideCount.put(a_objRepeate, t_iLongestMS);
        }
    }

    protected void startRepeat(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        this.clear();
        this.m_objRepeat = a_objRepeat;
        this.m_hashRepeatCount.put(a_objRepeat.getRepeatLinkage().getChild(), 1);
        this.m_hashRepeatCount.put(a_objRepeat.getRepeatLinkage().getParent(), 1);
        this.m_objTraverser = this.getTraverser(this);
        this.m_objTraverser.traverseGraph(a_objRepeat);
        try {
            int t_iResidue = 0;
            int t_iMS = 0;
            ArrayList<GlycoNode> t_aRoot = a_objRepeat.getRootNodes();
            for (GlycoNode t_objResidue : t_aRoot) {
                if (this.m_hashSubMonosaccharideCount.containsKey(t_objResidue)) {
                    t_iMS = this.m_hashSubMonosaccharideCount.get(t_objResidue);
                    if (t_iMS > this.m_iLongestBranchMS) {
                        this.m_iLongestBranchMS = t_iMS;
                    }
                } else {
                    throw new GlycoVisitorException("Critical fail : residue was not calculated.");
                }
                if (this.m_hashSubResidueCount.containsKey(t_objResidue)) {
                    t_iResidue = this.m_hashSubResidueCount.get(t_objResidue);
                    if (t_iResidue <= this.m_iLongestBranchResidue) continue;
                    this.m_iLongestBranchResidue = t_iResidue;
                    continue;
                }
                throw new GlycoVisitorException("Critical fail : residue was not calculated.");
            }
        }
        catch (GlycoconjugateException e) {
            throw new GlycoVisitorException(e.getMessage(), e);
        }
    }

    private int getLongestBranchRepeat() throws GlycoVisitorException {
        if (this.m_objRepeat == null) {
            return 0;
        }
        if (this.m_hashRepeatCount.containsKey(this.m_objRepeat.getRepeatLinkage().getChild())) {
            return this.m_hashRepeatCount.get(this.m_objRepeat.getRepeatLinkage().getChild());
        }
        throw new GlycoVisitorException("Critical fail : repeat was not calculated.");
    }
}

