/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.analysis;

import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.analysis.SubsumptionLevel;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSGraphStateDeterminator {
    public SubsumptionLevel getSubsumptionLevel(WURCSGraph a_oGraph) {
        if (a_oGraph.getBackbones().size() == 1) {
            return SubsumptionLevel.LVX;
        }
        boolean t_bHasGlycosidicLinkage = false;
        Iterator<Modification> t_itModification = a_oGraph.getModificationIterator();
        while (t_itModification.hasNext()) {
            Modification t_oModification = t_itModification.next();
            if (!t_oModification.isGlycosidic()) continue;
            t_bHasGlycosidicLinkage = true;
        }
        if (!t_bHasGlycosidicLinkage) {
            return SubsumptionLevel.LV3;
        }
        boolean t_bHasDefinedAcceptorPosition = false;
        boolean t_bHasDefinedAnomericSymbol = false;
        Iterator<Backbone> t_itBackbone = a_oGraph.getBackboneIterator();
        while (t_itBackbone.hasNext()) {
            Backbone t_oBackbone = t_itBackbone.next();
            if (this.hasDefinedAcceptorPosition(t_oBackbone.getEdges())) {
                t_bHasDefinedAcceptorPosition = true;
            }
            if (this.isOpenChain(t_oBackbone) || !this.isDefinedAnomericState(t_oBackbone)) continue;
            t_bHasDefinedAnomericSymbol = true;
        }
        if (t_bHasDefinedAcceptorPosition || t_bHasDefinedAnomericSymbol) {
            return SubsumptionLevel.LV1;
        }
        return SubsumptionLevel.LVX;
    }

    private boolean hasDefinedAcceptorPosition(LinkedList<WURCSEdge> a_oEdges) {
        for (WURCSEdge t_oEdge : a_oEdges) {
            if (!t_oEdge.getModification().isGlycosidic() || this.isAnomericEdge(t_oEdge)) continue;
            for (LinkagePosition t_oPos : t_oEdge.getLinkages()) {
                if (t_oPos.getBackbonePosition() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFullyDefinedAcceptorPosition(LinkedList<WURCSEdge> a_oEdges) {
        for (WURCSEdge t_oEdge : a_oEdges) {
            if (!t_oEdge.getModification().isGlycosidic() || this.isAnomericEdge(t_oEdge)) continue;
            if (t_oEdge.getLinkages().getFirst().getBackbonePosition() == -1) {
                return false;
            }
            if (t_oEdge.getLinkages().size() <= 1) continue;
            return false;
        }
        return true;
    }

    private boolean isAnomericEdge(WURCSEdge a_oEdge) {
        if (!a_oEdge.getModification().isGlycosidic()) {
            return false;
        }
        if (a_oEdge.getLinkages().size() > 1) {
            return false;
        }
        int t_iPosition = a_oEdge.getLinkages().getFirst().getBackbonePosition();
        if (t_iPosition == -1) {
            return false;
        }
        return t_iPosition == a_oEdge.getBackbone().getAnomericPosition();
    }

    private boolean isDefinedAnomericState(Backbone a_oBackbone) {
        if (this.hasUncertainAnomericPosition(a_oBackbone)) {
            return false;
        }
        return a_oBackbone.getAnomericSymbol() != 'x';
    }

    private boolean isOpenChain(Backbone a_oBackbone) {
        if (a_oBackbone.getAnomericPosition() != 0) {
            return false;
        }
        return !this.hasUncertainAnomericPosition(a_oBackbone);
    }

    private boolean hasCarbonylGroup(Backbone a_oBackbone) {
        for (BackboneCarbon t_oBC : a_oBackbone.getBackboneCarbons()) {
            if (t_oBC.getDescriptor().getChar() == 'o') {
                return true;
            }
            if (t_oBC.getDescriptor().getChar() != 'O') continue;
            return true;
        }
        return false;
    }

    private boolean hasUncertainAnomericPosition(Backbone a_oBackbone) {
        for (BackboneCarbon t_oBC : a_oBackbone.getBackboneCarbons()) {
            if (t_oBC.getDescriptor().getChar() == 'u') {
                return true;
            }
            if (t_oBC.getDescriptor().getChar() != 'U') continue;
            return true;
        }
        return false;
    }
}

