/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.graph.comparator.BackboneComparator;
import org.glycoinfo.WURCSFramework.util.graph.comparator.MonosaccharideComparatorForInvertBackbone;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSVisitorCollectSequenceComparator;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectSequence;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorExpandRepeatingUnit;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.Monosaccharide;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WURCSGraphNormalizer {
    private static final Logger logger = LoggerFactory.getLogger(WURCSGraphNormalizer.class);
    private boolean m_bInverted = false;
    private boolean m_bAnomBond = false;
    private boolean m_bCyclic = false;
    private boolean m_bExpandedRep = false;

    public boolean isInverted() {
        return this.m_bInverted;
    }

    public boolean linkedAnomericPositions() {
        return this.m_bAnomBond;
    }

    public boolean hasCyclic() {
        return this.m_bCyclic;
    }

    public boolean isExpandedRepeatingUnit() {
        return this.m_bExpandedRep;
    }

    public void start(WURCSGraph a_oGraph) throws WURCSException {
        Modification t_objModification;
        Backbone t_objBackbone;
        Iterator<Backbone> t_iterBackbone = a_oGraph.getBackboneIterator();
        t_iterBackbone = a_oGraph.getBackboneIterator();
        while (t_iterBackbone.hasNext()) {
            t_objBackbone = t_iterBackbone.next();
            if (!t_objBackbone.hasParent()) continue;
            logger.debug("Reverse: " + a_oGraph.getBackbones().indexOf(t_objBackbone));
            t_objBackbone.getAnomericEdge().reverse();
        }
        this.reverseEdgeForOpenChain(a_oGraph);
        this.checkAllRoot(a_oGraph);
        Iterator<Modification> t_iterModification = a_oGraph.getModificationIterator();
        while (t_iterModification.hasNext()) {
            t_objModification = t_iterModification.next();
            if (!t_objModification.isGlycosidic() || !t_objModification.isAglycone()) continue;
            LinkedList t_aRootCandidate = new LinkedList();
            for (WURCSEdge wURCSEdge : t_objModification.getEdges()) {
                t_aRootCandidate.add(wURCSEdge.getBackbone());
            }
            Backbone t_oRoot = this.getRootOfBackbones(t_aRootCandidate, a_oGraph);
            for (WURCSEdge t_oEdge3 : t_objModification.getEdges()) {
                if (t_oEdge3.getBackbone() != t_oRoot) continue;
                t_oEdge3.forward();
            }
            this.m_bAnomBond = true;
        }
        t_iterModification = a_oGraph.getModificationIterator();
        while (t_iterModification.hasNext()) {
            t_objModification = t_iterModification.next();
            if (!(t_objModification instanceof InterfaceRepeat) && !(t_objModification instanceof ModificationAlternative)) continue;
            for (WURCSEdge t_oEdge : t_objModification.getEdges()) {
                t_oEdge.forward();
            }
        }
        t_iterBackbone = a_oGraph.getBackboneIterator();
        HashSet<Backbone> t_hashSearchedBackbones = new HashSet<Backbone>();
        while (t_iterBackbone.hasNext()) {
            t_objBackbone = t_iterBackbone.next();
            if (t_hashSearchedBackbones.contains(t_objBackbone)) continue;
            t_hashSearchedBackbones.add(t_objBackbone);
            LinkedList<Backbone> t_aCyclicBackbones = new LinkedList<Backbone>();
            t_aCyclicBackbones.addFirst(t_objBackbone);
            if (!this.checkCyclic(t_aCyclicBackbones)) continue;
            logger.debug("{} membered-cyclic part", (Object)t_aCyclicBackbones.size());
            Backbone backbone = this.getRootOfBackbones(t_aCyclicBackbones, a_oGraph);
            this.forwardParentSideEdgeForRootBackbone(backbone, t_aCyclicBackbones);
            this.m_bCyclic = true;
        }
        this.invertBackbones(a_oGraph);
        WURCSVisitorExpandRepeatingUnit t_oExpandRep = new WURCSVisitorExpandRepeatingUnit();
        t_oExpandRep.start(a_oGraph);
        this.m_bExpandedRep = t_oExpandRep.hasDone();
    }

    private void invertBackbones(WURCSGraph a_oGraph) throws WURCSException {
        LinkedList<Backbone> t_aSymmetricBackbone = new LinkedList<Backbone>();
        Iterator<Backbone> t_iterBackbone = a_oGraph.getBackboneIterator();
        while (t_iterBackbone.hasNext()) {
            Backbone t_objBackbone = t_iterBackbone.next();
            Backbone copy = t_objBackbone.copy();
            Backbone invert = t_objBackbone.copy();
            invert.invert();
            int iComp = new BackboneComparator().compare(copy, invert);
            logger.debug("compare to inverted backbone: {}", (Object)iComp);
            if (iComp > 0) {
                t_objBackbone.invert();
                this.m_bInverted = true;
            }
            if (iComp != 0) continue;
            logger.debug("Symmetry backbone: {}", (Object)t_objBackbone.getSkeletonCode());
            t_aSymmetricBackbone.addLast(t_objBackbone);
        }
        MonosaccharideComparatorForInvertBackbone t_oMSComp = new MonosaccharideComparatorForInvertBackbone();
        HashMap<Backbone, Backbone> t_hashOrigToInvert = new HashMap<Backbone, Backbone>();
        a_oGraph.copy(t_hashOrigToInvert);
        for (Backbone t_oOrigBackbone : t_aSymmetricBackbone) {
            Backbone t_oCopyBackbone = t_hashOrigToInvert.get(t_oOrigBackbone);
            t_oCopyBackbone.invert();
            int t_iComp = t_oMSComp.compare(new Monosaccharide(t_oOrigBackbone), new Monosaccharide(t_oCopyBackbone));
            if (t_iComp <= 0) continue;
            logger.debug("Invert Backbone");
            t_oOrigBackbone.invert();
            this.m_bInverted = true;
        }
    }

    private Backbone getRootOfBackbones(LinkedList<Backbone> a_aCandidateRootBackbones, WURCSGraph a_oGraph) throws WURCSException {
        LinkedList<WURCSVisitorCollectSequence> t_aSeqs = new LinkedList<WURCSVisitorCollectSequence>();
        HashMap<WURCSVisitorCollectSequence, Backbone> t_hashSeqToCB = new HashMap<WURCSVisitorCollectSequence, Backbone>();
        HashMap t_mapB2ID = new HashMap();
        for (Backbone t_oCB : a_aCandidateRootBackbones) {
            HashMap<Backbone, Backbone> t_hashOrigToCopyB = new HashMap<Backbone, Backbone>();
            a_oGraph.copy(t_hashOrigToCopyB);
            LinkedList<Backbone> t_aCopiedCyclicBackbones = new LinkedList<Backbone>();
            for (Backbone t_oCB2 : a_aCandidateRootBackbones) {
                t_aCopiedCyclicBackbones.add(t_hashOrigToCopyB.get(t_oCB2));
            }
            Backbone t_oCopyCB = t_hashOrigToCopyB.get(t_oCB);
            this.forwardParentSideEdgeForRootBackbone(t_oCopyCB, t_aCopiedCyclicBackbones);
            WURCSVisitorCollectSequence t_oSeq = new WURCSVisitorCollectSequence();
            t_oSeq.start(t_oCopyCB);
            if (t_oSeq.hasIllegalRepeat()) continue;
            t_aSeqs.add(t_oSeq);
            t_hashSeqToCB.put(t_oSeq, t_oCB);
        }
        Collections.sort(t_aSeqs, new WURCSVisitorCollectSequenceComparator());
        return (Backbone)t_hashSeqToCB.get(t_aSeqs.getFirst());
    }

    private void forwardParentSideEdgeForRootBackbone(Backbone a_oBackbone, LinkedList<Backbone> a_aCandidateRootBackbones) {
        for (WURCSEdge t_oParentEdge : a_oBackbone.getParentEdges()) {
            boolean t_bIsParent = false;
            for (WURCSEdge t_oParentParentEdge : t_oParentEdge.getModification().getParentEdges()) {
                if (!a_aCandidateRootBackbones.contains(t_oParentParentEdge.getBackbone())) continue;
                t_bIsParent = true;
            }
            if (!t_bIsParent) continue;
            t_oParentEdge.forward();
        }
    }

    private boolean checkCyclic(LinkedList<Backbone> a_aBackbones) {
        Backbone t_oHead = a_aBackbones.getFirst();
        for (WURCSEdge t_oParentEdge : t_oHead.getParentEdges()) {
            Modification t_oParentMod = t_oParentEdge.getModification();
            if (t_oParentMod instanceof InterfaceRepeat) continue;
            for (WURCSEdge t_oParentParentEdge : t_oParentMod.getParentEdges()) {
                Backbone t_oParentBack = t_oParentParentEdge.getBackbone();
                if (a_aBackbones.contains(t_oParentBack)) {
                    return true;
                }
                a_aBackbones.addFirst(t_oParentBack);
                if (this.checkCyclic(a_aBackbones)) {
                    return true;
                }
                a_aBackbones.removeFirst();
            }
        }
        return false;
    }

    private void reverseEdgeForOpenChain(WURCSGraph a_oGraph) {
        LinkedList<Modification> t_aLeafModifications = new LinkedList<Modification>();
        for (Modification modification : a_oGraph.getModifications()) {
            if (modification instanceof InterfaceRepeat || !modification.isLeaf() || !modification.isGlycosidic()) continue;
            t_aLeafModifications.add(modification);
        }
        block1: while (true) {
            LinkedList<Modification> t_aNotLeaves = new LinkedList<Modification>();
            for (Modification modification : t_aLeafModifications) {
                LinkedList<WURCSEdge> linkedList = new LinkedList<WURCSEdge>();
                for (WURCSEdge t_oEdge : modification.getEdges()) {
                    Backbone t_oBackbone = t_oEdge.getBackbone();
                    if (t_oBackbone.isRoot() && t_oBackbone.getAnomericPosition() < 1) continue;
                    linkedList.add(t_oEdge);
                }
                if (linkedList.isEmpty()) continue;
                for (WURCSEdge t_oEdge : modification.getEdges()) {
                    if (linkedList.contains(t_oEdge)) continue;
                    t_oEdge.reverse();
                }
                t_aNotLeaves.add(modification);
            }
            if (t_aNotLeaves.isEmpty()) break;
            Iterator iterator = t_aNotLeaves.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                Modification modification = (Modification)iterator.next();
                t_aLeafModifications.remove(modification);
            }
            break;
        }
        if (t_aLeafModifications.isEmpty()) {
            return;
        }
        block6: while (true) {
            LinkedList<Backbone> t_aBackboneWithChild = new LinkedList<Backbone>();
            for (Backbone backbone : a_oGraph.getBackbones()) {
                boolean bl = false;
                for (WURCSEdge t_oChildEdge : backbone.getChildEdges()) {
                    if (t_oChildEdge.getModification().getChildEdges().isEmpty()) continue;
                    bl = true;
                }
                if (!bl) continue;
                t_aBackboneWithChild.add(backbone);
            }
            LinkedList<Modification> linkedList = new LinkedList<Modification>();
            for (Modification modification : t_aLeafModifications) {
                LinkedList<WURCSEdge> t_aChildSideEdges = new LinkedList<WURCSEdge>();
                for (WURCSEdge t_oEdge : modification.getEdges()) {
                    if (!t_aBackboneWithChild.contains(t_oEdge.getBackbone())) continue;
                    t_aChildSideEdges.add(t_oEdge);
                }
                if (t_aChildSideEdges.isEmpty() || t_aChildSideEdges.size() == modification.getEdges().size()) continue;
                for (WURCSEdge t_oEdge : t_aChildSideEdges) {
                    t_oEdge.reverse();
                }
                linkedList.add(modification);
            }
            if (linkedList.isEmpty()) break;
            Iterator iterator = linkedList.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block6;
                Modification modification = (Modification)iterator.next();
                t_aLeafModifications.remove(modification);
            }
            break;
        }
    }

    private void checkAllRoot(WURCSGraph a_oGraph) throws WURCSException {
        if (a_oGraph.getBackbones().size() == 1) {
            return;
        }
        boolean t_bIsAllRoot = true;
        for (Backbone t_oBackbone : a_oGraph.getBackbones()) {
            if (t_oBackbone.isRoot()) continue;
            t_bIsAllRoot = false;
        }
        if (!t_bIsAllRoot) {
            return;
        }
        LinkedList<WURCSVisitorCollectSequence> t_aSeqs = new LinkedList<WURCSVisitorCollectSequence>();
        HashMap<WURCSVisitorCollectSequence, Backbone> t_hashSeqToCB = new HashMap<WURCSVisitorCollectSequence, Backbone>();
        for (Backbone t_oCB : a_oGraph.getBackbones()) {
            HashMap<Backbone, Backbone> t_hashOrigToCopyB = new HashMap<Backbone, Backbone>();
            WURCSGraph t_oCopyGraph = a_oGraph.copy(t_hashOrigToCopyB);
            Backbone t_oCopyCB = t_hashOrigToCopyB.get(t_oCB);
            this.reverseEdgesAroundBackbone(t_oCopyCB);
            this.reverseEdgeForOpenChain(t_oCopyGraph);
            WURCSVisitorCollectSequence t_oSeq = new WURCSVisitorCollectSequence();
            t_oSeq.start(t_oCopyCB);
            if (t_oSeq.hasIllegalRepeat()) continue;
            t_aSeqs.add(t_oSeq);
            t_hashSeqToCB.put(t_oSeq, t_oCB);
        }
        if (t_aSeqs.isEmpty()) {
            throw new WURCSException("No root backbones.");
        }
        Collections.sort(t_aSeqs, new WURCSVisitorCollectSequenceComparator());
        Backbone t_oRoot = (Backbone)t_hashSeqToCB.get(t_aSeqs.getFirst());
        this.reverseEdgesAroundBackbone(t_oRoot);
        this.reverseEdgeForOpenChain(a_oGraph);
    }

    private void reverseEdgesAroundBackbone(Backbone a_oBackbone) {
        for (WURCSEdge t_oEdge : a_oBackbone.getChildEdges()) {
            Modification t_oMod = t_oEdge.getModification();
            if (t_oMod instanceof InterfaceRepeat || !t_oMod.isLeaf() || !t_oMod.isGlycosidic()) continue;
            for (WURCSEdge t_oEdge2 : t_oMod.getEdges()) {
                if (t_oEdge2.equals(t_oEdge) || t_oEdge2.getLinkages().getFirst().getBackbonePosition() != t_oEdge2.getBackbone().getAnomericPosition()) continue;
                t_oEdge2.reverse();
            }
        }
    }
}

