/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.ui.forms.editor.FormEditor;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.input.ClassesWithFeatures;
import org.grits.toolbox.editor.samplemanager.input.DescriptorWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.rightside.RightSideSelectionListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.descriptortype.descriptor.DescriptorSelectionListener;
import org.grits.toolbox.entry.sample.model.Descriptor;

public class DesciptorManagementPage
extends AbstractManagementPage {
    private Logger logger = Logger.getLogger(DesciptorManagementPage.class);
    public static final String ID = "0";
    public static final String PAGE_TITLE = "Descriptors";
    private List<DescriptorWithFeatures> inputDescriptors = this.getAllDescriptorWithFeatures();

    public DesciptorManagementPage(FormEditor managementEditor) {
        super(managementEditor, ID, PAGE_TITLE);
    }

    public List<DescriptorWithFeatures> getAllDescriptorWithFeatures() {
        ArrayList<DescriptorWithFeatures> descriptorWithFeaturesList = new ArrayList<DescriptorWithFeatures>();
        this.logger.debug((Object)"- START : Retrieving all Descriptors for the Manager Editor.");
        try {
            ManagementEditor managementEditor = (ManagementEditor)this.getEditor();
            List<Descriptor> descriptors = null;
            ArrayList<String> standardDescriptorURIs = new ArrayList<String>();
            DescriptorWithFeatures descWithFeatures = null;
            if (!managementEditor.managerMode) {
                descriptors = managementEditor.getOntologyManagerApi().getAllDescriptors(managementEditor.getStandardOntologyModel());
                for (Descriptor desc : descriptors) {
                    descWithFeatures = new DescriptorWithFeatures(desc);
                    descWithFeatures.setEditable(false);
                    descriptorWithFeaturesList.add(descWithFeatures);
                    standardDescriptorURIs.add(desc.getUri());
                }
            }
            descriptors = managementEditor.getOntologyManagerApi().getAllDescriptors(managementEditor.getLocalOntologyModel());
            for (Descriptor desc : descriptors) {
                if (standardDescriptorURIs.contains(desc.getUri())) continue;
                descWithFeatures = new DescriptorWithFeatures(desc);
                descWithFeatures.setEditable(true);
                descriptorWithFeaturesList.add(descWithFeatures);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Retrieving all Descriptors for the Manager Editor.");
        return descriptorWithFeaturesList;
    }

    @Override
    public void createRestOftheContent() {
        this.logger.debug((Object)"- START : Creating remaining part for the Desciptor page.");
        this.createToolBar(this.leftSideTableViewer, "http://www.grits-toolbox.org/ontology/sample#descriptor");
        this.logger.debug((Object)"- END   : Creating remaining part for the Desciptor page.");
    }

    @Override
    protected Object getInput() {
        return this.inputDescriptors;
    }

    public void refreshPage(Object descWithFeatures) {
    }

    @Override
    protected RightSideSelectionListener getSelectionListener() {
        return new DescriptorSelectionListener(this);
    }

    @Override
    protected void addInputToList(List<ClassesWithFeatures> inputList, int selectionIndex, String label, String uri) {
        this.logger.debug((Object)"- START : Adding input to the Desciptor page.");
        try {
            Descriptor desc = new Descriptor();
            desc.setUri(uri);
            desc.setLabel(label);
            DescriptorWithFeatures descWithFeatures = new DescriptorWithFeatures(desc);
            descWithFeatures.setEditable(true);
            inputList.add(selectionIndex, descWithFeatures);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Adding input to the Desciptor page.");
    }

    @Override
    public void refreshPage() {
        this.leftSideSelection = Math.max(this.leftSideTableViewer.getTable().getSelectionIndex(), 0);
        boolean ascendingOrder = this.sortAlphaNumericAction.getAscending();
        this.sortAlphaNumericAction.setAscending(!ascendingOrder);
        this.inputDescriptors = this.getAllDescriptorWithFeatures();
        this.leftSideTableViewer.setInput(this.inputDescriptors);
        if (this.leftSideTableViewer.getTable().getItemCount() > 0) {
            this.sortAlphaNumericAction.run();
            this.leftSideTableViewer.getTable().select(this.leftSideSelection);
            this.leftSideTableViewer.setSelection(this.leftSideTableViewer.getSelection());
        }
    }
}

