/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.grits.stax;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.systemsbiology.jrap.grits.stax.FileHeaderParser;
import org.systemsbiology.jrap.grits.stax.IndexParser;
import org.systemsbiology.jrap.grits.stax.MLScanAndHeaderParser;
import org.systemsbiology.jrap.grits.stax.MZXMLFileInfo;
import org.systemsbiology.jrap.grits.stax.Scan;
import org.systemsbiology.jrap.grits.stax.ScanAndHeaderParser;

public class MSXMLSequentialParser {
    private String fileName = null;
    private XMLStreamReader xmlSR = null;
    private InputStream inputStr = null;
    private MZXMLFileInfo fileHeader = null;
    private Map<Integer, Long> offsets;
    private int maxScan;
    private long chrogramIndex;
    private boolean isXML = false;
    private boolean isML = false;
    private int currentScan = 0;

    public void open(String fileName) throws FileNotFoundException, XMLStreamException {
        block4: {
            this.fileName = fileName;
            if (fileName.indexOf("mzXML") != -1) {
                this.isXML = true;
            } else {
                this.isML = true;
            }
            IndexParser indexParser = new IndexParser(fileName);
            indexParser.parseIndexes();
            this.offsets = indexParser.getOffsetMap();
            this.maxScan = indexParser.getMaxScan();
            this.chrogramIndex = indexParser.getChrogramIndex();
            this.inputStr = new FileInputStream(fileName);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            this.xmlSR = inputFactory.createXMLStreamReader(this.inputStr);
            try {
                this.readFileHeader(this.xmlSR);
            }
            catch (XMLStreamException e) {
                if (e.getMessage().equals("HeaderEndFoundException")) break block4;
                throw e;
            }
        }
    }

    public void close() {
        if (this.xmlSR != null) {
            try {
                this.xmlSR.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
        if (this.inputStr != null) {
            try {
                this.inputStr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void readFileHeader(XMLStreamReader reader) throws XMLStreamException {
        FileHeaderParser fileHeaderParser = new FileHeaderParser(this.fileName);
        fileHeaderParser.parseFileHeader(reader);
        this.fileHeader = fileHeaderParser.getInfo();
    }

    public MZXMLFileInfo getFileHeader() {
        return this.fileHeader;
    }

    public boolean hasNextScan() {
        return this.currentScan != this.maxScan;
    }

    public Scan getNextScan() throws XMLStreamException {
        MLScanAndHeaderParser scanParser;
        block6: {
            if (this.isXML) {
                ScanAndHeaderParser scanParser2;
                block5: {
                    scanParser2 = new ScanAndHeaderParser();
                    scanParser2.setIsScan(true);
                    try {
                        scanParser2.parseScanAndHeader(this.xmlSR);
                    }
                    catch (XMLStreamException e) {
                        if (e.getMessage().equals("ScanHeaderEndFoundException") || e.getMessage().equals("ScanEndFoundException")) break block5;
                        throw e;
                    }
                }
                this.currentScan = scanParser2.getScan().getHeader().getNum();
                return scanParser2.getScan();
            }
            scanParser = new MLScanAndHeaderParser();
            scanParser.setIsScan(true);
            try {
                scanParser.parseMLScanAndHeader(this.xmlSR);
            }
            catch (XMLStreamException e) {
                if (e.getMessage().equals("ScanHeaderEndFoundException") || e.getMessage().equals("ScanEndFoundException")) break block6;
                throw e;
            }
        }
        this.currentScan = scanParser.getScan().getHeader().getNum();
        return scanParser.getScan();
    }

    public int getScanCount() {
        return this.offsets.size();
    }

    public int getMaxScanNumber() {
        return this.maxScan;
    }
}

