/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.kcf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.io.SugarImporterText;
import org.eurocarbdb.MolecularFramework.io.kcf.KCFBlock;
import org.eurocarbdb.MolecularFramework.io.kcf.KCFLinkage;
import org.eurocarbdb.MolecularFramework.io.kcf.KCFResidue;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class SugarImporterKCF
extends SugarImporterText {
    private String m_strGONumber = "";
    private int m_iResidueCount = 0;
    private int m_iEdgeCount = 0;
    private int m_iBlockCount = 0;
    private HashMap<Integer, KCFResidue> m_hResidues = new HashMap();
    private ArrayList<KCFLinkage> m_aLinkages = new ArrayList();
    private ArrayList<KCFLinkage> m_aHandledLinkages = new ArrayList();
    private ArrayList<KCFBlock> m_aBlock = new ArrayList();
    private char m_cAnomer = (char)32;
    private int m_iLinkagePosition = -1;

    @Override
    public Sugar parse(String a_strStream) throws SugarImporterException {
        this.m_objSugar = new Sugar();
        this.m_iPosition = -1;
        this.m_strText = String.valueOf(a_strStream.replaceAll("\r", "")) + '$';
        this.m_iLength = this.m_strText.length();
        this.nextToken();
        this.start();
        return this.m_objSugar;
    }

    @Override
    protected void start() throws SugarImporterException {
        this.clear();
        if (this.m_cToken == 'E') {
            this.head();
        }
        this.nodes();
        this.edges();
        if (this.m_cToken == 'B') {
            this.bracket();
        }
        if (this.m_cToken != '/') {
            throw new SugarImporterException("KCF000", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '/') {
            throw new SugarImporterException("KCF000", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '/') {
            throw new SugarImporterException("KCF000", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == '\n') {
            this.nextToken();
        }
        if (!this.finished()) {
            throw new SugarImporterException("KCF001", this.m_iPosition);
        }
        this.m_iResidueCount = 0;
        this.m_iEdgeCount = 0;
        this.m_iBlockCount = 0;
        this.m_aHandledLinkages.clear();
        this.createSugar();
        if (this.m_iResidueCount != this.m_hResidues.size()) {
            throw new SugarImporterException("KCF016", this.m_iPosition);
        }
        if (this.m_iEdgeCount != this.m_aLinkages.size()) {
            throw new SugarImporterException("KCF017", this.m_iPosition);
        }
        if (this.m_iBlockCount != this.m_aBlock.size()) {
            throw new SugarImporterException("KCF018", this.m_iPosition);
        }
        Iterator<KCFBlock> t_iterBlock = this.m_aBlock.iterator();
        while (t_iterBlock.hasNext()) {
            if (t_iterBlock.next().getRepeatUnit() == null) continue;
            throw new SugarImporterException("KCF056", this.m_iPosition);
        }
        if (this.m_aBlock.size() > 0) {
            try {
                GlycoVisitorNodeType t_objNodeType = new GlycoVisitorNodeType();
                ArrayList<UnvalidatedGlycoNode> t_aRemove = new ArrayList<UnvalidatedGlycoNode>();
                for (GlycoNode t_objRes : this.m_objSugar.getNodes()) {
                    UnvalidatedGlycoNode t_objNode = t_objNodeType.getUnvalidatedNode(t_objRes);
                    if (t_objNode == null || !t_objNode.getName().trim().equals("*")) continue;
                    if (t_objNode.getParentEdge() != null && t_objNode.getChildEdges().size() > 0) {
                        throw new SugarImporterException("KCF057", this.m_iPosition);
                    }
                    if (t_objNode.getParentEdge() != null && !t_objNodeType.isSugarUnitRepeat(t_objNode.getParentNode())) {
                        throw new SugarImporterException("KCF058", this.m_iPosition);
                    }
                    if (t_objNode.getChildEdges().size() > 0) {
                        if (t_objNode.getChildEdges().size() != 1) {
                            throw new SugarImporterException("KCF059", this.m_iPosition);
                        }
                        for (GlycoEdge t_objEdge : t_objNode.getChildEdges()) {
                            if (t_objNodeType.isSugarUnitRepeat(t_objEdge.getChild())) continue;
                            throw new SugarImporterException("KCF058", this.m_iPosition);
                        }
                    }
                    t_aRemove.add(t_objNode);
                }
                Iterator<GlycoNode> t_iterRes = t_aRemove.iterator();
                while (t_iterRes.hasNext()) {
                    this.m_objSugar.removeNode(t_iterRes.next());
                }
            }
            catch (GlycoVisitorException e) {
                throw new SugarImporterException("COMMON013", this.m_iPosition);
            }
            catch (GlycoconjugateException e) {
                throw new SugarImporterException("COMMON013", this.m_iPosition);
            }
        }
    }

    private void clear() {
        this.m_strGONumber = "";
        this.m_iResidueCount = 0;
        this.m_iEdgeCount = 0;
        this.m_iBlockCount = 0;
        this.m_hResidues.clear();
        this.m_aBlock.clear();
        this.m_aLinkages.clear();
    }

    private void edges() throws SugarImporterException {
        int t_iCounter = 0;
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("KCF023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'D') {
            throw new SugarImporterException("KCF023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'G') {
            throw new SugarImporterException("KCF023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("KCF023", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF024", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        this.m_iEdgeCount = this.number();
        if (this.m_cToken != '\n') {
            throw new SugarImporterException("KCF025", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken != '/' && this.m_cToken != 'B') {
            ++t_iCounter;
            this.edge();
        }
        if (this.m_iEdgeCount != t_iCounter) {
            throw new SugarImporterException("KCF026");
        }
    }

    private void edge() throws SugarImporterException {
        UnvalidatedGlycoNode t_objResidue;
        Integer t_iNodeOne = 0;
        Integer t_iNodeTwo = 0;
        int t_iLinkagePositionOne = -1;
        int t_iLinkagePositionTwo = -1;
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        this.number();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF020", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        t_iNodeOne = this.number();
        if (!this.m_hResidues.containsKey(t_iNodeOne)) {
            throw new SugarImporterException("KCF027", this.m_iPosition);
        }
        if (this.m_cToken == ':') {
            this.nextToken();
            this.link_information();
            t_iLinkagePositionOne = this.m_iLinkagePosition;
            if (this.m_cAnomer != ' ') {
                t_objResidue = this.m_hResidues.get(t_iNodeOne).getResidue();
                try {
                    t_objResidue.setName(String.valueOf(String.format("%c", Character.valueOf(this.m_cAnomer))) + "-" + t_objResidue.getName());
                }
                catch (GlycoconjugateException e) {
                    throw new SugarImporterException("KCF050", this.m_iPosition);
                }
                this.m_cAnomer = (char)32;
            }
        }
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF020", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        t_iNodeTwo = this.number();
        if (!this.m_hResidues.containsKey(t_iNodeTwo)) {
            throw new SugarImporterException("KCF027", this.m_iPosition);
        }
        if (this.m_cToken == ':') {
            this.nextToken();
            this.link_information();
            t_iLinkagePositionTwo = this.m_iLinkagePosition;
            if (this.m_cAnomer != ' ') {
                t_objResidue = this.m_hResidues.get(t_iNodeTwo).getResidue();
                try {
                    t_objResidue.setName(String.valueOf(String.format("%c", Character.valueOf(this.m_cAnomer))) + "-" + t_objResidue.getName());
                }
                catch (GlycoconjugateException e) {
                    throw new SugarImporterException("KCF050", this.m_iPosition);
                }
                this.m_cAnomer = (char)32;
            }
        }
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        if (this.m_cToken != '\n') {
            throw new SugarImporterException("KCF021", this.m_iPosition);
        }
        this.nextToken();
        KCFLinkage t_objKcfLinkage = new KCFLinkage(t_iLinkagePositionOne, t_iLinkagePositionTwo, t_iNodeOne, t_iNodeTwo);
        this.m_aLinkages.add(t_objKcfLinkage);
    }

    private void link_information() throws SugarImporterException {
        char t_iDigit = '\u0000';
        if (this.m_cToken == 'a' || this.m_cToken == 'b') {
            this.m_cAnomer = this.m_cToken;
            this.nextToken();
        } else if (this.m_cToken == '*') {
            this.m_cAnomer = (char)32;
            this.nextToken();
        } else {
            this.m_cAnomer = (char)32;
        }
        t_iDigit = this.m_cToken;
        this.m_iLinkagePosition = t_iDigit > '0' && t_iDigit < ':' ? this.number() : -1;
    }

    private void nodes() throws SugarImporterException {
        if (this.m_cToken != 'N') {
            throw new SugarImporterException("KCF008", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'O') {
            throw new SugarImporterException("KCF008", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'D') {
            throw new SugarImporterException("KCF008", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("KCF008", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF032", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        this.m_iResidueCount = this.number();
        if (this.m_cToken != '\n') {
            throw new SugarImporterException("KCF033", this.m_iPosition);
        }
        this.nextToken();
        this.node();
        while (this.m_cToken != 'E') {
            this.node();
        }
        if (this.m_iResidueCount != this.m_hResidues.size()) {
            throw new SugarImporterException("KCF013");
        }
    }

    private void node() throws SugarImporterException {
        int t_iStart = 0;
        Integer t_iID = 0;
        double t_dX = 0.0;
        double t_dY = 0.0;
        UnvalidatedGlycoNode t_objResidue = new UnvalidatedGlycoNode();
        KCFResidue t_objKCFResidue = new KCFResidue();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        t_iID = this.number();
        if (this.m_hResidues.containsKey(t_iID)) {
            throw new SugarImporterException("KCF014", this.m_iPosition);
        }
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF009", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        t_iStart = this.m_iPosition;
        this.glycan_name();
        try {
            t_objResidue.setName(this.m_strText.substring(t_iStart, this.m_iPosition));
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("KCF050", this.m_iPosition);
        }
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF010", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        t_dX = this.float_number_signed();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF011", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        t_dY = this.float_number_signed();
        if (this.m_cToken != '\n') {
            throw new SugarImporterException("KCF012", this.m_iPosition);
        }
        this.nextToken();
        t_objKCFResidue.init(t_objResidue, t_dX, t_dY, t_iID);
        this.m_hResidues.put(t_iID, t_objKCFResidue);
    }

    private void glycan_name() throws SugarImporterException {
        this.symbol();
        while (this.m_cToken != ' ') {
            this.symbol();
        }
    }

    private void symbol() throws SugarImporterException {
        char t_iDigit = this.m_cToken;
        if (t_iDigit > '/' && t_iDigit < ':') {
            this.nextToken();
        } else if (this.m_cToken == '/' || this.m_cToken == '-' || this.m_cToken == '*' || this.m_cToken == ',') {
            this.nextToken();
        } else if (this.m_cToken == '(' || this.m_cToken == ')') {
            this.nextToken();
        } else {
            this.character();
        }
    }

    private void head() throws SugarImporterException {
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("KCF002", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'N') {
            throw new SugarImporterException("KCF002", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'T') {
            throw new SugarImporterException("KCF002", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'R') {
            throw new SugarImporterException("KCF002", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'Y') {
            throw new SugarImporterException("KCF002", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF003", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        this.go_number();
        if (this.m_cToken != 'G') {
            throw new SugarImporterException("KCF005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'l') {
            throw new SugarImporterException("KCF005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'y') {
            throw new SugarImporterException("KCF005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'c') {
            throw new SugarImporterException("KCF005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'a') {
            throw new SugarImporterException("KCF005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'n') {
            throw new SugarImporterException("KCF005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != '\n') {
            throw new SugarImporterException("KCF006", this.m_iPosition);
        }
        this.nextToken();
    }

    /*
     * Unable to fully structure code
     */
    private void go_number() throws SugarImporterException {
        t_iStart = this.m_iPosition;
        if (!this.matchesGlycan()) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.nextToken();
lbl5:
            // 2 sources

            ** while (this.m_cToken != ' ' && this.m_cToken != '\t')
        }
lbl6:
        // 1 sources

        this.m_strGONumber = this.m_strText.substring(t_iStart, this.m_iPosition);
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF004", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
    }

    private boolean matchesGlycan() throws SugarImporterException {
        if (this.m_cToken != 'G') {
            return false;
        }
        char t_token = this.aheadToken(1);
        if (t_token != 'l' && t_token != 'L') {
            return false;
        }
        t_token = this.aheadToken(2);
        if (t_token != 'y' && t_token != 'Y') {
            return false;
        }
        t_token = this.aheadToken(3);
        if (t_token != 'c' && t_token != 'C') {
            return false;
        }
        t_token = this.aheadToken(4);
        if (t_token != 'a' && t_token != 'A') {
            return false;
        }
        t_token = this.aheadToken(5);
        return t_token == 'n' || t_token == 'N';
    }

    private void bracket() throws SugarImporterException {
        if (this.m_cToken != 'B') {
            throw new SugarImporterException("KCF040", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'R') {
            throw new SugarImporterException("KCF040", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'A') {
            throw new SugarImporterException("KCF040", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'C') {
            throw new SugarImporterException("KCF040", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'K') {
            throw new SugarImporterException("KCF040", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'E') {
            throw new SugarImporterException("KCF040", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken != 'T') {
            throw new SugarImporterException("KCF040", this.m_iPosition);
        }
        this.nextToken();
        KCFBlock t_objBlock = new KCFBlock();
        this.bracket_line(t_objBlock);
        this.bracket_line(t_objBlock);
        this.bracket_final(t_objBlock);
        this.m_aBlock.add(t_objBlock);
        while (this.m_cToken != '/') {
            t_objBlock = new KCFBlock();
            this.bracket_line(t_objBlock);
            this.bracket_line(t_objBlock);
            this.bracket_final(t_objBlock);
            this.m_aBlock.add(t_objBlock);
        }
    }

    private void bracket_line(KCFBlock a_objBlock) throws SugarImporterException {
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        this.number();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF043", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        double t_dCoo1 = this.float_number_signed();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF044", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        double t_dCoo2 = this.float_number_signed();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF044", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        double t_dCoo3 = this.float_number_signed();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF044", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        double t_dCoo4 = this.float_number_signed();
        if (this.m_cToken != '\n') {
            throw new SugarImporterException("KCF045", this.m_iPosition);
        }
        this.nextToken();
        if (t_dCoo1 != t_dCoo3) {
            throw new SugarImporterException("KCF015", this.m_iPosition);
        }
        a_objBlock.setBracket(t_dCoo1, t_dCoo2, t_dCoo4);
    }

    private void bracket_final(KCFBlock a_objBlock) throws SugarImporterException {
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        this.number();
        if (this.m_cToken != ' ') {
            throw new SugarImporterException("KCF046", this.m_iPosition);
        }
        this.nextToken();
        while (this.m_cToken == ' ') {
            this.nextToken();
        }
        if (this.m_cToken == 'n') {
            this.nextToken();
            a_objBlock.setMin(-1);
            a_objBlock.setMax(-1);
        } else if (this.m_cToken == 'm') {
            this.nextToken();
            a_objBlock.setMin(-1);
            a_objBlock.setMax(-1);
        } else {
            this.float_number_signed();
            if (this.m_cToken != ' ') {
                throw new SugarImporterException("KCF047", this.m_iPosition);
            }
            this.nextToken();
            while (this.m_cToken == ' ') {
                this.nextToken();
            }
            this.float_number_signed();
            if (this.m_cToken != ' ') {
                throw new SugarImporterException("KCF047", this.m_iPosition);
            }
            this.nextToken();
            while (this.m_cToken == ' ') {
                this.nextToken();
            }
            if (this.m_cToken == 'n') {
                a_objBlock.setMin(-1);
                a_objBlock.setMax(-1);
                this.nextToken();
                if (this.m_cToken == '-') {
                    this.nextToken();
                    a_objBlock.setMax(this.number());
                }
            } else if (this.m_cToken == 'm') {
                a_objBlock.setMin(-1);
                a_objBlock.setMax(-1);
                this.nextToken();
                if (this.m_cToken == '-') {
                    this.nextToken();
                    a_objBlock.setMax(this.number());
                }
            } else {
                a_objBlock.setMin(this.number());
                a_objBlock.setMax(this.number());
                if (this.m_cToken == '-') {
                    this.nextToken();
                    a_objBlock.setMax(this.number());
                }
            }
        }
        if (this.m_cToken != '\n') {
            throw new SugarImporterException("KCF048", this.m_iPosition);
        }
        this.nextToken();
    }

    public String getGONumber() {
        return this.m_strGONumber;
    }

    private void createSugar() throws SugarImporterException {
        this.m_objSugar = new Sugar();
        KCFResidue t_objResidue = this.findRootResidue();
        if (t_objResidue != null) {
            try {
                this.m_objSugar.addNode(t_objResidue.getResidue());
                ++this.m_iResidueCount;
                this.addChildResidue(t_objResidue, this.m_objSugar);
            }
            catch (GlycoconjugateException e) {
                throw new SugarImporterException("KCF050", this.m_iPosition);
            }
        }
    }

    private KCFResidue findRootResidue() throws SugarImporterException {
        KCFResidue t_objResult = null;
        boolean t_bDouble = false;
        for (KCFResidue t_objElement : this.m_hResidues.values()) {
            if (t_objResult == null) {
                t_objResult = t_objElement;
                continue;
            }
            if (t_objResult.getX() < t_objElement.getX()) {
                t_objResult = t_objElement;
                t_bDouble = false;
                continue;
            }
            if (t_objResult.getX() != t_objElement.getX()) continue;
            KCFLinkage t_objLinkage = this.findLinkage(t_objResult.getId(), t_objElement.getId());
            if (t_objLinkage == null) {
                t_bDouble = true;
                continue;
            }
            Integer t_iFound = this.findRootResidueByLinkage(t_objLinkage);
            if (t_iFound == null) {
                t_bDouble = true;
                continue;
            }
            if (t_objElement.getId() == t_iFound.intValue()) {
                t_objResult = t_objElement;
                continue;
            }
            if (t_objResult.getId() == t_iFound.intValue()) continue;
            t_bDouble = true;
        }
        if (t_bDouble) {
            throw new SugarImporterException("KCF019", this.m_iPosition);
        }
        return t_objResult;
    }

    private Integer findRootResidueByLinkage(KCFLinkage a_objLinkage) {
        Integer t_objResult = null;
        int t_iPositionOne = a_objLinkage.getPositionOne();
        int t_iPositionTwo = a_objLinkage.getPositionTwo();
        if (t_iPositionOne == 1 && t_iPositionTwo == 1) {
            boolean t_bOne = this.hasChilds(a_objLinkage.getResidueOne(), a_objLinkage.getResidueTwo());
            boolean t_bTwo = this.hasChilds(a_objLinkage.getResidueTwo(), a_objLinkage.getResidueOne());
            if (t_bOne && !t_bTwo) {
                t_objResult = a_objLinkage.getResidueTwo();
            } else if (t_bTwo && !t_bOne) {
                t_objResult = a_objLinkage.getResidueOne();
            }
        } else if (t_iPositionOne == 1 || t_iPositionOne == 2 && t_iPositionTwo > 2) {
            t_objResult = a_objLinkage.getResidueTwo();
        } else if (t_iPositionTwo == 1 || t_iPositionTwo == 2 && t_iPositionOne > 2) {
            t_objResult = a_objLinkage.getResidueOne();
        }
        return t_objResult;
    }

    private boolean hasChilds(Integer a_iResidue, Integer a_iResidueExclude) {
        for (KCFLinkage t_objLinkage : this.m_aLinkages) {
            if (!(t_objLinkage.getResidueOne() == a_iResidue.intValue() ? t_objLinkage.getResidueTwo() != a_iResidueExclude.intValue() : t_objLinkage.getResidueTwo() == a_iResidue.intValue() && t_objLinkage.getResidueOne() != a_iResidueExclude.intValue())) continue;
            return true;
        }
        return false;
    }

    private KCFLinkage findLinkage(int a_iIdOne, int a_iIdTwo) throws SugarImporterException {
        KCFLinkage t_objResult = null;
        for (KCFLinkage t_objLinkage : this.m_aLinkages) {
            if (t_objLinkage.getResidueOne() == a_iIdOne && t_objLinkage.getResidueTwo() == a_iIdTwo) {
                if (t_objResult != null) {
                    return null;
                }
                t_objResult = t_objLinkage;
                continue;
            }
            if (t_objLinkage.getResidueOne() != a_iIdTwo || t_objLinkage.getResidueTwo() != a_iIdOne) continue;
            if (t_objResult != null) {
                return null;
            }
            t_objResult = t_objLinkage;
        }
        return t_objResult;
    }

    private void addChildResidue(KCFResidue a_objResidue, GlycoGraph a_objGraph) throws GlycoconjugateException, SugarImporterException {
        int t_iId = a_objResidue.getId();
        for (KCFLinkage t_objLinkage : this.m_aLinkages) {
            KCFBlock t_objBlockOut;
            GlycoEdge t_objEdge;
            KCFResidue t_objResChild;
            if (t_objLinkage.getResidueOne() != t_iId && t_objLinkage.getResidueTwo() != t_iId || this.m_aHandledLinkages.contains(t_objLinkage)) continue;
            if (t_objLinkage.getResidueOne() == t_iId) {
                t_objResChild = this.m_hResidues.get(t_objLinkage.getResidueTwo());
                t_objEdge = t_objLinkage.getEdge(true);
            } else {
                t_objResChild = this.m_hResidues.get(t_objLinkage.getResidueOne());
                t_objEdge = t_objLinkage.getEdge(false);
            }
            KCFBlock t_objBlockIn = this.crossBlockIn(a_objResidue, t_objResChild);
            if (t_objBlockIn == null) {
                t_objBlockOut = this.crossBlockOut(a_objResidue, t_objResChild);
                if (t_objBlockOut == null) {
                    a_objGraph.addNode(t_objResChild.getResidue());
                    ++this.m_iResidueCount;
                    a_objGraph.addEdge(a_objResidue.getResidue(), t_objResChild.getResidue(), t_objEdge);
                    ++this.m_iEdgeCount;
                    this.m_aHandledLinkages.add(t_objLinkage);
                    this.addChildResidue(t_objResChild, a_objGraph);
                    continue;
                }
                if (t_objBlockOut.getRepeatUnit() == null) {
                    throw new SugarImporterException("KCF054", this.m_iPosition);
                }
                GlycoGraph t_objParentGraph = t_objBlockOut.getParentGraph();
                t_objParentGraph.addNode(t_objResChild.getResidue());
                ++this.m_iResidueCount;
                t_objParentGraph.addEdge(t_objBlockOut.getRepeatUnit(), t_objResChild.getResidue(), t_objEdge);
                ++this.m_iEdgeCount;
                this.m_aHandledLinkages.add(t_objLinkage);
                Linkage t_objLinkOut = t_objBlockOut.getRepeatLinkage();
                for (Linkage t_objLink : t_objEdge.getGlycosidicLinkages()) {
                    t_objLinkOut.setParentLinkages(t_objLink.getParentLinkages());
                    t_objLinkOut.setParentLinkageType(t_objLink.getParentLinkageType());
                }
                GlycoEdge t_objInternal = new GlycoEdge();
                t_objInternal.addGlycosidicLinkage(t_objLinkOut);
                t_objBlockOut.getRepeatUnit().setRepeatLinkage(t_objInternal, a_objResidue.getResidue(), t_objBlockOut.getRepeatChild());
                ++this.m_iBlockCount;
                t_objBlockOut.setRepeatUnit(null);
                this.addChildResidue(t_objResChild, t_objParentGraph);
                continue;
            }
            t_objBlockOut = this.crossBlockOut(a_objResidue, t_objResChild);
            if (t_objBlockOut != null) {
                throw new SugarImporterException("KCF052", this.m_iPosition);
            }
            SugarUnitRepeat t_objRepeat = new SugarUnitRepeat();
            t_objBlockIn.setRepeatUnit(t_objRepeat);
            a_objGraph.addNode(t_objRepeat);
            a_objGraph.addEdge(a_objResidue.getResidue(), t_objRepeat, t_objEdge);
            ++this.m_iEdgeCount;
            t_objRepeat.setMaxRepeatCount(t_objBlockIn.getMax());
            t_objRepeat.setMinRepeatCount(t_objBlockIn.getMin());
            if (t_objEdge.getGlycosidicLinkages().size() > 1) {
                throw new SugarImporterException("KCF054", this.m_iPosition);
            }
            Linkage t_objNew = new Linkage();
            for (Linkage t_objLink : t_objEdge.getGlycosidicLinkages()) {
                t_objNew.setChildLinkages(t_objLink.getChildLinkages());
                t_objNew.setChildLinkageType(t_objLink.getChildLinkageType());
            }
            t_objBlockIn.setRepeatLinkage(t_objNew, t_objResChild.getResidue());
            t_objRepeat.addNode(t_objResChild.getResidue());
            ++this.m_iResidueCount;
            t_objBlockIn.setParentGraph(a_objGraph);
            this.m_aHandledLinkages.add(t_objLinkage);
            this.addChildResidue(t_objResChild, t_objRepeat);
        }
    }

    private KCFBlock crossBlockOut(KCFResidue a_objParent, KCFResidue a_objChild) throws SugarImporterException {
        KCFBlock t_objResult = null;
        if (this.m_aBlock.size() == 0) {
            return null;
        }
        double t_dDeltaX = a_objParent.getX() - a_objChild.getX();
        double t_dDelteY = a_objParent.getY() - a_objChild.getY();
        double t_dM = 0.0;
        if (t_dDeltaX != 0.0 && t_dDelteY != 0.0) {
            t_dM = t_dDelteY / t_dDeltaX;
        }
        double t_dY = a_objParent.getY() - t_dM * a_objParent.getX();
        for (KCFBlock t_objBlock : this.m_aBlock) {
            double t_dLeft = t_objBlock.getLeft();
            double t_dRight = t_objBlock.getRight();
            double t_dLeftUp = t_objBlock.getLeftUp();
            double t_dLeftDown = t_objBlock.getLeftDown();
            double t_dWert = 0.0;
            if (t_dLeft > t_dRight) {
                t_dLeft = t_dRight;
                t_dLeftUp = t_objBlock.getRightUp();
                t_dLeftDown = t_objBlock.getRightDown();
            }
            if (t_dLeftUp < t_dLeftDown) {
                t_dWert = t_dLeftUp;
                t_dLeftUp = t_dLeftDown;
                t_dLeftDown = t_dWert;
            }
            if (!(a_objParent.getX() >= t_dLeft) || !(a_objChild.getX() <= t_dLeft) || !(t_dLeftUp >= (t_dWert = t_dM * t_dLeft + t_dY)) || !(t_dWert >= t_dLeftDown)) continue;
            if (t_objResult == null) {
                t_objResult = t_objBlock;
                continue;
            }
            throw new SugarImporterException("KCF051", this.m_iPosition);
        }
        return t_objResult;
    }

    private KCFBlock crossBlockIn(KCFResidue a_objParent, KCFResidue a_objChild) throws SugarImporterException {
        KCFBlock t_objResult = null;
        if (this.m_aBlock.size() == 0) {
            return null;
        }
        double t_dDeltaX = a_objParent.getX() - a_objChild.getX();
        double t_dDelteY = a_objParent.getY() - a_objChild.getY();
        double t_dM = 0.0;
        if (t_dDeltaX != 0.0 && t_dDelteY != 0.0) {
            t_dM = t_dDelteY / t_dDeltaX;
        }
        double t_dY = a_objParent.getY() - t_dM * a_objParent.getX();
        for (KCFBlock t_objBlock : this.m_aBlock) {
            double t_dLeft = t_objBlock.getLeft();
            double t_dRight = t_objBlock.getRight();
            double t_dLeftUp = t_objBlock.getLeftUp();
            double t_dLeftDown = t_objBlock.getLeftDown();
            double t_dWert = 0.0;
            if (t_dLeft < t_dRight) {
                t_dLeft = t_dRight;
                t_dLeftUp = t_objBlock.getRightUp();
                t_dLeftDown = t_objBlock.getRightDown();
            }
            if (t_dLeftUp < t_dLeftDown) {
                t_dWert = t_dLeftUp;
                t_dLeftUp = t_dLeftDown;
                t_dLeftDown = t_dWert;
            }
            if (!(a_objParent.getX() >= t_dLeft) || !(a_objChild.getX() <= t_dLeft) || !(t_dLeftUp >= (t_dWert = t_dM * t_dLeft + t_dY)) || !(t_dWert >= t_dLeftDown)) continue;
            if (t_objResult == null) {
                t_objResult = t_objBlock;
                continue;
            }
            throw new SugarImporterException("KCF051", this.m_iPosition);
        }
        return t_objResult;
    }
}

