/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.adaptor;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.CopyUtils;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;

public class MassSpecExportFileAdapter
extends SelectionAdapter {
    private static final Logger logger = Logger.getLogger(MassSpecExportFileAdapter.class);
    protected Shell shell = null;
    protected String fileName = null;
    protected Entry msEntry = null;
    protected String sOutputFile = null;
    protected boolean copy = true;
    protected MassSpecTableDataObject tableDataObject = null;

    public void widgetSelected(SelectionEvent event) {
        FileDialog dlg = new FileDialog(this.shell, 8192);
        dlg.setFileName(String.valueOf(this.msEntry.getDisplayName()) + this.fileName);
        dlg.setFilterPath(null);
        dlg.setText("Directory Explorer");
        this.sOutputFile = dlg.open();
        try {
            if (this.sOutputFile != null) {
                PropertyHandler.getVariable((String)"workspace_location");
                DataModelSearch.findParentByType((Entry)this.msEntry, (String)"org.grits.toolbox.property.project").getDisplayName();
                MassSpecEntityProperty mseproperty = (MassSpecEntityProperty)this.msEntry.getProperty();
                MassSpecProperty property = mseproperty.getMassSpecParentProperty();
                if (this.copy) {
                    String from = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(this.msEntry)) + File.separator + this.fileName;
                    CopyUtils.copyFilesFromTo((String)from, (String)this.sOutputFile);
                } else {
                    this.exportExcel();
                }
            }
        }
        catch (NullPointerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to save file", (Exception)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to save file", (Exception)e);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to save file", (Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to save file", (Exception)e);
        }
    }

    protected void exportExcel() throws IOException, Exception {
        new ProgressDialog(this.shell);
    }

    public MassSpecTableDataObject getTableDataObject() {
        return this.tableDataObject;
    }

    public void setTableDataObject(MassSpecTableDataObject tableDataObject) {
        this.tableDataObject = tableDataObject;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void setMassSpecEntry(Entry msEntry) {
        this.msEntry = msEntry;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDir() {
        return this.sOutputFile;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }
}

