/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.handler;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.ICancelableEditor;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;

public class ViewMSGlycanAnnotationReportResults {
    public static final String VIEW_ID = "plugin.report.ms.merge.views.MSAnnotationMergeResultsView";
    private static final Logger logger = Logger.getLogger(ViewMSGlycanAnnotationReportResults.class);
    @Inject
    static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;
    @Inject
    EPartService partService;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object, @Named(value="activeShell") @Named(value="activeShell") Shell shell) {
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        this.showPlugInView(shell, selectedEntry);
    }

    private void showPlugInView(Shell shell, Entry entry) {
        block4: {
            if (entry != null) {
                MPart part = null;
                try {
                    part = gritsUIService.openEntryInPart(entry);
                    if (part != null && part.getObject() != null && part.getObject() instanceof ICancelableEditor && ((ICancelableEditor)part.getObject()).isCanceled()) {
                        this.partService.hidePart(part, true);
                    }
                }
                catch (Exception e) {
                    Exception pie = new Exception("There was an error converting the XML to a table.", e);
                    logger.error((Object)pie.getMessage(), (Throwable)pie);
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Unable to open the results viewer", (Exception)pie);
                    if (part == null) break block4;
                    this.partService.hidePart(part, true);
                }
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") Object object) {
        Entry entry = null;
        if (object instanceof Entry) {
            entry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            entry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (entry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            entry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        return entry != null && entry.getProperty().getType().equals("org.grits.toolbox.property.report.ms_annotation_merge");
    }
}

