/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.exchange;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.glycoinfo.WURCSFramework.util.WURCSDataConverter;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparator;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverser;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverserTree;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectConnectingBackboneGroups;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectSequence;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIP;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.LIP;
import org.glycoinfo.WURCSFramework.wurcs.array.LIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;
import org.glycoinfo.WURCSFramework.wurcs.array.RES;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.ModificationAlternative;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WURCSGraphToArray
implements WURCSVisitor {
    private static final Logger logger = LoggerFactory.getLogger(WURCSGraphToArray.class);
    private String m_strVersion = "2.0";
    private LinkedList<Backbone> m_aBackbones;
    private LinkedList<Modification> m_aGlycosidicModifications;
    private LinkedList<ModificationAlternative> m_aGlycosidicModificationAlternatives;
    private WURCSArray m_oWURCS = null;
    private boolean m_bIsComposition = false;
    private LinkedList<String> m_aURESString;
    private LinkedList<UniqueRES> m_aURES;
    private LinkedList<RES> m_aRES;
    private LinkedList<LIN> m_aLIN;
    private static WURCSEdgeComparator oEdgeComp = new WURCSEdgeComparator();
    private static WURCSExporter oExporter = new WURCSExporter();
    private Map<Backbone, UniqueRES> m_mapBackboneToURES;
    private Map<Backbone, RES> m_mapBackboneToRES;
    private Map<Modification, MOD> m_mapModificationToMOD;
    private Map<Modification, LIN> m_mapModificationToLIN;

    public WURCSGraphToArray() {
        this.clear();
    }

    public WURCSArray getWURCSArray() {
        return this.m_oWURCS;
    }

    public UniqueRES getUniqueRES(Backbone a_objBackbone) {
        return this.m_mapBackboneToURES.get(a_objBackbone);
    }

    public RES getRES(Backbone a_objBackbone) {
        return this.m_mapBackboneToRES.get(a_objBackbone);
    }

    public MOD getMOD(Modification a_objModification) {
        return this.m_mapModificationToMOD.get(a_objModification);
    }

    public LIN getLIN(Modification a_objModification) {
        return this.m_mapModificationToLIN.get(a_objModification);
    }

    public LinkedList<Backbone> getG2ABackbones() {
        return this.m_aBackbones;
    }

    public LinkedList<Modification> getG2AModifications() {
        return this.m_aGlycosidicModifications;
    }

    public LinkedList<ModificationAlternative> getG2AModificationAlternatives() {
        return this.m_aGlycosidicModificationAlternatives;
    }

    @Override
    public void visit(Backbone a_objBackbone) throws WURCSVisitorException {
        if (this.m_aBackbones.contains(a_objBackbone)) {
            return;
        }
        this.m_aBackbones.addLast(a_objBackbone);
        UniqueRES t_oURESCandidate = this.makeUniqueRES(this.m_aURES.size() + 1, a_objBackbone);
        logger.debug("candidate UniqueRES: {}", (Object)oExporter.getUniqueRESString(t_oURESCandidate));
        String t_strNewURES = oExporter.getUniqueRESString(t_oURESCandidate);
        if (!this.m_aURESString.contains(t_strNewURES)) {
            this.m_aURESString.addLast(t_strNewURES);
            this.m_aURES.addLast(t_oURESCandidate);
        }
        int t_iURESID = this.m_aURESString.indexOf(t_strNewURES) + 1;
        String t_strRESIndex = WURCSDataConverter.convertRESIDToIndex(this.m_aBackbones.size());
        RES t_oRES = new RES(t_iURESID, t_strRESIndex);
        this.m_aRES.addLast(t_oRES);
        this.m_mapBackboneToRES.put(a_objBackbone, t_oRES);
        this.m_mapBackboneToURES.put(a_objBackbone, this.m_aURES.get(t_iURESID - 1));
    }

    @Override
    public void visit(Modification a_objModification) throws WURCSVisitorException {
        if (a_objModification instanceof ModificationAlternative) {
            this.visit((ModificationAlternative)a_objModification);
            return;
        }
        if (!a_objModification.isGlycosidic()) {
            return;
        }
        if (this.m_aGlycosidicModifications.contains(a_objModification)) {
            return;
        }
        this.m_aGlycosidicModifications.addLast(a_objModification);
    }

    private void visit(ModificationAlternative a_objModificationAlternative) throws WURCSVisitorException {
        if (!a_objModificationAlternative.isGlycosidic()) {
            throw new WURCSVisitorException("ModificationAlternative must be Glycosidic linkage.");
        }
        if (this.m_aGlycosidicModificationAlternatives.contains(a_objModificationAlternative)) {
            return;
        }
        this.m_aGlycosidicModificationAlternatives.addLast(a_objModificationAlternative);
    }

    @Override
    public void visit(WURCSEdge a_objWURCSEdge) throws WURCSVisitorException {
    }

    @Override
    public void start(WURCSGraph a_objGraph) throws WURCSVisitorException {
        this.clear();
        WURCSVisitorCollectSequence t_oSeq = new WURCSVisitorCollectSequence();
        t_oSeq.start(a_objGraph);
        for (WURCSComponent t_oNode : t_oSeq.getNodes()) {
            t_oNode.accept(this);
        }
        for (Modification t_oMod : t_oSeq.getLeafModifications()) {
            t_oMod.accept(this);
        }
        for (Modification t_oMod : t_oSeq.getRepeatModifications()) {
            t_oMod.accept(this);
        }
        WURCSVisitorCollectConnectingBackboneGroups t_oGroup = new WURCSVisitorCollectConnectingBackboneGroups();
        t_oGroup.start(a_objGraph);
        if (t_oGroup.getBackboneGroups().size() > 1) {
            this.m_bIsComposition = true;
        }
        this.makeWURCSArray();
    }

    @Override
    public WURCSGraphTraverser getTraverser(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        return new WURCSGraphTraverserTree(a_objVisitor);
    }

    @Override
    public void clear() {
        this.m_aBackbones = new LinkedList();
        this.m_aGlycosidicModifications = new LinkedList();
        this.m_aGlycosidicModificationAlternatives = new LinkedList();
        this.m_strVersion = "2.0";
        this.m_aURESString = new LinkedList();
        this.m_aURES = new LinkedList();
        this.m_aRES = new LinkedList();
        this.m_aLIN = new LinkedList();
        this.m_mapBackboneToRES = new HashMap<Backbone, RES>();
        this.m_mapBackboneToURES = new HashMap<Backbone, UniqueRES>();
        this.m_mapModificationToMOD = new HashMap<Modification, MOD>();
        this.m_mapModificationToLIN = new HashMap<Modification, LIN>();
    }

    private void makeWURCSArray() {
        LIN t_oLIN;
        for (Modification modification : this.m_aGlycosidicModifications) {
            t_oLIN = this.makeLIN(modification);
            this.m_mapModificationToLIN.put(modification, t_oLIN);
            this.m_aLIN.addLast(t_oLIN);
        }
        for (ModificationAlternative modificationAlternative : this.m_aGlycosidicModificationAlternatives) {
            t_oLIN = this.makeLIN(modificationAlternative);
            this.m_mapModificationToLIN.put(modificationAlternative, t_oLIN);
            this.m_aLIN.addLast(t_oLIN);
        }
        this.m_oWURCS = new WURCSArray(this.m_strVersion, this.m_aURES.size(), this.m_aRES.size(), this.m_aLIN.size(), this.m_bIsComposition);
        for (UniqueRES uniqueRES : this.m_aURES) {
            this.m_oWURCS.addUniqueRES(uniqueRES);
        }
        for (RES rES : this.m_aRES) {
            this.m_oWURCS.addRES(rES);
        }
        for (LIN lIN : this.m_aLIN) {
            this.m_oWURCS.addLIN(lIN);
        }
    }

    private UniqueRES makeUniqueRES(int a_iID, Backbone a_objBackbone) {
        MS t_oMS = this.makeMS(a_objBackbone);
        return new UniqueRES(a_iID, t_oMS);
    }

    private MS makeMS(Backbone a_objBackbone) {
        MS t_oMS = new MS(a_objBackbone.getSkeletonCode(), a_objBackbone.getAnomericPosition(), a_objBackbone.getAnomericSymbol());
        LinkedList<MOD> t_aMODsCandidate = new LinkedList<MOD>();
        HashSet<Modification> searchedMods = new HashSet<Modification>();
        LinkedList<WURCSEdge> edges = a_objBackbone.getEdges();
        Collections.sort(edges, oEdgeComp);
        for (WURCSEdge t_oMODEdge : edges) {
            Modification t_oModif = t_oMODEdge.getModification();
            if (searchedMods.contains(t_oModif) || t_oModif.isGlycosidic()) continue;
            if (t_oModif instanceof InterfaceRepeat) {
                if (this.m_aGlycosidicModifications.contains(t_oModif)) continue;
                this.m_aGlycosidicModifications.add(t_oModif);
                continue;
            }
            searchedMods.add(t_oModif);
            MOD t_oMOD = WURCSGraphToArray.makeMOD(t_oModif);
            if (t_oMOD == null) continue;
            this.m_mapModificationToMOD.put(t_oModif, t_oMOD);
            t_aMODsCandidate.add(t_oMOD);
            if (!t_oMODEdge.isReverse()) continue;
            logger.debug("has parent");
        }
        LinkedList<MOD> t_aMODsForAdd = new LinkedList<MOD>();
        HashMap t_mapPosToMODs = new HashMap();
        for (MOD t_oMOD : t_aMODsCandidate) {
            if (a_objBackbone.hasUnknownLength()) {
                t_aMODsForAdd.add(t_oMOD);
                continue;
            }
            if (t_oMOD.getListOfLIPs().size() != 1 || t_oMOD.getListOfLIPs().getFirst().getLIPs().size() != 1) {
                t_aMODsForAdd.add(t_oMOD);
                continue;
            }
            int pos = t_oMOD.getListOfLIPs().getFirst().getLIPs().getFirst().getBackbonePosition();
            if (pos == -1) {
                t_aMODsForAdd.add(t_oMOD);
                continue;
            }
            if (!t_mapPosToMODs.containsKey(pos)) {
                t_mapPosToMODs.put(pos, new LinkedList());
            }
            ((LinkedList)t_mapPosToMODs.get(pos)).add(t_oMOD);
        }
        for (Integer pos : t_mapPosToMODs.keySet()) {
            LinkedList t_aMODs = (LinkedList)t_mapPosToMODs.get(pos);
            LinkedList<String> t_aMAPs = new LinkedList<String>();
            for (MOD t_oMOD : t_aMODs) {
                t_aMAPs.add(t_oMOD.getMAPCode());
            }
            if (t_aMAPs.size() == 1 && t_aMAPs.contains("*O") || t_aMAPs.size() == 2 && t_aMAPs.contains("*O") && t_aMAPs.contains("*=O")) continue;
            t_aMODsForAdd.addAll(t_aMODs);
        }
        for (MOD t_oMOD : t_aMODsForAdd) {
            if (t_oMOD.getMAPCode().equals("*O") || t_oMOD.getMAPCode().equals("*=O")) continue;
            t_oMS.addMOD(t_oMOD);
        }
        return t_oMS;
    }

    private static MOD makeMOD(Modification a_oMod) {
        String t_strMAP = a_oMod.getMAPCode();
        if (t_strMAP.equals("*O*")) {
            t_strMAP = "";
        }
        MOD t_oMOD = new MOD(t_strMAP);
        LinkedList<WURCSEdge> edges = a_oMod.getEdges();
        Collections.sort(edges, oEdgeComp);
        for (WURCSEdge t_oMODEdge : edges) {
            t_oMOD.addLIPs(WURCSGraphToArray.makeLIPs(t_oMODEdge));
        }
        return t_oMOD;
    }

    private static LIPs makeLIPs(WURCSEdge a_oEdge) {
        boolean t_bCanOmitModif = a_oEdge.getModification().canOmitMAP();
        LinkedList<LIP> t_aLIPs = new LinkedList<LIP>();
        for (LinkagePosition t_oLinkPos : a_oEdge.getLinkages()) {
            boolean t_bOmitDirection = t_oLinkPos.canOmitDirection();
            if (a_oEdge.getBackbone().getAnomericPosition() == t_oLinkPos.getBackbonePosition()) {
                t_bOmitDirection = true;
            }
            LIP t_oLIP = new LIP(t_oLinkPos.getBackbonePosition(), t_oLinkPos.canOmitModificationPosition() && t_bOmitDirection ? (char)' ' : (char)t_oLinkPos.getDirection().getName(), t_bCanOmitModif || t_oLinkPos.canOmitModificationPosition() ? 0 : t_oLinkPos.getModificationPosition());
            if (t_oLinkPos.getProbabilityLower() != 1.0 || t_oLinkPos.getProbabilityUpper() != 1.0) {
                if (t_oLinkPos.getProbabilityPosition() == 1) {
                    t_oLIP.setBackboneProbabilityLower(t_oLinkPos.getProbabilityLower());
                    t_oLIP.setBackboneProbabilityUpper(t_oLinkPos.getProbabilityUpper());
                }
                if (t_oLinkPos.getProbabilityPosition() == 2) {
                    t_oLIP.setModificationProbabilityLower(t_oLinkPos.getProbabilityLower());
                    t_oLIP.setModificationProbabilityUpper(t_oLinkPos.getProbabilityUpper());
                }
            }
            t_aLIPs.addLast(t_oLIP);
        }
        return new LIPs(t_aLIPs);
    }

    private LIN makeLIN(ModificationAlternative a_oMod) {
        String t_strMAP = a_oMod.getMAPCode();
        if (t_strMAP.equals("*O*")) {
            t_strMAP = "";
        }
        LIN t_oLIN = new LIN(t_strMAP);
        if (!a_oMod.getLeadInEdges().isEmpty()) {
            t_oLIN.addGLIPs(this.makeGLIPs(a_oMod.getLeadInEdges(), "}"));
        }
        if (!a_oMod.getLeadOutEdges().isEmpty()) {
            t_oLIN.addGLIPs(this.makeGLIPs(a_oMod.getLeadOutEdges(), "{"));
        }
        LinkedList<WURCSEdge> edges = a_oMod.getEdges();
        Collections.sort(edges, oEdgeComp);
        for (WURCSEdge t_oEdge : edges) {
            if (a_oMod.getLeadInEdges().contains(t_oEdge) || a_oMod.getLeadOutEdges().contains(t_oEdge)) continue;
            t_oLIN.addGLIPs(this.makeGLIPs(t_oEdge));
        }
        this.setRepeat(a_oMod, t_oLIN);
        return t_oLIN;
    }

    private LIN makeLIN(Modification a_oMod) {
        String t_strMAP = a_oMod.getMAPCode();
        if (t_strMAP.equals("*O*")) {
            t_strMAP = "";
        }
        LIN t_oLIN = new LIN(t_strMAP);
        LinkedList<WURCSEdge> edges = a_oMod.getEdges();
        Collections.sort(edges, oEdgeComp);
        for (WURCSEdge t_oEdge : edges) {
            t_oLIN.addGLIPs(this.makeGLIPs(t_oEdge));
        }
        this.setRepeat(a_oMod, t_oLIN);
        return t_oLIN;
    }

    private void setRepeat(Modification a_oMod, LIN a_oLIN) {
        if (!(a_oMod instanceof InterfaceRepeat)) {
            return;
        }
        InterfaceRepeat t_oModRep = (InterfaceRepeat)((Object)a_oMod);
        a_oLIN.setRepeatingUnit(true);
        a_oLIN.setMinRepeatCount(t_oModRep.getMinRepeatCount());
        a_oLIN.setMaxRepeatCount(t_oModRep.getMaxRepeatCount());
    }

    private GLIPs makeGLIPs(LinkedList<WURCSEdge> a_aEdges, String a_strAlternativeType) {
        Collections.sort(a_aEdges, oEdgeComp);
        LinkedList<GLIP> t_aGLIPs = new LinkedList<GLIP>();
        for (WURCSEdge t_oEdge : a_aEdges) {
            t_aGLIPs.addAll(this.makeGLIPs(t_oEdge).getGLIPs());
        }
        GLIPs t_oGLIPs = new GLIPs(t_aGLIPs);
        t_oGLIPs.setAlternative(a_strAlternativeType);
        return t_oGLIPs;
    }

    private GLIPs makeGLIPs(WURCSEdge a_oEdge) {
        Backbone backbone = a_oEdge.getBackbone();
        int t_iRES = this.m_aBackbones.indexOf(backbone) + 1;
        String t_strRESIndex = WURCSDataConverter.convertRESIDToIndex(t_iRES);
        LinkedList<GLIP> t_aGLIPs = new LinkedList<GLIP>();
        for (LinkagePosition t_oLinkPos : a_oEdge.getLinkages()) {
            GLIP t_oGLIP = this.makeGLIP(t_strRESIndex, t_oLinkPos, a_oEdge.getModification().canOmitMAP());
            t_aGLIPs.addLast(t_oGLIP);
        }
        return new GLIPs(t_aGLIPs);
    }

    private GLIP makeGLIP(String a_strRESIndex, LinkagePosition a_oLinkPos, boolean a_bOmitModif) {
        GLIP t_oGLIP = new GLIP(a_strRESIndex, a_oLinkPos.getBackbonePosition(), (a_bOmitModif || a_oLinkPos.canOmitModificationPosition()) && a_oLinkPos.canOmitDirection() ? (char)' ' : (char)a_oLinkPos.getDirection().getName(), a_bOmitModif || a_oLinkPos.canOmitModificationPosition() ? 0 : a_oLinkPos.getModificationPosition());
        if (a_oLinkPos.getProbabilityLower() != 1.0 || a_oLinkPos.getProbabilityUpper() != 1.0) {
            if (a_oLinkPos.getProbabilityPosition() == 1) {
                t_oGLIP.setBackboneProbabilityLower(a_oLinkPos.getProbabilityLower());
                t_oGLIP.setBackboneProbabilityUpper(a_oLinkPos.getProbabilityUpper());
            }
            if (a_oLinkPos.getProbabilityPosition() == 2) {
                t_oGLIP.setModificationProbabilityLower(a_oLinkPos.getProbabilityLower());
                t_oGLIP.setModificationProbabilityUpper(a_oLinkPos.getProbabilityUpper());
            }
        }
        return t_oGLIP;
    }
}

