/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.validator;

import java.util.ArrayList;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.GLYCAMSubstituent;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.ThreeLetterCodeConverter;
import org.glycoinfo.GlycanFormatconverter.util.validator.TextValidator;

public class GLYCAMValidator
implements TextValidator {
    public void validateGLYCAM(GlyContainer _glyCo) throws GlycanException {
        if (_glyCo.isComposition()) {
            throw new GlycanException("GLYCAM format can not support monosaccharide compositions.");
        }
        if (!_glyCo.getUndefinedUnit().isEmpty()) {
            throw new GlycanException("GLYCAM format can not support glycan fragments.");
        }
        for (Edge edge : _glyCo.getEdges()) {
            this.checkForRepeat(edge);
            this.checkForUnknownLinkages(edge);
            this.checkForProbability(edge);
            this.checkForSubstituents(edge);
            this.checkForBridgeSubstituent(edge);
        }
        if (!_glyCo.isComposition()) {
            this.checkForRoot(_glyCo.getAllNodes());
        }
        for (Node node : _glyCo.getAllNodes()) {
            this.checkForMonosaccharide(node);
            this.checkForGeneric(node);
            this.checkForStereos(node);
            this.checkForAnomericity(node);
            this.checkForAnomericPosition(node);
            this.checkForIsomer(node);
            this.checkForRingSize(node);
            this.checkForModifications(node);
        }
    }

    @Override
    public void checkForRoot(ArrayList<Node> _nodes) throws GlycanException {
        int count = 0;
        for (Node node : _nodes) {
            if (!node.getParentEdges().isEmpty()) continue;
            ++count;
        }
        if (count > 1) {
            throw new GlycanException("GLYCAM format can not handle multiple root glycan.");
        }
    }

    @Override
    public void checkForRepeat(Edge _edge) throws GlycanException {
        if (_edge.getSubstituent() == null) {
            return;
        }
        Substituent repMod = (Substituent)_edge.getSubstituent();
        if (!(repMod instanceof GlycanRepeatModification)) {
            return;
        }
        throw new GlycanException("GLYCAM format can not support repeating unit.");
    }

    @Override
    public void checkForUnknownLinkages(Edge _edge) throws GlycanException {
        for (Linkage linkage : _edge.getGlycosidicLinkages()) {
            if (linkage.getParentLinkages().contains(-1)) {
                throw new GlycanException("GLYCAM format can not support unknown linkage positions.");
            }
            if (!linkage.getChildLinkages().contains(-1)) continue;
            throw new GlycanException("GLYCAM format can not support unknown linkage positions.");
        }
    }

    @Override
    public void checkForLinkagePositions(Edge _edge) throws GlycanException {
    }

    @Override
    public void checkForProbability(Edge _edge) throws GlycanException {
        for (Linkage linkage : _edge.getGlycosidicLinkages()) {
            if (linkage.getChildProbabilityLower() != 1.0) {
                throw new GlycanException("GLYCAM format can not support probability annotation.");
            }
            if (linkage.getChildProbabilityUpper() == 1.0) continue;
            throw new GlycanException("GLYCAM format can not support probability annotation.");
        }
    }

    @Override
    public void checkForBridgeSubstituent(Edge _edge) throws GlycanException {
        if (_edge.getSubstituent() == null) {
            return;
        }
        Substituent bridge = (Substituent)_edge.getSubstituent();
        if (bridge.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            throw new GlycanException("GLYCAM format can not support cross-linked substituent.");
        }
    }

    @Override
    public void checkForMonosaccharide(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getSuperClass().equals((Object)SuperClass.SUG)) {
            throw new GlycanException("GLYCAM format can not handle \"Sugar\".");
        }
    }

    @Override
    public void checkForGeneric(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getStereos().isEmpty()) {
            throw new GlycanException("GLYCAM format can not handle generic type monosaccharide.");
        }
    }

    @Override
    public void checkForStereos(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (this.hasTrivialName(_node)) {
            return;
        }
        if (mono.getStereos().size() > 1) {
            throw new GlycanException("GLYCAM format can not handle monosaccharides with multiple stem types.");
        }
    }

    @Override
    public void checkForAnomericity(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN)) {
            throw new GlycanException("GLYCAM format can not handle anomericity other than \u03b1 or \u03b2");
        }
        if (mono.getAnomer().equals((Object)AnomericStateDescriptor.UNKNOWN_STATE)) {
            throw new GlycanException("GLYCAM format can not handle anomericity other than \u03b1 or \u03b2");
        }
        if (mono.getAnomer().equals((Object)AnomericStateDescriptor.UNKNOWN)) {
            throw new GlycanException("GLYCAM format can not handle anomericity other than \u03b1 or \u03b2");
        }
        if (mono.getAnomericPosition() == -1) {
            return;
        }
        if (mono.getAnomericPosition() == 3) {
            throw new GlycanException("IUPAC-Extended format can not handle an anomeric position : " + mono.getAnomericPosition());
        }
        ThreeLetterCodeConverter threeConv = new ThreeLetterCodeConverter();
        threeConv.start(_node.copy());
        String trivialName = threeConv.getThreeLetterCode();
        if (trivialName.equals("")) {
            return;
        }
        MonosaccharideIndex mi = MonosaccharideIndex.forTrivialNameWithIgnore(trivialName);
        if (mi == null) {
            return;
        }
        if (mi.getAnomerciPosition() == 2 && mono.getAnomericPosition() == 1) {
            throw new GlycanException("The anomeric position of this monosaccharide differs from the stem type.");
        }
        if (mi.getAnomerciPosition() == 1 && mono.getAnomericPosition() == 2) {
            throw new GlycanException("The anomeric position of this monosaccharide differs from the stem type.");
        }
    }

    @Override
    public void checkForAnomericPosition(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getAnomericPosition() == -1) {
            return;
        }
        if (mono.getAnomericPosition() == 3) {
            throw new GlycanException("IUPAC-Extended format can not handle an anomeric position : " + mono.getAnomericPosition());
        }
        ThreeLetterCodeConverter threeConv = new ThreeLetterCodeConverter();
        threeConv.start(_node.copy());
        String trivialName = threeConv.getThreeLetterCode();
        if (trivialName.equals("")) {
            return;
        }
        MonosaccharideIndex mi = MonosaccharideIndex.forTrivialNameWithIgnore(trivialName);
        if (mi == null) {
            return;
        }
        if (mi.getAnomerciPosition() == 2 && mono.getAnomericPosition() == 1) {
            throw new GlycanException("The anomeric position of this monosaccharide differs from the stem type.");
        }
        if (mi.getAnomerciPosition() == 1 && mono.getAnomericPosition() == 2) {
            throw new GlycanException("The anomeric position of this monosaccharide differs from the stem type.");
        }
    }

    @Override
    public void checkForIsomer(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        for (String stereo : mono.getStereos()) {
            if (stereo.startsWith("d") || stereo.startsWith("l")) continue;
            throw new GlycanException("GLYCAM format can not handle isomer other than D or L.");
        }
    }

    @Override
    public void checkForRingSize(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getRingStart() == -1 || mono.getRingStart() == 0) {
            throw new GlycanException("GLYCAM format can not handle ring size other than p or f.");
        }
        if (mono.getRingEnd() == -1 || mono.getRingEnd() == 0) {
            throw new GlycanException("GLYCAM format can not handle ring size other than p or f.");
        }
    }

    @Override
    public void checkForSubstituents(Edge _edge) throws GlycanException {
        if (_edge.getSubstituent() == null) {
            return;
        }
        Substituent sub = (Substituent)_edge.getSubstituent();
        if (sub instanceof GlycanRepeatModification) {
            return;
        }
        if (sub.getSubstituent() instanceof BaseCrossLinkedTemplate) {
            return;
        }
        if (this.hasTrivialName(_edge.getParent())) {
            return;
        }
        if (_edge.getGlycosidicLinkages().size() > 1) {
            throw new GlycanException("GLYCAM format can not handle cyclic substituent");
        }
        for (Linkage linkage : _edge.getGlycosidicLinkages()) {
            if (linkage.getParentLinkages().size() > 1) {
                throw new GlycanException("GLYCAM format can not handle fuzzy linkage.");
            }
            if (!linkage.getParentLinkages().contains(-1)) continue;
            throw new GlycanException("GLYCAM format can not handle unknown linkage.");
        }
        GLYCAMSubstituent enumGLYCAMsub = GLYCAMSubstituent.forNotation(sub.getNameWithIUPAC());
        if (enumGLYCAMsub == null) {
            throw new GlycanException("GLYCAM format can not handle this substituent : " + sub.getSubstituent());
        }
    }

    @Override
    public void checkForModifications(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        if (this.hasTrivialName(_node)) {
            return;
        }
        for (GlyCoModification gMod : mono.getModifications()) {
            GLYCAMSubstituent enumGLYCAMsub = GLYCAMSubstituent.forNotation(String.valueOf(gMod.getModificationTemplate().getCarbon()));
            if (mono.getSuperClass().getSize() == gMod.getPositionOne().intValue() || enumGLYCAMsub != null) continue;
            throw new GlycanException("GLYCAM format can not handle this modification : " + gMod.getModificationTemplate().getCarbon());
        }
    }

    @Override
    public boolean hasTrivialName(Node _node) throws GlycanException {
        ThreeLetterCodeConverter threeConv = new ThreeLetterCodeConverter();
        threeConv.start(_node.copy());
        return !threeConv.getThreeLetterCode().equals("");
    }
}

