/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.SugarToWURCSGraph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeMap;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.util.exchange.SugarToWURCSGraph.BaseTypeForRelativeConfiguration;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSExchangeException;

public class MonosaccharideAnalyzer {
    private Monosaccharide m_oMS = null;
    private boolean m_bIsAldose = true;
    private int m_iAnomPos = 0;
    private char m_cAnomSymbol;
    private int m_nCAtom = 0;
    private char m_cConfigurationalSymbol;
    private String m_strSkeletonCode = "";
    private LinkedList<Integer> m_aAnomPositions;
    private TreeMap<Integer, Character> m_hashPosToChar = new TreeMap();
    private LinkedList<String> m_aUnknownPosMAP;

    public MonosaccharideAnalyzer() {
        this.m_cAnomSymbol = (char)120;
        this.m_cConfigurationalSymbol = (char)88;
        this.m_aUnknownPosMAP = new LinkedList();
        this.m_aAnomPositions = new LinkedList();
    }

    public int getAnomericPosition() {
        return this.m_iAnomPos;
    }

    public char getAnomericSymbol() {
        return this.m_cAnomSymbol;
    }

    public char getConfigurationalSymbol() {
        return this.m_cConfigurationalSymbol;
    }

    public int getNumberOfCarbons() {
        return this.m_nCAtom;
    }

    public String getSkeletonCode() {
        return this.m_strSkeletonCode;
    }

    public LinkedList<String> getCoreModificationUnknownPosition() {
        return this.m_aUnknownPosMAP;
    }

    public boolean isAldose() {
        return this.m_bIsAldose;
    }

    public void analyze(Monosaccharide a_oMS) throws WURCSExchangeException {
        int i;
        this.m_oMS = a_oMS;
        this.m_iAnomPos = a_oMS.getRingStart();
        this.m_cAnomSymbol = a_oMS.getAnomer().getSymbol().charAt(0);
        if (this.m_iAnomPos == 0) {
            this.m_cAnomSymbol = (char)111;
        }
        if (this.m_cAnomSymbol == 'o') {
            this.m_iAnomPos = 0;
        }
        this.m_nCAtom = a_oMS.getSuperclass().getCAtomCount();
        this.m_hashPosToChar.put(1, Character.valueOf('h'));
        this.m_hashPosToChar.put(this.m_nCAtom, Character.valueOf('h'));
        LinkedList<Modification> t_aEnMods = new LinkedList<Modification>();
        for (Modification t_oMod : this.m_oMS.getModification()) {
            ModificationType t_oType = t_oMod.getModificationType();
            if (t_oMod.hasPositionTwo()) {
                if (t_oType != ModificationType.DOUBLEBOND && t_oType != ModificationType.UNKNOWN_DOUBLEBOND) continue;
                t_aEnMods.add(t_oMod);
                continue;
            }
            this.convertSingleModificationToCarbonDescriptor(t_oMod);
        }
        if (!this.m_aAnomPositions.isEmpty() && this.m_aAnomPositions.getFirst() != 1) {
            this.m_bIsAldose = false;
        }
        if (this.m_bIsAldose) {
            this.m_hashPosToChar.put(1, Character.valueOf('o'));
            this.m_aAnomPositions.addFirst(1);
        }
        if (this.m_aAnomPositions.isEmpty()) {
            this.m_iAnomPos = 0;
            this.m_cAnomSymbol = (char)111;
        }
        if (this.m_iAnomPos != 0 && this.m_iAnomPos != -1) {
            if (!this.m_hashPosToChar.containsKey(this.m_iAnomPos)) {
                throw new WURCSExchangeException("Illegal structure is found at ring start position.");
            }
            char t_cCD = this.m_hashPosToChar.get(this.m_iAnomPos).charValue();
            if (t_cCD == 'o' || t_cCD == 'O') {
                this.m_hashPosToChar.put(this.m_iAnomPos, Character.valueOf('a'));
            }
        }
        for (Modification t_oMod : t_aEnMods) {
            if (this.replaceCarbonDescriptorByEnModification(t_oMod)) continue;
            throw new WURCSExchangeException("There is an error in the modification \"en\" or \"enx\".");
        }
        int t_nBrankPosition = 0;
        for (int i2 = 2; i2 < this.m_nCAtom; ++i2) {
            if (this.m_hashPosToChar.containsKey(i2)) continue;
            ++t_nBrankPosition;
        }
        String t_strStereo = this.convertBasetypesToStereoCode(a_oMS.getBaseType());
        if (t_strStereo != "" && t_strStereo.length() != t_nBrankPosition) {
            throw new WURCSExchangeException("There is the excess or shortage of the stereo information.");
        }
        int j = 0;
        for (i = 2; i < this.m_nCAtom; ++i) {
            if (this.m_hashPosToChar.containsKey(i)) continue;
            char t_cCD = t_strStereo == "" ? (char)'x' : (char)t_strStereo.charAt(j);
            this.m_hashPosToChar.put(i, Character.valueOf(t_cCD));
            ++j;
        }
        for (i = 0; i < this.m_nCAtom; ++i) {
            this.m_strSkeletonCode = this.m_strSkeletonCode + this.m_hashPosToChar.get(i + 1);
        }
    }

    private String convertBasetypesToStereoCode(ArrayList<BaseType> a_aBaseTypes) throws WURCSExchangeException {
        String t_strStereoCode = "";
        LinkedList<String> dlList = new LinkedList<String>();
        for (BaseType bs : a_aBaseTypes) {
            String code = bs.getStereoCode();
            if (bs.absoluteConfigurationUnknown()) {
                code = BaseTypeForRelativeConfiguration.forName(bs.getName()).getStereoCode();
            }
            if (code.endsWith("1")) {
                dlList.add("L");
            }
            if (code.endsWith("2")) {
                dlList.add("D");
            }
            t_strStereoCode = code + t_strStereoCode;
        }
        String dl = "X";
        if (dlList.size() > 0) {
            dl = (String)dlList.getLast();
        }
        this.m_cConfigurationalSymbol = dl.charAt(0);
        return t_strStereoCode;
    }

    private void convertSingleModificationToCarbonDescriptor(Modification a_oMod) throws WURCSExchangeException {
        int t_iPos = a_oMod.getPositionOne();
        boolean t_bIsTerminal = t_iPos == 1 || t_iPos == this.m_nCAtom;
        char t_cCD = this.convertModificationTypeToCarbonDescriptor(a_oMod.getModificationType());
        if (t_cCD == 'd' && t_bIsTerminal) {
            t_cCD = 'm';
        }
        if (t_cCD == 'O') {
            this.m_aAnomPositions.add(t_iPos);
            if (t_bIsTerminal) {
                t_cCD = 'o';
            }
        }
        if (t_iPos == 1) {
            this.m_bIsAldose = false;
        }
        if (t_iPos == 0) {
            if (t_cCD != 'd') {
                throw new WURCSExchangeException("Core modification at unknown position is not handled without DEOXY.");
            }
            this.m_aUnknownPosMAP.add("*");
        }
        if (t_cCD == 'h' && t_iPos != 1) {
            throw new WURCSExchangeException("Modification \"aldi\" is must set to first carbon.");
        }
        if (t_cCD == 'A' && !t_bIsTerminal) {
            throw new WURCSExchangeException("Can not do carboxylation to non-terminal carbon.");
        }
        if (t_cCD == ' ') {
            throw new WURCSExchangeException("Unknown modification is found.");
        }
        this.m_hashPosToChar.put(t_iPos, Character.valueOf(t_cCD));
    }

    private char convertModificationTypeToCarbonDescriptor(ModificationType a_oMod) {
        if (a_oMod == ModificationType.ALDI) {
            return 'h';
        }
        if (a_oMod == ModificationType.ACID) {
            return 'A';
        }
        if (a_oMod == ModificationType.DEOXY) {
            return 'd';
        }
        if (a_oMod == ModificationType.KETO) {
            return 'O';
        }
        return ' ';
    }

    private boolean replaceCarbonDescriptorByEnModification(Modification a_oMod) {
        int t_cCD2;
        int t_iPos1 = a_oMod.getPositionOne();
        int t_iPos2 = a_oMod.getPositionTwo();
        if (t_iPos1 == 0 && t_iPos2 == 0) {
            this.m_aUnknownPosMAP.add("**");
        }
        if (t_iPos2 == this.m_nCAtom) {
            int t_iPos = t_iPos2;
            t_iPos2 = t_iPos1;
            t_iPos1 = t_iPos;
        }
        boolean t_bAtTerminal = t_iPos1 == 1 || t_iPos1 == this.m_nCAtom;
        int t_cCD1 = this.m_hashPosToChar.containsKey(t_iPos1) ? (int)this.m_hashPosToChar.get(t_iPos1).charValue() : 32;
        int n = t_cCD2 = this.m_hashPosToChar.containsKey(t_iPos2) ? (int)this.m_hashPosToChar.get(t_iPos2).charValue() : 32;
        if (t_cCD1 == 111 || t_cCD1 == 65 || t_cCD2 == 79 || t_cCD2 == 67) {
            return false;
        }
        if (t_bAtTerminal && t_iPos1 == this.m_oMS.getRingEnd()) {
            if (t_cCD1 == 99) {
                this.m_hashPosToChar.put(t_iPos1, Character.valueOf('N'));
                this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'n' : 'N'));
                return true;
            }
            if (t_cCD1 == 104) {
                this.m_hashPosToChar.put(t_iPos1, Character.valueOf('z'));
                this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'z' : 'Z'));
                return true;
            }
            return false;
        }
        if (t_bAtTerminal && t_iPos2 == this.m_oMS.getRingEnd()) {
            if (t_cCD1 == 109) {
                this.m_hashPosToChar.put(t_iPos1, Character.valueOf('n'));
                this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'n' : 'N'));
                return true;
            }
            if (t_cCD1 == 104) {
                this.m_hashPosToChar.put(t_iPos1, Character.valueOf('f'));
                this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'f' : 'F'));
                return true;
            }
        }
        if (!t_bAtTerminal && t_iPos1 == this.m_oMS.getRingEnd()) {
            this.m_hashPosToChar.put(t_iPos1, Character.valueOf('F'));
            this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'f' : 'F'));
            return true;
        }
        if (t_bAtTerminal && t_iPos1 == this.m_oMS.getRingEnd()) {
            this.m_hashPosToChar.put(t_iPos1, Character.valueOf('z'));
            this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'z' : 'Z'));
            return true;
        }
        if (!t_bAtTerminal && t_iPos2 == this.m_oMS.getRingEnd()) {
            this.m_hashPosToChar.put(t_iPos1, Character.valueOf(t_cCD1 == 100 ? (char)'e' : 'E'));
            this.m_hashPosToChar.put(t_iPos2, Character.valueOf('E'));
            return true;
        }
        if (t_iPos1 > this.m_oMS.getRingStart() && t_iPos2 < this.m_oMS.getRingEnd()) {
            this.m_hashPosToChar.put(t_iPos1, Character.valueOf(t_cCD1 == 100 ? (char)'z' : 'Z'));
            this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'z' : 'Z'));
            return true;
        }
        if (t_cCD1 == 109) {
            this.m_hashPosToChar.put(t_iPos1, Character.valueOf('n'));
            this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'n' : 'N'));
            return true;
        }
        if (t_cCD1 == 104) {
            this.m_hashPosToChar.put(t_iPos1, Character.valueOf('f'));
            this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'f' : 'F'));
            return true;
        }
        this.m_hashPosToChar.put(t_iPos1, Character.valueOf(t_cCD1 == 100 ? (char)'f' : 'F'));
        this.m_hashPosToChar.put(t_iPos2, Character.valueOf(t_cCD2 == 100 ? (char)'f' : 'F'));
        return true;
    }
}

